/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 */

#ifndef ESPDR_WAVE_LFC_LFC_CAL_H
#define ESPDR_WAVE_LFC_LFC_CAL_H


/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_fit.h>
#include <espdr_led_flat.h>
#include <espdr_extraction.h>
#include <espdr_pixels.h>
#include <espdr_wave_THAR_cal.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define SAVE_DEBUG_PRODUCT_WAVE_LFC_LFC 0


/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_wave_LFC_LFC(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_WAVE_LFC_LFC_create(const char* recipe_id,
                                                 cpl_parameterlist *list,
                                                 espdr_WAVE_LFC_LFC_param *p);

cpl_error_code espdr_parameters_WAVE_LFC_LFC_delete(espdr_WAVE_LFC_LFC_param* p);

cpl_error_code espdr_parameters_WAVE_LFC_LFC_get(const char* recipe_id,
                                              cpl_parameterlist* param_list,
                                              espdr_WAVE_LFC_LFC_param *WAVE_LFC_LFC_param);

cpl_error_code espdr_parameters_WAVE_LFC_LFC_print(espdr_WAVE_LFC_LFC_param *WAVE_LFC_LFC_param);

espdr_WAVE_LFC_LFC_param *espdr_WAVE_LFC_LFC_param_init(const char *recipe_id,
                                                  cpl_parameterlist *parameters);

cpl_error_code espdr_wave_LFC_LFC_read_parameters(cpl_frameset *frameset,
                                               espdr_CCD_geometry *CCD_geom,
                                               espdr_inst_config *inst_config);

cpl_error_code espdr_wave_LFC_LFC_QC(int orders_nb,
                                  espdr_src_type fibre_source,
                                  espdr_inst_config *inst_config,
                                  espdr_CCD_geometry *CCD_geom,
                                  espdr_qc_keywords *qc_kws,
                                  cpl_propertylist *keywords_RE);

#endif /* ESPDR_WAVE_LFC_LFC_CAL_H */
