# import the needed modules
from __future__ import absolute_import
from __future__ import print_function

try:
    import reflex

    import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")

# import the needed modules
try:
    #  import sys
    import numpy

    try:
        from astropy.io import fits as pyfits
    except ImportError:
        import pyfits

    import espdr_discrete_slider
    import espdr_plot_common
    import espdr_parameters_common
    #  import wx
    #  import matplotlib
    import reflex
    # from xsh_plot_common import *
    from reflex import parseSofJson, RecipeParameter
    from reflex_interactive_app import PipelineInteractiveApp
    import reflex_plot_widgets
    from pipeline_product import PipelineProduct
    from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay

    #  matplotlib.use('WXAgg')
    import_sucess = 'true'
    import warnings

    warnings.simplefilter('ignore', UserWarning)


    # NOTE for developers:
    # -If you want to modify the current script to cope
    #  with different parameters, this is the function to modify:
    #  setInteractiveParameters()
    # -If you want to modify the current script to read different data from
    #  the input FITS, these are the functions (class DataPlotterManager) to modify:
    #  readFitsData()    to indicate what are the FITS input to plot
    #  plotSpectrum()    to control 1D image product layout
    #  setRecId()        to set rec id (used in parameter prefix)
    #  getArmId()        to get arm id FITS header info
    #
    # -If you want to modify the current script to modify the plots (using the same
    #  data),  this is the function to modify:
    #  plotProductsGraphics()          (from class DataPlotterManager)
    # -If you want to modify the text that appears in the "Help" button,
    #  this is the function to modify:
    #  setWindowHelp()
    # -If you want to modify the title of the window, modify this function:
    #  setWindowTitle()

    # This class deals with the specific details of data reading and final plotting.
    class DataPlotterManager:

        # This function will read all the columns, images and whatever is needed
        # from the products. The variables , self.plot_x, self.plot_y, etc...
        # are used later in function plotProductsGraphics().
        # Add/delete these variables as you need (only that plotProductsGraphics()
        # has to use the same names).
        # You can also create some additional variables (like statistics) after
        # reading the files.
        # If you use a control variable (self.xxx_found), you can modify
        # later on the layout of the plotting window based on the presence of
        # given input files.
        # sof contains all the set of frames
        def readFitsData(self, fitsFiles):
            # Control variable to check if the interesting files where at the input
            # print fitsFiles
            self.fibre_id = 'fib A'
            self.nima = 0
            self.binx = 1
            self.biny = 1
            self.fibre_id = 'fib A'
            self.order_id = 10
            self.ext_ima = 1
            self.product_id = 'REL_EFF_B'
            self.labels_fib = ['fib A', 'fib B']
            self.labels_prod = ['REL_EFF_B']
            self.rel_eff_b_found = False
            # Read all the products
            frames = dict()
            # print(frames)
            for frame in fitsFiles:
                if frame == '':
                    continue

                header = pyfits.open(frame.name)
                # Make sure to have only products from the same recipe
                # that used this (common) script
                # print "rec_id=", self.rec_id
                if 'ESO PRO REC1 ID' in header[0].header:
                    rec_id = header[0].header['ESO PRO REC1 ID']
                    # print "rec_id=", rec_id
                    if rec_id == self.rec_id:
                        category = frame.category
                        frames[category] = frame
                        # print("frame name:", frame.name)

            # For any arm search a list of input frames
            # print frames
            key = "REL_EFF_B"
            if key in frames:
                hdulist = frames[key]
                self.ref_eff_b_found = True
                hdulist = frames[key]
                self.rel_eff_b = PipelineProduct(hdulist)
                # print("found", key)
                key = 'ESO INS MODE'
                self.ins_mode = self.rel_eff_b.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 170
                elif self.ins_mode == 'HE':
                    self.ord_max = 71
                elif self.ins_mode == 'HA':
                    self.ord_max = 71
                else:
                    self.ord_max = 86

                self.rel_eff_b_found = True
                self.eff_ab_found = True
                self.eff_ab = list()
                self.order_nb_a = list()
                port = 0
                for ord in range(1, self.ord_max):
                    key = 'ESO QC ORDER%#.1d SNR' % (ord)
                    # print key
                    self.order_nb_a.append(ord)
                    self.eff_ab.append(self.rel_eff_b.readKeyword(key))

                key = 'ESO QC EFFAB CHECK'
                self.qc_effab_check = self.rel_eff_b.readKeyword(key)

                # Set rec id (to have proper recipe parameters prefix)

        def setRecId(self, rec_id):
            # Recipe ID variable to properly define params
            self.rec_id = rec_id

        # Get arm setting
        def getArmId(self, sof):
            # Recipe ID variable to properly define params
            self.rec_id = "espdr_cal_eff_ab"
            nf = 0

            frames = dict()
            files = sof.files
            for f in files:
                frame = f.name
                if frame == '':
                    continue
                else:
                    nf += 1
                    hdulist = pyfits.open(frame)
                    rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
            if nf != 0:
                self.rec_id = rec_id_list[0:]

            # print "self.rec_id", self.rec_id
            if self.rec_id == "espdr_cal_eff_ab":
                self.rec_subtitle = "Fibre Relative Efficiency Computation. "

        # This function creates all the subplots. It is responsible for the plotting
        # layouts.
        # There can different layouts, depending on the availability of data
        # Note that subplot(I,J,K) means the Kth plot in a IxJ grid
        # Note also that the last one is actually a box with text, no graphs.
        def addSubplots(self, figure):
            nrows = self.nima
            # print "eff_ab:", self.rel_eff_b_found
            if self.rel_eff_b_found == True:

                self.subplot_image = figure.add_subplot(3, 1, 1)
                self.subplot_spectrum = figure.add_subplot(3, 1, 2)
                self.subplot_scatter = figure.add_subplot(3, 1, 3)
                # self.fibre_selector = figure.add_axes([0.85, 0.44, 0.10, 0.10])
                # self.product_selector = figure.add_axes([0.10, 0.64, 0.35, 0.10])

            else:
                self.subtext_nodata = figure.add_subplot(1, 1, 1)

        def setOrderSelectCallBack(self, order_id):

            self.order_id = int(order_id)
            self.subplot_spectrum.cla()
            self.plotSpectrum()

        def setProductSelectCallBack(self, product_id):
            self.product_id = product_id
            p_len = len(self.product_id)
            if self.fibre_id == 'fib A' and self.product_id[-1] == 'B':
                self.product_id = self.product_id[0:p_len - 1] + 'A'
                self.labels_prod = ['REL_EFF_B']

                # print("New product id:",self.product_id)
            elif self.fibre_id == 'fib B' and self.product_id[-1] == 'A':
                self.product_id = self.product_id[0:p_len - 1] + 'B'
                self.labels_prod = ['REL_EFF_B']
                # print("New product id:",self.product_id)

            self.subplot_image.cla()
            self.subplot_spectrum.cla()
            # print("product_id:", self.product_id)
            self.plotSpectrum()
            self.plotImage()

        def setFibreSelectCallBack(self, fibre_id):
            self.fibre_id = fibre_id
            p_len = len(self.product_id)
            if self.fibre_id == 'fib A' and self.product_id[-1] == 'B':
                self.product_id = self.product_id[0:p_len - 1] + 'A'
            elif self.fibre_id == 'fib B' and self.product_id[-1] == 'A':
                self.product_id = self.product_id[0:p_len - 1] + 'B'

            self.subplot_image.cla()
            self.subplot_spectrum.cla()
            self.plotImage()
            self.plotSpectrum()

        def preparePlotQC(self):
            self.xLab = 'Order number'
            self.yLab = 'SNR'
            self.x = self.order_nb_a
            self.y = self.eff_ab
            self.title = 'SNR vs Order number.'
            self.tooltip_note = " The two colors (blue and green) corresponds to results obtained for Slices 1 and 2 respectively"
            self.tooltip = 'plot of the SNR vs Order number' + self.tooltip_note

        def prepTitleAndTooltipSpectrum(self):

            self.title_spectrum = 'Relative Efficiency.'
            self.tooltip_note = " Slices 1 and 2 have different relative efficiencies (different optical path in the spectrograph)"
            self.tooltip_spectrum = "Plot of the " + self.title_spectrum + self.tooltip_note

        def prepTitleAndTooltipImage(self):

            if self.product_id == 'REL_EFF_B':
                self.obj = self.rel_eff_b
                self.spc = self.rel_eff_b

            sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']
            self.ima_sy = sy

            title_pref = 'Linear-extracted and Merged Spectrum.'

            tooltip_spectrum = """\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """

            title_spectrum = title_pref

            # Image
            spec_frameON = ''
            # print "Recipe ID:",self.rec_id
            if self.rec_id == "espdr_cal_eff_ab":
                if self.fibre_id == 'fib A':
                    spec_frame = 'Relative Efficency frame fibB/fibA '
                else:
                    spec_frame = 'Relative Efficency frame fibB/fibA '
            self.tooltip_frameON = """\
        overscan corrected relative efficiency frame image (wavelength, order). 
        """
            self.tooltip_note = " Slices 1 and 2 have different relative efficiencies (different optical path in the spectrograph)"
            self.tooltip_frameON = self.tooltip_frameON + self.tooltip_note
            self.title_frame = spec_frame
            self.dpm.verify_qc_check(self.subplot_image, self.qc_effab_check, 1.15)

        def plotImage(self):
            self.prepTitleAndTooltipImage()
            self.dpm.plotImageOnly(self.obj, self.ext_ima, self.binx, self.biny, 'X [pix]', 'Order number',
                                   self.subplot_image, self.title_frame, self.tooltip_frameON)

        def plotSpectrum(self):
            self.prepTitleAndTooltipSpectrum()
            self.dpm.plotImageSlice2(self.spc, self.spc, self.order_id, self.subplot_spectrum, self.title_frame,
                                     self.tooltip_spectrum, 'Order number', '', type='v-plot')

        def plotQC(self):
            self.preparePlotQC()
            self.dpm.scatterPlotScatter3(self.subplot_scatter, self.x, self.y, self.xLab, self.yLab, self.title,
                                         self.tooltip)

        def caseNodata(self):
            # Data not found info
            self.subtext_nodata.set_axis_off()
            self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
            self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c',
                                     fontsize=18, ha='left', va='center', alpha=1.0)
            self.subtext_nodata.tooltip = """\
                                    Merged spectrum not found in the products"""
            # print "found no spectrum data"

        # This is the function that makes the plots.
        # Add new plots or delete them using the given scheme.
        # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
        # It is mandatory to add a tooltip variable to each subplot.
        # One might be tempted to merge addSubplots() and plotProductsGraphics().
        # There is a reason not to do it: addSubplots() is called only once at
        # startup, while plotProductsGraphics() is called always there is a resize.
        def plotProductsGraphics(self):
            if (self.rel_eff_b_found == True):

                self.dpm = espdr_plot_common.DataPlotterManager()
                self.plotImage()
                self.plotSpectrum()
                self.plotQC()

            else:
                self.caseNodata()

        # This function specifies which are the parameters that should be presented
        # in the window to be edited.
        # Note that the parameter has to be also in the in_sop port (otherwise it
        # won't appear in the window)
        # The descriptions are used to show a tooltip. They should match one to one
        # with the parameter list
        # Note also that parameters have to be prefixed by the 'recipe name:'

        def setInteractiveParameters(self):
            paramList = list()
            rec_id = self.rec_id
            self.par = espdr_parameters_common.Parameters()
            group = "general"
            # self.par.setGeneralCalibParameters(paramList,rec_id,group)
            if rec_id == "espdr_cal_eff_ab":
                self.par.setEffABParameters(paramList, "espdr_cal_eff_ab", group)
            else:
                print("recipe", rec_id, "not supported")

            return paramList

        def setWindowHelp(self):
            help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
            return help_text

        def setWindowTitle(self):
            title = 'ESPRESSO Interactive Workflow: ' + self.rec_subtitle
            return title

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")
    raise

# This is the 'main' function
if __name__ == '__main__':

    # import reflex modules
    from reflex import *
    from reflex_interactive_app import *
    from pipeline_display import *
    from pipeline_product import *

    # Create interactive application
    interactive_app = PipelineInteractiveApp(enable_init_sop=True)

    # PECULIAR XSH needs this in order to be able later to get from an input FITS
    # the ins-mode, arm (and recipe) IDs, used in titles and param setting
    # get inputs from the command line
    interactive_app.parse_args()
    inputs = interactive_app.inputs
    # (inputs, args) = interactive_app.parse_args()

    # Check if import failed or not
    if import_sucess == 'false':
        interactive_app.setEnableGUI(false)

    # interactive_app.setEnableGUI(True)
    # Open the interactive window if enabled
    if interactive_app.isGUIEnabled():
        # Get the specific functions for this window
        dataPlotManager = DataPlotterManager()
        # print inputs.in_sof
        # dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
        # With the following call XSH get the: ins-mode, arm (and recipe) IDs
        dataPlotManager.getArmId(inputs.in_sof)
        # Set recipe ID in order to build proper param list, display layout
        dataPlotManager.setRecId("espdr_cal_eff_ab")

        interactive_app.setPlotManager(dataPlotManager)
        interactive_app.showGUI()
    else:
        interactive_app.passProductsThrough()

    # Print outputs. This is parsed by the Reflex python actor to get the results
    # Do not remove
    interactive_app.print_outputs()
    sys.exit()
