# import the needed modules
from __future__ import absolute_import
from __future__ import print_function

try:
    import reflex

    import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")

# import the needed modules
try:
    #  import sys
    import numpy

    try:
        from astropy.io import fits as pyfits
    except ImportError:
        import pyfits

    import espdr_plot_common
    import espdr_parameters_common
    #  import wx
    #  import matplotlib
    import reflex
    # from xsh_plot_common import *
    from reflex import parseSofJson, RecipeParameter
    from reflex_interactive_app import PipelineInteractiveApp
    import reflex_plot_widgets
    from pipeline_product import PipelineProduct
    from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay

    #  matplotlib.use('WXAgg')
    import_sucess = 'true'
    import warnings

    warnings.simplefilter('ignore', UserWarning)


    # NOTE for developers:
    # -If you want to modify the current script to cope
    #  with different parameters, this is the function to modify:
    #  setInteractiveParameters()
    # -If you want to modify the current script to read different data from
    #  the input FITS, these are the functions (class DataPlotterManager) to modify:
    #  readFitsData()    to indicate what are the FITS input to plot
    #  oplotTable()      to control 1D table product overplots
    #  setRecId()        to set rec id (used in parameter prefix)
    #  getArmId()        to get arm id FITS header info
    #
    # -If you want to modify the current script to modify the plots (using the same
    #  data),  this is the function to modify:
    #  plotProductsGraphics()          (from class DataPlotterManager)
    # -If you want to modify the text that appears in the "Help" button,
    #  this is the function to modify:
    #  setWindowHelp()
    # -If you want to modify the title of the window, modify this function:
    #  setWindowTitle()

    # This class deals with the specific details of data reading and final plotting.
    class DataPlotterManager:

        # This function will read all the columns, images and whatever is needed
        # from the products. The variables , self.plot_x, self.plot_y, etc...
        # are used later in function plotProductsGraphics().
        # Add/delete these variables as you need (only that plotProductsGraphics()
        # has to use the same names).
        # You can also create some additional variables (like statistics) after
        # reading the files.
        # If you use a control variable (self.xxx_found), you can modify
        # later on the layout of the plotting window based on the presence of
        # given input files.
        # sof contains all the set of frames
        def readFitsData(self, fitsFiles):
            # Control variable to check if the interesting files where at the input

            self.order_tab_found = False
            self.fibre_id = 'fib A'
            self.arm_id = 'Blue'
            self.product_id = 'RES STDEV'
            self.labels_prod = ['RES STDEV', 'RES MIN', 'RES MAX']

            self.frameON_found = False
            self.nima = 0
            self.binx = 1
            self.biny = 1

            # Read all the products
            frames = dict()
            for frame in fitsFiles:
                if frame == '':
                    continue

                header = pyfits.open(frame.name)
                # Make sure to have only products from the same recipe
                # that used this (common) script
                if 'ESO PRO REC1 ID' in header[0].header:
                    rec_id = header[0].header['ESO PRO REC1 ID']
                    self.instrume = header[0].header['INSTRUME']
                    if rec_id == self.rec_id:
                        category = frame.category
                        frames[category] = frame
                        print("frame name:", frame.name)

            # For any arm search a list of input frames
            # print frames
            key = "ORDER_TABLE_A"
            if key in frames:
                self.order_tab_found = True
                hdulist = frames[key]
                self.order_tab_a = PipelineProduct(hdulist)
                self.frameON_found = True
                # print("order table A")
                key = 'ESO INS MODE'
                self.ins_mode = self.order_tab_a.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 90
                elif self.ins_mode == 'HARPS':
                    self.ord_max = 26
                else:
                    self.ord_max = 46
                self.res_rms_a = list()
                self.res_min_a = list()
                self.res_max_a = list()
                self.order_nb_a = list()
                port = 0
                for ord in range(1, self.ord_max):
                    key = 'ESO QC ORDER%#.1d EXT0 RES STDEV' % (ord)
                    # print key
                    self.order_nb_a.append(ord)
                    self.res_rms_a.append(self.order_tab_a.readKeyword(key))

                    key = 'ESO QC ORDER%#.1d EXT0 RES MIN' % (ord)
                    self.res_min_a.append(self.order_tab_a.readKeyword(key))

                    key = 'ESO QC ORDER%#.1d EXT0 RES MAX' % (ord)
                    self.res_max_a.append(self.order_tab_a.readKeyword(key))

                key = 'ESO QC ORDERDEF CHECK'
                self.qc_orderdef_check = self.order_tab_a.readKeyword(key)

            key = "ORDER_TABLE_B"
            if key in frames:
                self.order_tab_found = True
                hdulist = frames[key]
                self.order_tab_b = PipelineProduct(hdulist)
                self.frameON_found = True
                # print("order table B")
                key = 'ESO INS MODE'
                self.ins_mode = self.order_tab_b.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 80
                elif self.ins_mode == 'HARPS':
                    self.ord_max = 26
                else:
                    self.ord_max = 41

                self.res_rms_b = list()
                self.res_min_b = list()
                self.res_max_b = list()
                self.order_nb_b = list()
                key = 'INSTRUME'
                instrume = self.order_tab_b.readKeyword(key)
                if instrume == 'ESPRESSO':
                    ext_no = '1'
                else:
                    ext_no = '0'

                port = 0
                for ord in range(1, self.ord_max):
                    key = 'ESO QC ORDER%#.1d ' % (ord) + 'EXT' + ext_no + ' RES STDEV'
                    # print key
                    self.order_nb_b.append(ord)
                    self.res_rms_b.append(self.order_tab_b.readKeyword(key))

                    key = 'ESO QC ORDER%#.1d ' % (ord) + 'EXT' + ext_no + ' RES MIN'
                    self.res_min_b.append(self.order_tab_b.readKeyword(key))

                    key = 'ESO QC ORDER%#.1d ' % (ord) + 'EXT' + ext_no + ' RES MAX'
                    self.res_max_b.append(self.order_tab_b.readKeyword(key))

                key = 'ESO QC ORDERDEF CHECK'
                self.qc_orderdef_check = self.order_tab_b.readKeyword(key)

                # Set rec id (to have proper recipe parameters prefix)

        def setRecId(self, rec_id):
            # Recipe ID variable to properly define params
            self.rec_id = rec_id

        # Get arm setting
        def getArmId(self, sof):
            # Recipe ID variable to properly define params
            self.rec_id = "espdr_orderdef"
            nf = 0

            frames = dict()
            files = sof.files
            for f in files:
                frame = f.name
                if frame == '':
                    continue
                else:
                    nf += 1
                    hdulist = pyfits.open(frame)
                    rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
                    self.instrume = hdulist[0].header['INSTRUME']
            if nf != 0:
                self.rec_id = rec_id_list[0:]

            if self.rec_id == "espdr_orderdef":
                self.rec_subtitle = "Order Tracing. "

        # This function creates all the subplots. It is responsible for the plotting
        # layouts.
        # There can different layouts, depending on the availability of data
        # Note that subplot(I,J,K) means the Kth plot in a IxJ grid
        # Note also that the last one is actually a box with text, no graphs.

        def addSubplots(self, figure):

            if self.order_tab_found == True:
                self.fibre_selector = figure.add_axes([0.85, 0.44, 0.10, 0.08], aspect='equal')
                self.arm_selector = figure.add_axes([0.75, 0.44, 0.10, 0.08])
                self.product_selector = figure.add_axes([0.05, 0.44, 0.15, 0.08])
                # self.product_selector = figure.add_axes([0.05, 0.42, 0.20, 0.12],aspect='equal')
                self.subplot_frame_ima = figure.add_subplot(2, 1, 1)
                self.subplot_scatter = figure.add_subplot(2, 1, 2)
                # self.subplot_frame_low  = figure.add_subplot(2,1,2)

            else:
                self.subtext_nodata = figure.add_subplot(1, 1, 1)

        def plotWidgets(self):
            widgets = list()
            labels_fib = ['fib A', 'fib B']
            # Files Selector radiobutton
            self.radiobutton = reflex_plot_widgets.InteractiveRadioButtons(self.fibre_selector,
                                                                           self.setFibreSelectCallBack, labels_fib, 0,
                                                                           title="")
            widgets.append(self.radiobutton)

            labels_arm = ['Blue', 'Red']
            self.radiobutton = reflex_plot_widgets.InteractiveRadioButtons(self.arm_selector, self.setArmSelectCallBack,
                                                                           labels_arm, 0,
                                                                           title="")
            widgets.append(self.radiobutton)

            labels_prod = self.labels_prod
            self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector,
                                                                               self.setProductSelectCallBack,
                                                                               labels_prod, 0, title="")
            widgets.append(self.radiobutton_pro)
            return widgets

        def setProductSelectCallBack(self, product_id):
            self.product_id = product_id
            self.subplot_scatter.cla()
            self.plotQC()

        def setFibreSelectCallBack(self, fibre_id):
            fibre_id = fibre_id
            self.fibre_id = fibre_id
            self.subplot_frame_ima.cla()
            self.subplot_scatter.cla()
            self.plotImage()
            self.plotQC()

        def setArmSelectCallBack(self, arm_id):
            fibre_id = arm_id
            self.arm_id = arm_id
            self.subplot_frame_ima.cla()
            self.subplot_scatter.cla()
            self.plotImage()
            self.plotQC()

        def preparePlotQC(self):
            title = ''
            tooltip = ''
            xLab = 'Order number'
            if self.fibre_id == 'fib A':
                x = self.order_nb_a
            else:
                x = self.order_nb_b

            if self.fibre_id == 'fib A':
                if self.product_id == 'RES STDEV':
                    y = self.res_rms_a
                    yLab = 'RMS residuals [pix]'
                elif self.product_id == 'RES MIN':
                    y = self.res_min_a
                    yLab = 'MIN residuals [pix]'
                elif self.product_id == 'RES MAX':
                    y = self.res_max_a
                    yLab = 'MAX residuals [pix]'
            else:
                if self.product_id == 'RES STDEV':
                    y = self.res_rms_b
                    yLab = 'RMS residuals [pix]'
                elif self.product_id == 'RES MIN':
                    y = self.res_min_b
                    yLab = 'MIN residuals [pix]'
                elif self.product_id == 'RES MAX':
                    y = self.res_max_b
                    yLab = 'MAX residuals [pix]'

            self.x = x
            self.y = y
            title = yLab
            self.xLab = xLab
            self.yLab = yLab
            self.title = ''
            self.tooltip_note = ". The two colors (blue and green) corresponds to results obtained for Slices 1 and 2 respectively"
            self.tooltip = 'plot of ' + title + self.tooltip_note

        def preparePlotImage(self):
            if self.fibre_id == 'fib A':
                self.obj = self.order_tab_a
                self.spc = self.order_tab_a
            elif self.fibre_id == 'fib B':
                self.obj = self.order_tab_b
                self.spc = self.order_tab_b

            if self.arm_id == 'Blue':
                self.ext_ima = 1
            else:
                self.ext_ima = 2

            if self.arm_id == 'Blue':
                self.ext_tab = 3
            else:
                self.ext_tab = 4

        def prepTitleAndTooltipImage(self):
            title_pref = 'Linear-extracted and Merged Spectrum.'

            tooltip_spectrum = """\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """
            title_spectrum = title_pref

            # Image
            spec_frameON = ''
            if self.rec_id == "espdr_orderdef":
                if self.fibre_id == 'fib A':
                    spec_frame = 'Orderdef flat fib A '
                else:
                    spec_frame = 'Orderdef flat fib B '

                self.tooltip_frameON = """\
           Bias corrected order fibre flat lamp 
           image. 
           """
                # Green points trace each detected order.

            self.title_frame = spec_frame + 'Image'
            self.dpm.verify_qc_check(self.subplot_frame_ima, self.qc_orderdef_check, 1.1)

        def plotImage(self):
            self.prepTitleAndTooltipImage()
            self.preparePlotImage()
            self.sx = self.obj.all_hdu[self.ext_ima].header['NAXIS1']
            self.sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']

            self.dpm.plotImageOrderdef(self.obj, self.ext_ima, self.ext_tab, self.binx, self.biny, 'X [pix]', 'Y [pix]',
                                       'X', 'Y', self.subplot_frame_ima, self.title_frame, self.tooltip_frameON)
            # print 'sx again',self.sx
            # self.dpm.oplotImageScatterTrace(self.obj,self.ext_tab,self.sx,self.subplot_frame_ima, marker = '+', size = 3, color = 'green')

        def plotQC(self):
            self.preparePlotQC()
            self.dpm.scatterPlotScatter3(self.subplot_scatter, self.x, self.y, self.xLab, self.yLab, self.title,
                                         self.tooltip, 2)

        def caseNodata(self):
            # Data not found info
            self.subtext_nodata.set_axis_off()
            self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
            self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c',
                                     fontsize=18, ha='left', va='center', alpha=1.0)
            self.subtext_nodata.tooltip = """\
                                    Merged spectrum not found in the products"""

        # This is the function that makes the plots.
        # Add new plots or delete them using the given scheme.
        # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
        # It is mandatory to add a tooltip variable to each subplot.
        # One might be tempted to merge addSubplots() and plotProductsGraphics().
        # There is a reason not to do it: addSubplots() is called only once at
        # startup, while plotProductsGraphics() is called always there is a resize.
        def plotProductsGraphics(self):
            if (self.order_tab_found == True):
                self.dpm = espdr_plot_common.DataPlotterManager()
                self.plotImage()
                self.plotQC()

            else:
                self.caseNodata()

        # This function specifies which are the parameters that should be presented
        # in the window to be edited.
        # Note that the parameter has to be also in the in_sop port (otherwise it
        # won't appear in the window)
        # The descriptions are used to show a tooltip. They should match one to one
        # with the parameter list
        # Note also that parameters have to be prefixed by the 'recipe name:'

        def setInteractiveParameters(self):
            paramList = list()
            rec_id = self.rec_id
            self.par = espdr_parameters_common.Parameters()
            # self.par.setGeneralCalibParameters(paramList,rec_id)

            if rec_id == "espdr_orderdef":
                self.par.setOrderdefParameters(paramList, "espdr_orderdef", "all")
            else:
                print("recipe", rec_id, "not supported")

            return paramList

        def setWindowHelp(self):
            help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
            return help_text

        def setWindowTitle(self):
            title = self.instrume + ' Interactive Workflow: ' + self.rec_subtitle
            return title

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")
    raise

# This is the 'main' function
if __name__ == '__main__':

    # import reflex modules
    from reflex import *
    from reflex_interactive_app import *
    from pipeline_display import *
    from pipeline_product import *

    # Create interactive application
    interactive_app = PipelineInteractiveApp(enable_init_sop=True)

    # PECULIAR XSH needs this in order to be able later to get from an input FITS
    # the ins-mode, arm (and recipe) IDs, used in titles and param setting
    # get inputs from the command line
    interactive_app.parse_args()
    inputs = interactive_app.inputs
    # (inputs, args) = interactive_app.parse_args()

    # Check if import failed or not
    # print("import_sucess=", import_sucess)
    if import_sucess == 'false':
        interactive_app.setEnableGUI(false)

    # print interactive_app.isGUIEnabled()
    # interactive_app.setEnableGUI(True)
    # Open the interactive window if enabled
    if interactive_app.isGUIEnabled():
        # Get the specific functions for this window
        dataPlotManager = DataPlotterManager()
        # print inputs.in_sof
        # dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
        # With the following call XSH get the: ins-mode, arm (and recipe) IDs
        dataPlotManager.getArmId(inputs.in_sof)
        # Set recipe ID in order to build proper param list, display layout
        dataPlotManager.setRecId("espdr_orderdef")

        interactive_app.setPlotManager(dataPlotManager)
        interactive_app.showGUI()

    else:
        interactive_app.passProductsThrough()

    # Print outputs. This is parsed by the Reflex python actor to get the results
    # Do not remove
    interactive_app.print_outputs()
    sys.exit()
