/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_DETECTOR_SIGNATURE_H
#define ESPDR_DETECTOR_SIGNATURE_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_keywords.h>
#include <espdr_pixels.h>
#include <espdr_preprocessing.h>
#include <espdr_dfs.h>
#include <espdr_bias.h>
#include <espdr_cte.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_check_saturation(
        cpl_imagelist *input_iml,
        espdr_CCD_geometry *CCD_geom,
        espdr_inst_config *inst_config,
        cpl_imagelist *pixels_mask,
        double cosmics_part,
        double *max_flux,
        int print_max_flux,
        cpl_imagelist **sat_mask_RE);

cpl_error_code espdr_create_saturation_mask(
        cpl_imagelist *input_imagelist, // move to utils or other
        cpl_imagelist *hot_bad_pixels_mask,
        double satur_limit_adu,
        cpl_imagelist **saturation_mask_RE);

cpl_error_code espdr_remove_det_signature_one_output(
        cpl_image *input_image,
        const cpl_image *orders_mask_image,
		const cpl_image *master_bias_image,
        cpl_image *master_dark_image,
		cpl_propertylist *keywords,
		cpl_propertylist *keywords_HP,
		cpl_propertylist *keywords_BP,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		const int remove_bias_res,
		const int ext_no,
		const int out_x,
		const int out_y,
		const espdr_CCD_geometry *CCD_geom,
		double *CONAD_RE,
		double *DARK_RE,
        double *DARK_RON_RE,
		double *RON_RE,
		cpl_image **input_corrected_RE);

cpl_error_code espdr_remove_det_signature(
        cpl_imagelist *input_imagelist,
        const cpl_imagelist *orders_mask_imagelist,
		const cpl_imagelist *master_bias_imagelist,
        cpl_imagelist *master_dark_imagelist,
		cpl_propertylist *keywords,
		cpl_propertylist *keywords_HP,
		cpl_propertylist *keywords_BP,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		const int remove_bias_res,
		const espdr_CCD_geometry *CCD_geom,
		const cpl_type image_type,
		double *RON,
		double *DARK,
        double *DARK_RON,
		double *CONAD,
		cpl_imagelist *input_corrected_RE);

cpl_error_code espdr_remove_dark_current_one_output(
        cpl_image *input_imagelist,
        cpl_image *master_dark_img,
		cpl_propertylist *keywords,
		const double exp_time,
		const int ext_no,
		const int out_x,
		const int out_y,
		const espdr_CCD_geometry *CCD_geom,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		double *DARK_RE,
        double *DARK_RON_RE,
		cpl_image **input_corrected_RE);

cpl_error_code espdr_remove_dark_current(
        cpl_imagelist *input_imagelist,
        cpl_imagelist *master_dark_iml,
		cpl_propertylist *keywords,
		const double exp_time,
		const espdr_CCD_geometry *CCD_geom,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		double *DARK_RE,
        double *DARK_RON_RE,
		cpl_imagelist *input_corrected_RE);

cpl_error_code espdr_apply_gain_one_output(
        const cpl_image *input_image,
		cpl_propertylist *keywords,
		const int ext_no,
		const int out_x,
		const int out_y,
		const espdr_CCD_geometry *CCD_geom,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		double *conad_RE,
		cpl_image **input_corrected_RE);

cpl_error_code espdr_apply_gain(
        const cpl_imagelist *input_imagelist,
		cpl_propertylist *keywords,
		const espdr_CCD_geometry *CCD_geom,
		espdr_qc_keywords *qc_kws,
		espdr_inst_config *inst_config,
		double *conad_RE,
		cpl_imagelist *input_corrected_RE);

cpl_error_code espdr_correct_geometry(
        const cpl_imagelist *input_imagelist,
		const espdr_CCD_geometry *CCD_geom,
		cpl_imagelist *input_corrected_RE);

cpl_error_code espdr_get_max_flux_ignoring_cosmics(
        const cpl_imagelist *input_iml,
		const cpl_imagelist *mask_iml,
		const double rejected_part,
		double *max_fluxes_RE);

cpl_error_code espdr_get_high_flux_rejection_bound(
        const cpl_image *input_image,
		const cpl_image *mask,
		const double rejected_part,
		double *bound);


#endif /* ESPDR_DETECTOR_SIGNATURE_H */
