/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2017-12-04 19:28:49 +0100 (Mon, 04 Dec 2017) $
 * $Revision: 212639 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_WAVE_LFC_CAL_H
#define ESPDR_WAVE_LFC_CAL_H


/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_fit.h>
#include <espdr_led_flat.h>
#include <espdr_extraction.h>
#include <espdr_pixels.h>
#include <espdr_wave_THAR_cal.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
//#define MAX_NB_SPECTRAL_LINES 100000.0
//#define MAX_NB_GROUP_LINES 100

#define N_AIR_COEFF_T 15.0
#define N_AIR_COEFF_P 760.0

#define SAVE_DEBUG_PRODUCT_WAVE_LFC 0

/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

int espdr_wave_LFC(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_WAVE_LFC_create(const char* recipe_id,
                                                cpl_parameterlist *list,
                                                espdr_WAVE_LFC_param *p);

cpl_error_code espdr_parameters_WAVE_LFC_delete(espdr_WAVE_LFC_param* p);

cpl_error_code espdr_parameters_WAVE_LFC_get(const char* recipe_id,
                                             cpl_parameterlist* list,
                                             espdr_WAVE_LFC_param *WAVE_LFC_param);

cpl_error_code espdr_parameters_WAVE_LFC_print(espdr_WAVE_LFC_param *WAVE_LFC_param);

espdr_WAVE_LFC_param *espdr_WAVE_LFC_param_init(const char *recipe_id,
                                                cpl_parameterlist *parameters);

cpl_error_code espdr_wave_LFC_read_parameters(cpl_frameset *frameset,
                                              espdr_CCD_geometry *CCD_geom,
                                              espdr_inst_config *inst_config);

cpl_error_code espdr_search_LFC_lines(cpl_image *s2d_data,
                                      cpl_image *s2d_error,
                                      cpl_image *s2d_quality,
                                      cpl_table *wave_matrix,
                                      int CCD_border_cut,
                                      double flux_threshold,
                                      double noise_threshold,
                                      espdr_line_param *lines_table,
                                      int *lines_nb_RE);

cpl_error_code espdr_assign_comb_wavelengths(espdr_line_param *lines_table,
                                             double **wave_matrix,
                                             double repetition_rate,
                                             double anchor_frequency);

cpl_error_code espdr_clean_LFC_lines_table(espdr_line_param *lines_table,
                                           espdr_line_param *lines_table_final,
                                           double spectral_line_qc,
                                           espdr_src_type fibre_source,
                                           int *lines_nb_RE);

cpl_error_code espdr_LFC_lines_qc(espdr_line_param *lines_table,
                                  int lines_nb,
                                  espdr_inst_config *inst_config,
                                  int *lines_nb_per_order_RE);

cpl_error_code espdr_merge_LFC_THAR(cpl_image *LFC_wave_matrix,
                                    cpl_image *THAR_wave_matix,
                                    int *LFC_fitted_orders,
                                    cpl_image **wave_matrix_RE,
                                    cpl_image **air_wave_matrix_RE);

cpl_error_code espdr_wave_LFC_QC(int *lines_nb_per_order,
                                 double *chisq_per_order,
                                 double *rms_per_order,
                                 int *order_fit,
                                 int orders_nb,
                                 int fibre_nr,
                                 espdr_inst_config *inst_config,
                                 espdr_qc_keywords *qc_kws,
                                 cpl_propertylist *wave_keywords,
                                 cpl_propertylist *keywords_RE);

cpl_error_code espdr_save_wave_LFC_products(cpl_frameset *frameset,
                                            cpl_parameterlist *parameters,
                                            const char *recipe_id,
                                            cpl_frameset *used_frames,
                                            const char *WAVE_tag,
                                            int fibre_nr,
                                            cpl_propertylist *keywords,
                                            espdr_inst_config *inst_config,
                                            cpl_image *wave_matrix,
                                            cpl_image *air_wave_matrix,
                                            cpl_image *dll_matrix,
                                            cpl_image *air_dll_matrix,
                                            cpl_table *coeffs_table,
                                            cpl_table *LFC_table);
#endif /* ESPDR_WAVE_CAL_H */
