/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_LED_FLAT_H
#define ESPDR_LED_FLAT_H

/* General */
#include <math.h>

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_keywords.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_overscan.h>
#include <espdr_hdrl_func.h>
#include <espdr_preprocessing.h>

/* Library */
#include <cpl.h>
#include <assert.h>

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/
#define MAX_FLUX 100000.0

#define SAVE_DEBUG_PRODUCT_LED_FF 0
#define SAVE_STATIC_PRODUCT_LED_FF 0
/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

/* Columns names of the LED_FF gain windows corrdinates FITS table */
static const char COL_NAME_GAIN_WINDOW_LLX[] = "GAIN_WINDOW_LLX";
static const char COL_NAME_GAIN_WINDOW_LLY[] = "GAIN_WINDOW_LLY";
static const char COL_NAME_GAIN_WINDOW_URX[] = "GAIN_WINDOW_URX";
static const char COL_NAME_GAIN_WINDOW_URY[] = "GAIN_WINDOW_URY";


/*----------------------------------------------------------------------------
 Structures definition
 ----------------------------------------------------------------------------*/
/* Structure holding frames and their Texps */

typedef struct {
    double Texp;
    cpl_frameset *Texp_frameset;
} espdr_Texp_frames;


/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_led_ff(cpl_parameterlist *parameters,
                        cpl_frameset *frameset, const char* recipe_id);
cpl_error_code espdr_parameters_LED_FF_create(const char* recipe_id,
                                              cpl_parameterlist *list,
                                              espdr_LED_FF_param *p);

espdr_LED_FF_param* espdr_parameters_LED_FF_init(const char* recipe_id,
                                                 cpl_parameterlist* param_list);

cpl_error_code espdr_parameters_LED_FF_delete(espdr_LED_FF_param* p);

cpl_error_code espdr_parameters_LED_FF_get(const char* recipe_id,
                                           cpl_parameterlist* list,
                                           espdr_LED_FF_param *LED_FF_param);

cpl_error_code espdr_parameters_LED_FF_print(espdr_LED_FF_param *LED_FF_param);

espdr_window_coord* espdr_gain_window_struct_init(cpl_frameset* set,
                                                  espdr_CCD_geometry *CCD_geom);

cpl_error_code espdr_read_gain_windows_coords(cpl_frameset *frameset,
                                              espdr_CCD_geometry *CCD_geom,
                                              espdr_window_coord *gain_windows);

cpl_error_code espdr_led_ff_sort_by_texp(cpl_frameset* led_ff_frames,
                                         espdr_Texp_frames** led_ff_clean_input,
                                         espdr_inst_config *inst_config,
                                         int* nb);

cpl_error_code espdr_frames_split_by_texp(cpl_frameset *input_frameset,
                                          espdr_Texp_frames **Texps_RE,
                                          espdr_inst_config *inst_config,
                                          int *nb_of_different_texp);

cpl_error_code espdr_led_ff_clean_input_set(espdr_Texp_frames *all_frames,
                                            espdr_inst_config *inst_config,
                                            int valid_sets_nb,
                                            espdr_Texp_frames **taken_frames_RE);
    

cpl_error_code espdr_oscan_correct_and_stack_frames(espdr_CCD_geometry* CCD_geom,
                                                    espdr_inst_config *inst_config,
                                                    cpl_imagelist *orders_mask_iml,
                                                    espdr_Texp_frames *led_ff_clean_input,
                                                    const int nb_of_different_texp,
                                                    cpl_imagelist*** iml_mst_array,
                                                    cpl_frameset*** set_gain_array);

cpl_error_code espdr_bad_pixels_prepare(cpl_imagelist **master_led_ff_list,
                                        espdr_CCD_geometry *CCD_geom,
                                        espdr_inst_config *inst_config,
                                        espdr_qc_keywords *qc_kws,
                                        cpl_imagelist **bad_pixel_mask_list_RE,
                                        cpl_propertylist **keywords_RE);

cpl_error_code espdr_bad_pixels(cpl_imagelist *master_led_ff_list,
                                cpl_imagelist *dead_pixels_imagelist,
                                espdr_CCD_geometry *CCD_geom,
                                espdr_inst_config *inst_config,
                                double *mean_RE,
                                int *hot_pixels_RE,
                                double *sigma_RE,
                                cpl_imagelist **bad_pixel_mask_list_RE);
	
cpl_error_code espdr_create_hot_bad_pixels_mask(cpl_imagelist *hot_pixels_list,
                                                cpl_imagelist *bad_pixels_list,
                                                cpl_imagelist **pixel_mask_RE);

cpl_error_code espdr_prepare_gain(cpl_frameset **set,
                                  int nb_of_sets,
                                  cpl_imagelist *pixels_mask,
                                  espdr_CCD_geometry *CCD_geom,
                                  espdr_qc_keywords *qc_kws,
                                  espdr_inst_config *inst_config,
                                  espdr_window_coord *gain_windows,
                                  cpl_propertylist **keywords_ext,
                                  cpl_propertylist **keywords_RE);

cpl_error_code espdr_compute_gain(cpl_frameset **set,
                                  int nb_of_sets,
                                  cpl_imagelist *pixels_mask,
                                  espdr_CCD_geometry *CCD_geom,
                                  espdr_inst_config *inst_config,
                                  espdr_window_coord *gain_windows,
                                  double *total_gain_RE,
                                  double *mean_flux_RE);

cpl_error_code espdr_evaluate_flux(cpl_frameset **set,
                                   int nb_of_sets,
                                   cpl_imagelist *pixels_mask,
                                   espdr_CCD_geometry *CCD_geom,
                                   double *min_flux_RE,
                                   double *max_flux_RE);

cpl_error_code espdr_gain_QC(espdr_CCD_geometry *CCD_geom,
                             espdr_qc_keywords *qc_kws,
                             espdr_inst_config *inst_config,
                             cpl_propertylist **keywords_ext,
                             double *computed_gain,
                             cpl_propertylist **keywords_RE);

cpl_error_code espdr_led_ff_QC(espdr_CCD_geometry *CCD_geom,
                               espdr_qc_keywords *qc_kws,
                               espdr_inst_config *inst_config,
                               double *max_flux,
                               cpl_propertylist **keywords_RE);

cpl_error_code espdr_led_ff_cleanup(cpl_frameset** set, const int nb);

#endif /* ESPDR_LED_FLAT_H */
