/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_WAVE_THAR_CAL_H
#define ESPDR_WAVE_THAR_CAL_H


/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_fit.h>
#include <espdr_led_flat.h>
#include <espdr_extraction.h>
#include <espdr_pixels.h>
#include <espdr_drift.h>
#include <espdr_wave_cal.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
// order shift with respect to the initial start of 1210, for Christophe's rdb input
//#define ORDER_START_SHIFT 160
// for the FITS input
#define ORDER_START_SHIFT 0

//#define FP_D 76080000.00 // in Angstroms = 7.608 mm
//#define FP_D 76047715.00 // in Angstroms, adjusted after the fit
//#define FP_D 76045135.00 // in Angstroms, adjusted after the fit ESPRESSO BLUE
//#define FP_D 76052986.00 // in Angstroms, adjusted after the fit ESPRESSO BLUE+RED
#define N_FP_PEAKS 6

#define SAVE_DEBUG_PRODUCT_WAVE_THAR 0
#define PROCESS_RAW_LINES 1
#define SAVE_STATIC_MATRICES 0
#define SAVE_TH_REF_TABLES_NEW_X0 0

/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

int espdr_wave_THAR(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_WAVE_THAR_create(const char* recipe_id,
                                                 cpl_parameterlist *list,
                                                 espdr_WAVE_THAR_param *p);

cpl_error_code espdr_parameters_WAVE_THAR_delete(espdr_WAVE_THAR_param* p);

cpl_error_code espdr_parameters_WAVE_THAR_get(const char* recipe_id,
                                              cpl_parameterlist* param_list,
                                              espdr_WAVE_THAR_param *WAVE_THAR_param);

cpl_error_code espdr_parameters_WAVE_THAR_print(espdr_WAVE_THAR_param *WAVE_THAR_param);

espdr_WAVE_THAR_param *espdr_WAVE_THAR_param_init(const char *recipe_id,
                                                  cpl_parameterlist *parameters);

cpl_error_code espdr_wave_THAR_read_parameters(cpl_frameset *frameset,
                                               espdr_CCD_geometry *CCD_geom,
                                               espdr_inst_config *inst_config);

cpl_error_code espdr_read_REF_LINES_TABLE_ASCII(cpl_frame *wave_line_table,
                                                espdr_line_param *lines_table,
                                                double *d_static,
                                                double *d_static_err,
                                                double *d_static_err_no_min,
                                                int *lines_nb_RE);

cpl_error_code espdr_read_REF_LINES_TABLE_CSV(cpl_frame *ref_line_table,
                                              espdr_line_param *lines_table,
                                              double *d_static,
                                              double *d_static_err,
                                              double *d_static_err_no_min,
                                              int *lines_nb_RE);

cpl_error_code espdr_read_REF_LINES_TABLE(cpl_frame *ref_line_table,
                                          espdr_line_param *lines_table,
                                          double *d_static,
                                          double *d_static_err,
                                          double *d_static_err_no_min,
                                          int *lines_nb_RE);

cpl_error_code espdr_read_FP_LINES_TABLE(cpl_frame *wave_line_table,
                                         espdr_line_param *lines_table,
                                         int *lines_nb_RE);

cpl_error_code espdr_fit_REF_lines(espdr_line_param *lines_table,
                                   int lines_nb,
                                   cpl_image *s2d,
                                   cpl_image *s2d_err,
                                   cpl_image *s2d_qual,
                                   cpl_image *pixel_geom,
                                   double flux_threshold,
                                   //double min_x0_err,
                                   int window_size,
                                   int tolerance_window,
                                   int *lines_nb_per_order_RE,
                                   int *saturated_lines_nb_RE,
                                   double *flux_ratio_median_RE,
                                   double *rv_diff_median_RE);

cpl_error_code espdr_THAR_lines_qc(espdr_line_param *lines_table,
                                   int lines_nb,
                                   espdr_inst_config *inst_config,
                                   int *lines_nb_per_order_RE);

cpl_error_code espdr_find_first_FP_ll(espdr_line_param *REF_lines_table,
                                      int REF_lines_nb,
                                      double fp_d_angstrom,
                                      espdr_line_param *FP_lines_table,
                                      int FP_lines_nb);

cpl_error_code espdr_get_all_FP_ll_per_order(espdr_line_param *FP_lines_table,
                                             int FP_lines_nb,
                                             int CCD_middle,
                                             double fp_d_angstrom);

cpl_error_code espdr_get_all_FP_ll_whole_image(espdr_line_param *FP_lines_table,
                                               int FP_lines_nb,
                                               espdr_inst_config *inst_config,
                                               int orders_nb);

cpl_error_code espdr_fit_d_lambda(espdr_line_param *THAR_lines_table,
                                  int THAR_lines_nb,
                                  espdr_line_param *FP_lines_table,
                                  int FP_lines_nb,
                                  espdr_inst_config *inst_config,
                                  double *d_static,
                                  double *d_static_err,
                                  double *d_static_err_no_min,
                                  double *d_computed,
                                  double *d_computed_err,
                                  double *d_computed_err_no_min,
                                  double *residuals,
                                  double *dm);

cpl_error_code espdr_compute_THAR_resolution(espdr_line_param *THAR_lines_table,
                                             double *resolution,
                                             int THAR_lines_nb,
                                             double *resol_median);

cpl_error_code espdr_fit_THAR_raw_lines(espdr_line_param *lines_table,
                                        int lines_nb,
                                        cpl_imagelist *raw,
                                        int fibre_nr,
                                        cpl_table **orders_coeffs,
                                        cpl_image *pixel_geom,
                                        int window_size_x,
                                        espdr_inst_config *inst_config,
                                        espdr_CCD_geometry *CCD_geom,
                                        double *RON,
                                        int *raw_lines_nb_RE,
                                        espdr_raw_line_param *raw_lines_table_RE);

cpl_error_code espdr_wave_THAR_QC(int *lines_nb_per_order,
                                  double *chisq_per_order,
                                  double *rms_per_order,
                                  int *order_fit,
                                  double resol_median,
                                  int orders_nb,
                                  int saturated_lines_nb,
                                  int valid_lines_nb,
                                  double flux_ratio_median,
                                  double rv_diff_median,
                                  espdr_src_type fibre_source,
                                  int fibre_nr,
                                  cpl_table *drift_results,
                                  cpl_image *wave_matrix,
                                  cpl_image *s2d_qual,
                                  espdr_inst_config *inst_config,
                                  espdr_CCD_geometry *CCD_geom,
                                  espdr_qc_keywords *qc_kws,
                                  cpl_propertylist *keywords_RE);

cpl_error_code espdr_wave_FP_D_QC(espdr_line_param *THAR_lines_table,
                                  int THAR_lines_nb,
                                  espdr_line_param *FP_lines_table,
                                  int FP_lines_nb,
                                  double *d_computed_err,
                                  double *residuals,
                                  double *dm,
                                  double ll_first,
                                  double ll_last,
                                  espdr_inst_config *inst_config,
                                  espdr_qc_keywords *qc_kws,
                                  cpl_propertylist *keywords_RE);


#endif /* ESPDR_WAVE_THAR_CAL_H */
