/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_WAVE_TH_DRIFT_CAL_H
#define ESPDR_WAVE_TH_DRIFT_CAL_H


/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>
#include <espdr_fit.h>
#include <espdr_led_flat.h>
#include <espdr_extraction.h>
#include <espdr_pixels.h>
#include <espdr_wave_cal.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define SAVE_DEBUG_PRODUCT_WAVE_TH_DRIFT 0
#define PROCESS_RAW_LINES_IN_DRIFT 0
#define SAVE_TH_REF_TABLES_IN_DRIFT 0
#define SAVE_REF_MATRICES_IN_DRIFT 0

/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_wave_TH_drift(cpl_parameterlist *parameters,
                               cpl_frameset *frameset,
							   const char* recipe_id);
cpl_error_code espdr_parameters_WAVE_TH_drift_create(const char* recipe_id,
                                                     cpl_parameterlist *list,
                                                     espdr_WAVE_TH_drift_param *p);

cpl_error_code espdr_parameters_WAVE_TH_drift_delete(espdr_WAVE_TH_drift_param* p);

cpl_error_code espdr_parameters_WAVE_TH_drift_get(const char* recipe_id,
                                                  cpl_parameterlist* param_list,
                                                  espdr_WAVE_TH_drift_param *WAVE_TH_drift_param);

cpl_error_code espdr_parameters_WAVE_TH_drift_print(espdr_WAVE_TH_drift_param *WAVE_TH_drift_param);

espdr_WAVE_TH_drift_param *espdr_WAVE_TH_drift_param_init(const char *recipe_id,
                                                          cpl_parameterlist *parameters);

cpl_error_code espdr_read_REF_DRIFT_LINES_TABLE_ASCII(cpl_frame *ref_line_table,
                                                      espdr_line_param *lines_table,
                                                      int *lines_nb_RE,
                                                      char source);

cpl_error_code espdr_read_REF_DRIFT_LINES_TABLE(cpl_frame *ref_line_table,
                                                espdr_line_param *lines_table,
                                                int *lines_nb_RE,
                                                char source);

cpl_error_code espdr_compute_diff_lines_table(espdr_line_param *REF_lines_table,
                                              int REF_lines_nb,
                                              espdr_line_param *TH_lines_table,
                                              int TH_lines_nb,
                                              int diff_lines_nb,
                                              int fibre,
                                              espdr_inst_config *inst_config,
                                              espdr_CCD_geometry *CCD_geom,
                                              espdr_line_param *diff_lines_table_RE,
                                              int *valid_lines_nb_RE);

cpl_error_code espdr_fit_drift_matrix(espdr_line_param *TH_lines_table,
                                      int TH_lines_nb,
                                      espdr_line_param *diff_lines_table,
                                      int diff_lines_nb,
                                      int *valid_lines_nb,
                                      cpl_image *ref_wave_matrix_img,
                                      cpl_image *ref_dll_matrix_img,
                                      espdr_inst_config *inst_config,
                                      espdr_CCD_geometry *CCD_geom,
                                      int size_x,
                                      int size_y,
                                      int orders_nb_per_fibre,
                                      int fibre,
                                      int *rejected_lines_nb_RE,
                                      double *MAD,
                                      double **ll_coeffs_RE,
                                      double *CHI2_RE,
                                      cpl_image *drift_matrix_RE,
                                      cpl_image **wave_matrix_RE,
                                      cpl_image **dll_matrix_RE,
                                      cpl_image **air_wave_matrix_RE,
                                      cpl_image **air_dll_matrix_RE);

cpl_error_code espdr_compute_THAR_lamp_offset(espdr_line_param *AR_lines_table,
                                              int AR_lines_nb,
                                              double *REF_AR_peak_pxl_error,
                                              double *REF_AR_ll,
                                              double **ll_coefs,
                                              cpl_image *wave_matrix,
                                              cpl_image *dll_matrix,
                                              espdr_CCD_geometry *CCD_geom,
                                              espdr_inst_config *inst_config,
                                              int fibre,
                                              double *lamp_offset_ar,
                                              double *lamp_offset_ar1,
                                              double *lamp_offset_ar2);

cpl_error_code espdr_wave_TH_drift_QC(int *lines_nb_per_order,
                                      double resol_median,
                                      double lamp_offset_ar,
                                      double lamp_offset_ar1,
                                      double lamp_offset_ar2,
                                      int orders_nb,
                                      int saturated_lines_nb,
                                      int valid_lines_nb,
                                      double flux_ratio_median,
                                      double rv_diff_median,
                                      double *fraction_rejected,
                                      double *MAD,
                                      double *CHI2,
                                      espdr_src_type fibre_source,
                                      int fibre_nr,
                                      cpl_image *wave_matrix,
                                      cpl_image *s2d_qual,
                                      espdr_inst_config *inst_config,
                                      espdr_CCD_geometry *CCD_geom,
                                      espdr_qc_keywords *qc_kws,
                                      cpl_propertylist *keywords_RE);

cpl_error_code espdr_save_wave_TH_drift_products(cpl_frameset *frameset,
                                                 cpl_parameterlist *parameters,
                                                 const char *recipe_id,
                                                 cpl_frameset *used_frames,
                                                 const char *WAVE_tag,
                                                 int fibre_nr,
                                                 cpl_propertylist *keywords,
                                                 espdr_inst_config *inst_config,
                                                 cpl_image *wave_matrix,
                                                 cpl_image *air_wave_matrix,
                                                 cpl_image *dll_matrix,
                                                 cpl_image *air_dll_matrix,
                                                 cpl_table *TH_table,
                                                 cpl_table *AR_table,
                                                 cpl_table *raw_table);

#endif /* ESPDR_WAVE_TH_DRIFT_CAL_H */
