/*-----------------------------------------------------------------*/
/*!
  \file bepopinternal.h
  \brief header file for bepop.c

  \author  H. Manche
           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris.

   Copyright 2014, 2015, 2016, CNRS
   email of the author : herve.manche@obspm.fr

  last revision: 05/06/2014

  History:
  \note H. Manche 05/06/2014 : creation
 */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/

#ifndef BEPOPINTERNAL_H
#define BEPOPINTERNAL_H


#include "calceph.h"
#include "earth_orientation_parameters.h"
#include "itrf_icrf.h"


#define _DEFAULT_EPHEMERIS_FILE_NAME "inpop13c_TDB_m100_p100_tt.dat"






struct strucParamBEPOPprivate
{

  char EphemFile[1024] ; /* name of the ephemeris file */
  char EOPfile[1024] ;  /* name of the ASCII file, containing the Earth Orientation Parameters */
  int DegreeInterpolationEOP ; /* degree in the lagrangian interpolation of EOPs */
  int ReferenceEllipsoid ; /* 1->WGS84, 2->GRS80, 3->WGS72 */
  int iMethod_TTmTDB ;   /* method to transform TT into TDB*/
                         /* 0: no difference (TT=TDB)
                          * 1: use of sofa/erfa eraDtdb function
                          * 2: use of TT-TDB of the ephemeris file (not always available) */
  int ActiveEOPs ; /* Defines which EOPs are to be interpolate */
                   /* ActiveEOPs writes abc in binary format (=4*a+2*b+c) */
                   /* a=1 => corrections to CIP are taken into acccount */
                   /* b=1 => UT1-UTC difference is taken into account */
                   /* c=1 => polar motion is taken into account */
  t_ITCRF_Model ITCRF_Model ; /* structure defining the model for the ITRF<->ICRF transformations */


  /* fields deduced from the previous ones */
  t_calcephbin *PTR_eph;    /* pointer to the ephemeris */
  double tabGMs[12] ; /* array of bodies GMs, from Mercury(1) to Pluto(9), Moon(10) and Sun (11) */
                      /* the GMs are read from the ephemeris file */
                      /* they are used in vecTT-> vecTDB transformation */
                      /* units are km^3/s^2 */
  t_ArraysAllEOPs ArraysAllEOPs ; /* structure with arrays of all EOPs at 0h00 UTC */

} ;

void BEPOP_initGMs(struct strucParamBEPOPprivate *ptrBEPOP);
struct strucParamBEPOPprivate * BEPOP_initDefault2(const char *EphemerisFileName,
                                         const char *EOPsFileName, const int typeInit,
                                         struct strucParamBEPOPprivate *ptrBEPOP);
void BEPOP_closeEOPs(struct strucParamBEPOPprivate *ptrBEPOP);

#endif



