/*                                                                           a
 *   This file is part of the ESO X-shooter Pipeline                         *
 *   Copyright (C) 2006 European Southern Observatory                        *
 *                                                                           *
 *   This library is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the Free Software             *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA    *
 *                                                                           */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.4 $
 * $Name: not supported by cvs2svn $
 */
#ifndef ESPDR_DFS_H
#define ESPDR_DFS_H

/*----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include <string.h>
#include <cpl.h>
#include <espdr_CCD.h>
#include <espdr_keywords.h>

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/

/* PRO.CATG keywords */

// mbias & single_bias products
#define ESPDR_PRO_CATG_MBIAS                    "MASTER_BIAS"
#define ESPDR_PRO_CATG_MBIAS_RES                "MASTER_BIAS_RES"
#define ESPDR_PRO_CATG_SBIAS                    "SINGLE_BIAS"
#define ESPDR_PRO_CATG_SBIAS_RES                "SINGLE_BIAS_RES"

// mdark products
#define ESPDR_PRO_CATG_MDARK                    "MASTER_DARK"
#define ESPDR_PRO_CATG_HOT_PIXELS               "HOT_PIXEL_MASK"

// led_ff products
#define ESPDR_PRO_CATG_BAD_PIXELS               "BAD_PIXEL_MASK"

// orderdef products
#define ESPDR_PRO_CATG_ORDERS                   "ORDER_TABLE"
#define ESPDR_PRO_CATG_ORDERS_A                 "ORDER_TABLE_A"
#define ESPDR_PRO_CATG_ORDERS_B                 "ORDER_TABLE_B"

// mflat products
#define ESPDR_PRO_CATG_ORDER_PROFILE            "ORDER_PROFILE"
#define ESPDR_PRO_CATG_ORDER_PROFILE_A          "ORDER_PROFILE_A"
#define ESPDR_PRO_CATG_ORDER_PROFILE_B          "ORDER_PROFILE_B"
#define ESPDR_PRO_CATG_MASTER_ORDER_PROFILE     "MASTER_ORDER_PROFILE"
#define ESPDR_PRO_CATG_MASTER_ORDER_PROFILE_A   "MASTER_ORDER_PROFILE_A"
#define ESPDR_PRO_CATG_MASTER_ORDER_PROFILE_B   "MASTER_ORDER_PROFILE_B"
#define ESPDR_PRO_CATG_MFLAT                    "MASTER_FLAT"
#define ESPDR_PRO_CATG_FS2D                     "FS2D"
#define ESPDR_PRO_CATG_FLAT                     "FSPECTRUM"
#define ESPDR_PRO_CATG_FLAT_A                   "FSPECTRUM_A"
#define ESPDR_PRO_CATG_FLAT_B                   "FSPECTRUM_B"
#define ESPDR_PRO_CATG_MASTER_FLAT              "MASTER_FSPECTRUM"
#define ESPDR_PRO_CATG_MASTER_FLAT_A            "MASTER_FSPECTRUM_A"
#define ESPDR_PRO_CATG_MASTER_FLAT_B            "MASTER_FSPECTRUM_B"
#define ESPDR_PRO_CATG_BLAZE                    "BLAZE"
#define ESPDR_PRO_CATG_BLAZE_A                  "BLAZE_A"
#define ESPDR_PRO_CATG_BLAZE_B                  "BLAZE_B"
#define ESPDR_PRO_CATG_MASTER_BLAZE             "MASTER_BLAZE"
#define ESPDR_PRO_CATG_MASTER_BLAZE_A           "MASTER_BLAZE_A"
#define ESPDR_PRO_CATG_MASTER_BLAZE_B           "MASTER_BLAZE_B"
#define ESPDR_PRO_CATG_FF_BKG_MAP               "FF_BACKGROUND_MAP"

// general wave products
#define ESPDR_PRO_CATG_S2D                      "S2D"
#define ESPDR_PRO_CATG_S2D_BLAZE                "S2D_BLAZE"
#define ESPDR_PRO_CATG_REF_LINE_TABLE           "REF_LINE_TABLE"
#define ESPDR_PRO_CATG_REF_LINE_TABLE_A         "REF_LINE_TABLE_A"
#define ESPDR_PRO_CATG_REF_LINE_TABLE_B         "REF_LINE_TABLE_B"
#define ESPDR_PRO_CATG_LINE_TABLE_RAW           "LINE_TABLE_RAW"
#define ESPDR_PRO_CATG_WAVE_MATRIX              "WAVE_MATRIX"
#define ESPDR_PRO_CATG_DLL_MATRIX               "DLL_MATRIX"
#define ESPDR_PRO_CATG_AIR_WAVE_MATRIX          "AIR_WAVE_MATRIX"
#define ESPDR_PRO_CATG_AIR_DLL_MATRIX           "AIR_DLL_MATRIX"
#define ESPDR_PRO_CATG_WAVE_TABLE               "WAVE_TABLE"

// wave_FP products
#define ESPDR_PRO_CATG_S2D_BLAZE_FP_FP_A        "S2D_BLAZE_FP_FP_A"
#define ESPDR_PRO_CATG_S2D_BLAZE_FP_FP_B        "S2D_BLAZE_FP_FP_B"
#define ESPDR_PRO_CATG_FP_SEARCHED_LINE_TABLE           "FP_SEARCHED_LINE_TABLE"
#define ESPDR_PRO_CATG_FP_SEARCHED_LINE_TABLE_FP_FP_A   "FP_SEARCHED_LINE_TABLE_FP_FP_A"
#define ESPDR_PRO_CATG_FP_SEARCHED_LINE_TABLE_FP_FP_B   "FP_SEARCHED_LINE_TABLE_FP_FP_B"

// wave_THAR products
#define ESPDR_PRO_CATG_S2D_BLAZE_THAR_FP_A      "S2D_BLAZE_THAR_FP_A"
#define ESPDR_PRO_CATG_S2D_BLAZE_THAR_FP_B      "S2D_BLAZE_THAR_FP_B"
#define ESPDR_PRO_CATG_S2D_BLAZE_FP_THAR_A      "S2D_BLAZE_FP_THAR_B"
#define ESPDR_PRO_CATG_S2D_BLAZE_FP_THAR_B      "S2D_BLAZE_FP_THAR_B"
#define ESPDR_PRO_CATG_THAR_LINE_TABLE          "THAR_LINE_TABLE"
#define ESPDR_PRO_CATG_FP_FITTED_LINE_TABLE     "FP_FITTED_LINE_TABLE"
#define ESPDR_PRO_CATG_WAVE_MATRIX_THAR_FP_A    "WAVE_MATRIX_THAR_FP_A"
#define ESPDR_PRO_CATG_WAVE_MATRIX_FP_THAR_B    "WAVE_MATRIX_FP_THAR_B"
#define ESPDR_PRO_CATG_DLL_MATRIX_THAR_FP_A     "DLL_MATRIX_THAR_FP_A"
#define ESPDR_PRO_CATG_DLL_MATRIX_FP_THAR_B     "DLL_MATRIX_FP_THAR_B"

// wave_LFC products
#define ESPDR_PRO_CATG_S2D_BLAZE_LFC_FP_A       "S2D_BLAZE_LFC_FP_A"
#define ESPDR_PRO_CATG_S2D_BLAZE_LFC_FP_B       "S2D_BLAZE_LFC_FP_B"
#define ESPDR_PRO_CATG_S2D_BLAZE_FP_LFC_A       "S2D_BLAZE_FP_LFC_B"
#define ESPDR_PRO_CATG_S2D_BLAZE_FP_LFC_B       "S2D_BLAZE_FP_LFC_B"
#define ESPDR_PRO_CATG_LFC_FITTED_LINE_TABLE    "LFC_FITTED_LINE_TABLE"
#define ESPDR_PRO_CATG_LFC_WAVE_MATRIX          "LFC_WAVE_MATRIX"
#define ESPDR_PRO_CATG_WAVE_MATRIX_LFC_FP_A     "WAVE_MATRIX_LFC_FP_A"
#define ESPDR_PRO_CATG_WAVE_MATRIX_FP_LFC_B     "WAVE_MATRIX_FP_LFC_B"
#define ESPDR_PRO_CATG_LFC_DLL_MATRIX           "LFC_DLL_MATRIX"
#define ESPDR_PRO_CATG_DLL_MATRIX_LFC_FP_A      "DLL_MATRIX_LFC_FP_A"
#define ESPDR_PRO_CATG_DLL_MATRIX_FP_LFC_B      "DLL_MATRIX_FP_LFC_B"
#define ESPDR_PRO_CATG_LFC_AIR_WAVE_MATRIX      "LFC_AIR_WAVE_MATRIX"
#define ESPDR_PRO_CATG_LFC_AIR_DLL_MATRIX       "LFC_AIR_DLL_MATRIX"

// wave_THAR_THAR products
#define ESPDR_PRO_CATG_S2D_BLAZE_THAR_THAR_A    "S2D_BLAZE_THAR_THAR_A"
#define ESPDR_PRO_CATG_S2D_BLAZE_THAR_THAR_B    "S2D_BLAZE_THAR_THAR_B"

// wave_LFC_LFC products
#define ESPDR_PRO_CATG_S2D_BLAZE_LFC_LFC_A      "S2D_BLAZE_LFC_LFC_B"
#define ESPDR_PRO_CATG_S2D_BLAZE_LFC_LFC_B      "S2D_BLAZE_LFC_LFC_B"

// wave_TH_drift products
#define ESPDR_PRO_CATG_TH_LINE_TABLE            "TH_LINE_TABLE"
#define ESPDR_PRO_CATG_AR_LINE_TABLE            "AR_LINE_TABLE"
#define ESPDR_PRO_CATG_AR_LINE_TABLE_A          "AR_LINE_TABLE_A"
#define ESPDR_PRO_CATG_AR_LINE_TABLE_B          "AR_LINE_TABLE_B"
#define ESPDR_PRO_CATG_STATIC_LINE_TABLE        "STATIC_LINE_TABLE"
#define ESPDR_PRO_CATG_STATIC_LINE_TABLE_A      "STATIC_LINE_TABLE_A"
#define ESPDR_PRO_CATG_STATIC_LINE_TABLE_B      "STATIC_LINE_TABLE_B"
#define ESPDR_PRO_CATG_WAVE_MATRIX_DRIFT                "WAVE_MATRIX_DRIFT"
#define ESPDR_PRO_CATG_WAVE_MATRIX_DRIFT_THAR_FP_A      "WAVE_MATRIX_DRIFT_THAR_FP_A"
#define ESPDR_PRO_CATG_WAVE_MATRIX_DRIFT_THAR_THAR_A    "WAVE_MATRIX_DRIFT_THAR_THAR_A"
#define ESPDR_PRO_CATG_WAVE_MATRIX_DRIFT_FP_THAR_B      "WAVE_MATRIX_DRIFT_FP_THAR_B"
#define ESPDR_PRO_CATG_WAVE_MATRIX_DRIFT_THAR_THAR_B    "WAVE_MATRIX_DRIFT_THAR_THAR_B"
#define ESPDR_PRO_CATG_DLL_MATRIX_DRIFT                 "DLL_MATRIX_DRIFT"
#define ESPDR_PRO_CATG_DLL_MATRIX_DRIFT_THAR_FP_A       "DLL_MATRIX_DRIFT_THAR_FP_A"
#define ESPDR_PRO_CATG_DLL_MATRIX_DRIFT_THAR_THAR_A     "DLL_MATRIX_DRIFT_THAR_THAR_A"
#define ESPDR_PRO_CATG_DLL_MATRIX_DRIFT_FP_THAR_B       "DLL_MATRIX_DRIFT_FP_THAR_B"
#define ESPDR_PRO_CATG_DLL_MATRIX_DRIFT_THAR_THAR_B     "DLL_MATRIX_DRIFT_THAR_THAR_B"
#define ESPDR_PRO_CATG_AIR_WAVE_MATRIX_DRIFT            "AIR_WAVE_MATRIX_DRIFT"
#define ESPDR_PRO_CATG_AIR_DLL_MATRIX_DRIFT             "AIR_DLL_MATRIX_DRIFT"

// cal_contam products
#define ESPDR_PRO_CATG_CONTAM_SRC               "CONTAM"
#define ESPDR_PRO_CATG_CONTAM_FP                "CONTAM_FP"
#define ESPDR_PRO_CATG_CONTAM_LFC               "CONTAM_LFC"
#define ESPDR_PRO_CATG_CONTAM_THAR              "CONTAM_THAR"

// cal_eff_ab products
#define ESPDR_PRO_CATG_REL_EFF                  "REL_EFF_B"

// cal_flux products
#define ESPDR_PRO_CATG_S2D_STD_A                "S2D_STD_A"
#define ESPDR_PRO_CATG_S2D_BLAZE_STD_A          "S2D_BLAZE_STD_A"
#define ESPDR_PRO_CATG_S1D_STD_A                "S1D_STD_A"
#define ESPDR_PRO_CATG_S1D_ENERGY_STD_A         "S1D_ENERGY_STD_A"
#define ESPDR_PRO_CATG_AVG_FLUX_STD_A           "AVG_FLUX_STD_A"
#define ESPDR_PRO_CATG_ABS_EFF_RAW              "ABS_EFF_RAW_A"
#define ESPDR_PRO_CATG_ABS_EFF                  "ABS_EFF_A"

// sci_red products
#define ESPDR_PRO_CATG_SCIENCE_S2D                  "S2D"
#define ESPDR_PRO_CATG_SCIENCE_S2D_SKYSUB           "S2D_SKYSUB"
#define ESPDR_PRO_CATG_SCIENCE_S2D_BLAZE_SKYSUB     "S2D_BLAZE_SKYSUB"
#define ESPDR_PRO_CATG_SCIENCE_S2D_BLAZE_TELL_CORR  "S2D_BLAZE_TELL_CORR"
#define ESPDR_PRO_CATG_SCIENCE_S2D_TELL_CORR        "S2D_TELL_CORR"
#define ESPDR_PRO_CATG_SCIENCE_TELL_SPECTRUM        "S2D_TELL_SPECTRUM"
#define ESPDR_PRO_CATG_SCIENCE_S2D_OH_CORR          "S2D_OH_CORR"
#define ESPDR_PRO_CATG_SCIENCE_S2D_BLAZE_OH_CORR    "S2D_BLAZE_OH_CORR"
#define ESPDR_PRO_CATG_SCIENCE_S1D                  "S1D"
#define ESPDR_PRO_CATG_SCIENCE_S1D_SKYSUB           "S1D_SKYSUB"
#define ESPDR_PRO_CATG_SCIENCE_S1D_FLUXCAL          "S1D_FLUXCAL"
#define ESPDR_PRO_CATG_SCIENCE_S1D_SKYSUB_FLUXCAL   "S1D_SKYSUB_FLUXCAL"
#define ESPDR_PRO_CATG_SCIENCE_S1D_TELLCORR         "S1D_TELL_CORR"
#define ESPDR_PRO_CATG_SCIENCE_S1D_TELLCORR_FLUXCAL "S1D_TELL_CORR_FLUXCAL"
#define ESPDR_PRO_CATG_SCIENCE_CCF                  "CCF"
#define ESPDR_PRO_CATG_DRIFT_MATRIX                 "DRIFT_MATRIX"

// compu_drift products
#define ESPDR_PRO_CATG_DRIFT                    "DRIFT"

// test products
#define ESPDR_PRO_CATG_TEST_PRODUCT             "TEST_PRODUCT"


/* CONFIG (static calibrations) frames TAGs */
#define ESPDR_CCD_GEOM                          "CCD_GEOM"
#define ESPDR_INST_CONFIG                       "INST_CONFIG"
#define ESPDR_MASTER_INST_CONFIG                "MASTER_INST_CONFIG"
#define ESPDR_LED_FF_GAIN_WINDOWS               "LED_FF_GAIN_WINDOWS"
#define ESPDR_PRO_CATG_PIXEL_GEOM               "PIXEL_GEOM"
#define ESPDR_PRO_CATG_PIXEL_GEOM_A             "PIXEL_GEOM_A"
#define ESPDR_PRO_CATG_PIXEL_GEOM_B             "PIXEL_GEOM_B"
#define ESPDR_PRO_CATG_PIXEL_SIZE               "PIXEL_SIZE"
#define ESPDR_PRO_CATG_PIXEL_SIZE_A             "PIXEL_SIZE_A"
#define ESPDR_PRO_CATG_PIXEL_SIZE_B             "PIXEL_SIZE_B"
#define ESPDR_ORDERS_MASK                       "ORDERS_MASK"
#define ESPDR_PRO_CATG_STATIC_WAVE_MATRIX       "STATIC_WAVE_MATRIX"
#define ESPDR_PRO_CATG_STATIC_WAVE_MATRIX_A     "STATIC_WAVE_MATRIX_A"
#define ESPDR_PRO_CATG_STATIC_WAVE_MATRIX_B     "STATIC_WAVE_MATRIX_B"
#define ESPDR_PRO_CATG_STATIC_DLL_MATRIX        "STATIC_DLL_MATRIX"
#define ESPDR_PRO_CATG_STATIC_DLL_MATRIX_A      "STATIC_DLL_MATRIX_A"
#define ESPDR_PRO_CATG_STATIC_DLL_MATRIX_B      "STATIC_DLL_MATRIX_B"
#define ESPDR_STD_STARS_TABLE                   "STD_TABLE"
#define ESPDR_EXTINCTION_TABLE                  "EXT_TABLE"
#define ESPDR_PRO_CATG_MASK                     "MASK_TABLE"
#define ESPDR_MASK_LUT_TABLE                    "MASK_LUT"
#define ESPDR_FLUX_TEMPLATE                     "FLUX_TEMPLATE"
#define ESPDR_CRH_MAP                           "CRH_MAP"
#define ESPDR_FCRH_MAP                          "FCRH_MAP"
#define ESPDR_RES_MAP                           "STATIC_RES_MAP"
#define ESPDR_RES_MAP_A                         "STATIC_RES_MAP_A"
#define ESPDR_RES_MAP_B                         "STATIC_RES_MAP_B"
#define ESPDR_HITRAN_LINES_QT                   "HITRAN_LINES_QT"
#define ESPDR_HITRAN_LINES_QT_CH4               "HITRAN_LINES_QT_CH4"
#define ESPDR_HITRAN_LINES_QT_CO2               "HITRAN_LINES_QT_CO2"
#define ESPDR_HITRAN_LINES_QT_H2O               "HITRAN_LINES_QT_H2O"
#define ESPDR_HITRAN_LINES_QT_O2                "HITRAN_LINES_QT_O2"
#define ESPDR_HITRAN_LINES_STRONGEST            "HITRAN_LINES_STRONGEST"
#define ESPDR_HITRAN_LINES_STRONGEST_CH4        "HITRAN_LINES_STRONGEST_CH4"
#define ESPDR_HITRAN_LINES_STRONGEST_CO2        "HITRAN_LINES_STONGEST_CO2"
#define ESPDR_HITRAN_LINES_STRONGEST_H2O        "HITRAN_LINES_STRONGEST_H2O"
#define ESPDR_HITRAN_LINES_STRONGEST_O2         "HITRAN_LINES_STRONGEST_O2"
#define ESPDR_HITRAN_CCF_MASK                   "HITRAN_CCF_MASK"
#define ESPDR_HITRAN_CCF_MASK_CH4               "HITRAN_CCF_MASK_CH4"
#define ESPDR_HITRAN_CCF_MASK_CO2               "HITRAN_CCF_MASK_CO2"
#define ESPDR_HITRAN_CCF_MASK_H2O               "HITRAN_CCF_MASK_H2O"
#define ESPDR_HITRAN_CCF_MASK_O2                "HITRAN_CCF_MASK_O2"
#define ESPDR_OH_SKY_MASTER                     "SKY_MASTER"
#define ESPDR_OH_SKY_MASTER_A                   "SKY_MASTER_A"
#define ESPDR_OH_SKY_MASTER_B                   "SKY_MASTER_B"
#define ESPDR_OH_LINES_REGIONS                  "OH_LINES_REGIONS"


/* RAW frames TAGs */
#define ESPDR_BIAS_RAW              "BIAS"
#define ESPDR_DARK_RAW              "DARK"
#define ESPDR_LED_FF_RAW            "LED_FF"
#define ESPDR_ORDERDEF_RAW          "ORDERDEF"
#define ESPDR_ORDERDEF_A_RAW        "ORDERDEF_A"
#define ESPDR_ORDERDEF_B_RAW        "ORDERDEF_B"
#define ESPDR_FLAT_RAW              "FLAT"
#define ESPDR_FLAT_A_RAW            "FLAT_A"
#define ESPDR_FLAT_B_RAW            "FLAT_B"
#define ESPDR_WAVE_THAR_RAW         "THAR"
#define ESPDR_WAVE_FP_RAW           "FP"
#define ESPDR_WAVE_LFC_RAW          "LFC"
#define ESPDR_WAVE_DARK_RAW         "DARK"
#define ESPDR_WAVE_FP_FP_RAW        "FP_FP"
#define ESPDR_WAVE_THAR_FP_RAW      "THAR_FP"
#define ESPDR_WAVE_FP_THAR_RAW      "FP_THAR"
#define ESPDR_WAVE_THAR_DARK_RAW    "THAR_DARK"
#define ESPDR_WAVE_DARK_THAR_RAW    "DARK_THAR"
#define ESPDR_WAVE_LFC_FP_RAW       "LFC_FP"
#define ESPDR_WAVE_FP_LFC_RAW       "FP_LFC"
#define ESPDR_WAVE_THAR_THAR_RAW    "THAR_THAR"
#define ESPDR_WAVE_LFC_LFC_RAW      "LFC_LFC"
#define ESPDR_CONTAM_RAW            "RAW_CONTAM"
#define ESPDR_CONTAM_RAW_FP         "RAW_CONTAM_FP"
#define ESPDR_CONTAM_RAW_THAR       "RAW_CONTAM_THAR"
#define ESPDR_CONTAM_RAW_LFC        "RAW_CONTAM_LFC"
#define ESPDR_EFF_AB_RAW            "EFF_AB"
#define ESPDR_FLUX_RAW              "FLUX"
#define ESPDR_SCIENCE_RAW           "OBJ"
#define ESPDR_SCIENCE_RAW_DARK      "OBJ_DARK"
#define ESPDR_SCIENCE_RAW_SKY       "OBJ_SKY"
#define ESPDR_SCIENCE_RAW_FP        "OBJ_FP"
#define ESPDR_SCIENCE_RAW_CP        "OBJ_CP"
#define ESPDR_SCIENCE_RAW_THAR      "OBJ_THAR"
#define ESPDR_SCIENCE_RAW_LFC       "OBJ_LFC"
#define ESPDR_SCIENCE_HEADER_RAW    "HEADER"
#define ESPDR_SHIFTED_EXTRACTION_RAW        "GHOSTS"
#define ESPDR_SHIFTED_EXTRACTION_RAW_SKY    "GHOSTS_SKY"
#define ESPDR_SHIFTED_EXTRACTION_RAW_FP     "GHOSTS_FP"
#define ESPDR_SHIFTED_EXTRACTION_RAW_THAR   "GHOSTS_THAR"
#define ESPDR_SHIFTED_EXTRACTION_RAW_LFC    "GHOSTS_LFC"
#define ESPDR_SHIFTED_EXTRACTION_RAW_DARK   "GHOSTS_DARK"


#define ESPDR_IS_RAW(tag) (	\
		(strcmp(tag, ESPDR_BIAS_RAW) == 0)	|| \
		(strcmp(tag, ESPDR_DARK_RAW) == 0)	|| \
		(strcmp(tag, ESPDR_LED_FF_RAW) == 0) || \
		(strstr(tag, ESPDR_ORDERDEF_RAW) != NULL) || \
        (strstr(tag, ESPDR_FLAT_RAW) != NULL) || \
		ESPDR_IS_RAW_WAVE(tag) || \
        ESPDR_IS_RAW_CONTAM(tag) || \
        (strcmp(tag, ESPDR_EFF_AB_RAW) == 0)    || \
        (strcmp(tag, ESPDR_FLUX_RAW) == 0)    || \
		(strstr(tag, ESPDR_SCIENCE_RAW) != NULL) || \
        (strcmp(tag, ESPDR_SCIENCE_HEADER_RAW) == 0) || \
        (strstr(tag, ESPDR_SHIFTED_EXTRACTION_RAW) != NULL) \
)

#define ESPDR_IS_CALIB(tag) (	\
		(strcmp(tag, ESPDR_PRO_CATG_MBIAS) == 0) || \
		(strcmp(tag, ESPDR_PRO_CATG_MBIAS_RES) == 0) || \
		(strcmp(tag, ESPDR_PRO_CATG_MDARK) == 0) || \
		(strcmp(tag, ESPDR_PRO_CATG_HOT_PIXELS) == 0) || \
		(strcmp(tag, ESPDR_PRO_CATG_BAD_PIXELS) == 0) || \
		(strstr(tag, ESPDR_PRO_CATG_ORDERS) != NULL)  || \
		(strstr(tag, ESPDR_PRO_CATG_ORDER_PROFILE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_FLAT) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_BLAZE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_MASTER_ORDER_PROFILE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_MASTER_FLAT) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_MASTER_BLAZE) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_S2D) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_S2D_BLAZE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_FP_SEARCHED_LINE_TABLE) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_WAVE_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_DLL_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_AIR_WAVE_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_AIR_DLL_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_LFC_WAVE_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_LFC_DLL_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_LFC_AIR_WAVE_MATRIX) != NULL) || \
		(strstr(tag, ESPDR_PRO_CATG_LFC_AIR_DLL_MATRIX) != NULL) || \
        (strcmp(tag, ESPDR_PRO_CATG_CONTAM_FP) == 0) || \
        (strcmp(tag, ESPDR_PRO_CATG_CONTAM_THAR) == 0) || \
        (strcmp(tag, ESPDR_PRO_CATG_CONTAM_LFC) == 0) || \
        (strstr(tag, ESPDR_PRO_CATG_REL_EFF) != NULL) || \
        (strcmp(tag, ESPDR_PRO_CATG_ABS_EFF) == 0) \
)

#define ESPDR_IS_CONFIG(tag) (	\
		(strcmp(tag, ESPDR_CCD_GEOM) == 0)	|| \
        (strcmp(tag, ESPDR_INST_CONFIG) == 0) || \
        (strcmp(tag, ESPDR_MASTER_INST_CONFIG) == 0) || \
		(strcmp(tag, ESPDR_LED_FF_GAIN_WINDOWS) == 0) || \
        (strcmp(tag, ESPDR_ORDERS_MASK) == 0) || \
        (strstr(tag, ESPDR_PRO_CATG_REF_LINE_TABLE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_STATIC_LINE_TABLE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_AR_LINE_TABLE) != NULL) || \
        (strcmp(tag, ESPDR_STD_STARS_TABLE) == 0) || \
        (strcmp(tag, ESPDR_EXTINCTION_TABLE) == 0) || \
		(strcmp(tag, ESPDR_MASK_LUT_TABLE) == 0) || \
        (strstr(tag, ESPDR_PRO_CATG_MASK) != NULL)  || \
		(strstr(tag, ESPDR_FLUX_TEMPLATE) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_PIXEL_GEOM) != NULL) || \
        (strstr(tag, ESPDR_PRO_CATG_PIXEL_SIZE) != NULL) || \
        (strcmp(tag, ESPDR_CRH_MAP) == 0) || \
        (strstr(tag, ESPDR_HITRAN_LINES_QT) != NULL) || \
        (strstr(tag, ESPDR_HITRAN_LINES_STRONGEST) != NULL) || \
        (strstr(tag, ESPDR_HITRAN_CCF_MASK) != NULL) || \
        (strstr(tag, ESPDR_RES_MAP) != NULL) || \
        (strstr(tag, ESPDR_OH_SKY_MASTER) != NULL) || \
        (strcmp(tag, ESPDR_OH_LINES_REGIONS) == 0) \
)

#define ESPDR_IS_RAW_WAVE(tag) ( \
        (strcmp(tag, ESPDR_WAVE_FP_FP_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_THAR_FP_RAW) == 0) || \
		(strcmp(tag, ESPDR_WAVE_FP_THAR_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_THAR_DARK_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_DARK_THAR_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_LFC_FP_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_FP_LFC_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_THAR_THAR_RAW) == 0) || \
        (strcmp(tag, ESPDR_WAVE_LFC_LFC_RAW) == 0) \
)

#define ESPDR_IS_RAW_FP_FP(tag) ( \
		(strcmp(tag, ESPDR_WAVE_FP_FP_RAW) == 0))

#define ESPDR_IS_RAW_THAR_FP(tag) ( \
		(strcmp(tag, ESPDR_WAVE_THAR_FP_RAW) == 0))

#define ESPDR_IS_RAW_FP_THAR(tag) ( \
		(strcmp(tag, ESPDR_WAVE_FP_THAR_RAW) == 0))

#define ESPDR_IS_RAW_THAR_DARK(tag) ( \
        (strcmp(tag, ESPDR_WAVE_THAR_DARK_RAW) == 0))

#define ESPDR_IS_RAW_DARK_THAR(tag) ( \
        (strcmp(tag, ESPDR_WAVE_DARK_THAR_RAW) == 0))

#define ESPDR_IS_RAW_LFC_FP(tag) ( \
		(strcmp(tag, ESPDR_WAVE_LFC_FP_RAW) == 0))

#define ESPDR_IS_RAW_FP_LFC(tag) ( \
		(strcmp(tag, ESPDR_WAVE_FP_LFC_RAW) == 0))

#define ESPDR_IS_RAW_THAR_THAR(tag) ( \
		(strcmp(tag, ESPDR_WAVE_THAR_THAR_RAW) == 0))

#define ESPDR_IS_RAW_LFC_LFC(tag) ( \
		(strcmp(tag, ESPDR_WAVE_LFC_LFC_RAW) == 0))

#define ESPDR_IS_SCIENCE(tag) ( \
		(strstr(tag, ESPDR_SCIENCE_RAW) != NULL))

#define ESPDR_IS_SCIENCE_HEADER(tag) ( \
        (strstr(tag, ESPDR_SCIENCE_HEADER_RAW) != NULL))

#define ESPDR_IS_RAW_CONTAM(tag) ( \
        (strstr(tag, ESPDR_CONTAM_RAW) != NULL))

#define ESPDR_IS_RES_MAP(tag) ( \
        (strstr(tag, ESPDR_RES_MAP) != NULL))

#define ESPDR_IS_HITRAN_LINES_QT(tag) ( \
        (strstr(tag, ESPDR_HITRAN_LINES_QT) != NULL))

#define ESPDR_IS_HITRAN_LINES_STRONGEST(tag) ( \
        (strstr(tag, ESPDR_HITRAN_LINES_STRONGEST) != NULL))

#define ESPDR_IS_HITRAN_CCF_MASK(tag) ( \
        (strstr(tag, ESPDR_HITRAN_CCF_MASK) != NULL))

/*----------------------------------------------------------------------------
 Prototypes
 ----------------------------------------------------------------------------*/
cpl_frame* espdr_get_mbias_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames);

cpl_frame* espdr_get_hpixmap_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames);

cpl_frame* espdr_get_mdark_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames);

cpl_frame* espdr_get_bpixmap_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames);

cpl_frame* espdr_get_orders_mask_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames);

cpl_error_code espdr_get_orders_coeff_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        const int ext_nb,
        cpl_table **** orders_coeffs);

cpl_error_code espdr_get_order_profile_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        const int ext_nb,
        cpl_frame *** order_profile_fibre_frame);

cpl_error_code espdr_get_flat_fibre_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        const int ext_nb,
        cpl_frame *** flat_fibre_frame);

cpl_error_code espdr_get_blaze_fibre_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        const int ext_nb,
        cpl_frame *** blaze_fibre_frame);

cpl_error_code espdr_get_pixel_geom_fibre_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        const int ext_nb,
        int** pixel_geom_nb_check,
        cpl_frame *** pixel_geom_fibre_frame);
                                                   
cpl_error_code espdr_get_pixel_size_fibre_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        const int ext_nb,
        int** pixel_size_nb_check,
        cpl_frame *** pixel_size_fibre_frame);

cpl_error_code espdr_get_static_wave_matrix_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        cpl_image *** wave_matrix);

cpl_error_code espdr_get_static_dll_matrix_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        const int fibres_nb,
        cpl_image ***dll_matrix);

cpl_error_code espdr_get_raw_flat_frames_from_set(const cpl_frameset* set,
        const int fibres_nb,
        const int raw_flat_limit_nb,
        cpl_frameset **flat_frames,
        cpl_frameset* used_frames);

cpl_frame* espdr_get_wave_matrix_frame_from_set(cpl_frameset* set,
        cpl_frameset* used_frames,
        const char* suffix1,
        const char* suffix2,
        const int fid);

cpl_frame* espdr_get_dll_matrix_frame_from_set(cpl_frameset* set,
        cpl_frameset* used_frames,
        const char* suffix1,
        const char* suffix2,
        const int fid);

cpl_error_code espdr_get_static_res_map_from_set(const cpl_frameset* set,
        cpl_frameset* used_frames,
        cpl_image **res_map);

cpl_error_code espdr_get_static_model_frames_from_set(const cpl_frameset* set,
        cpl_frameset *used_frames,
        cpl_frameset *hitran_qt_frames,
        cpl_frameset *hitran_strongest_frames,
        cpl_frameset *hitran_ccf_masks);

cpl_error_code espdr_get_OH_static_frames_from_set(const cpl_frameset* set,
        cpl_frameset *used_frames,
        cpl_image **master_spectrum_A,
        cpl_image **master_error_A,
        cpl_image **dll_A,
        cpl_image **master_spectrum_B,
        cpl_image **master_error_B,
        cpl_image **dll_B,
        cpl_frame **lines_regions);

cpl_error_code espdr_dfs_set_groups(cpl_frameset *set);

cpl_error_code espdr_frame_new(cpl_frame **frame,
		const char *filename,
		cpl_frame_group group,
		cpl_frame_level level,
		cpl_frame_type type,
		const char *tag);

cpl_error_code espdr_insert_frame(const cpl_frameset* set,
        const char* tag,
        cpl_frameset* out,
        cpl_frameset* use);

cpl_error_code espdr_frameset_cleanup(cpl_frameset** set,
        const int nb);

cpl_error_code espdr_frame_split_raw_calib(cpl_frameset *set,
        cpl_frameset *raw_RE,
        cpl_frameset *calib_RE);

cpl_error_code espdr_frameset_extract_calib(cpl_frameset *set,
        cpl_frameset **calib_RE);

cpl_error_code espdr_frame_extract_by_tag(const cpl_frameset *set,
        const char* tag,
        cpl_frameset* extracted_RE);

cpl_boolean espdr_frameset_has_frame(const cpl_frameset *set,
        const char* tag);

cpl_frame* espdr_frame_find(const cpl_frameset *set,
        const char* tag);

cpl_error_code espdr_extract_extensions(cpl_frame *input_frame,
		cpl_type frame_type,
		const int ext_nr,
		cpl_imagelist **extracted_RE);

cpl_error_code espdr_extract_raw_outputs(cpl_frameset *input_frameset,
		cpl_type frame_type,
		espdr_CCD_geometry *CCD_geom,
		cpl_imagelist **all_outputs_RE);

cpl_error_code espdr_extract_raw_outputs_one_frame(cpl_frame *input_frame,
        cpl_type frame_type,
        espdr_CCD_geometry *CCD_geom,
        cpl_imagelist **all_outputs_RE);

cpl_error_code espdr_extract_real_outputs(cpl_frame *input_frame,
		cpl_type frame_type,
		espdr_CCD_geometry *CCD_geom,
        int start,
		cpl_imagelist **all_outputs_RE);

cpl_error_code espdr_extract_real_outputs_from_raw(cpl_frameset *input_frameset,
		cpl_type frame_type,
		const espdr_CCD_geometry *CCD_geom,
		cpl_imagelist **all_outputs_RE);

cpl_error_code espdr_extract_real_outputs_one_frame(cpl_frame *input_frame,
        cpl_type frame_type,
        const espdr_CCD_geometry *CCD_geom,
        cpl_imagelist **all_outputs_RE);

cpl_error_code espdr_dfs_image_save(cpl_frameset *all_frames,
		const cpl_parameterlist *parameters,
		const cpl_frameset *used_frames,
		const char *recipe,
		cpl_propertylist *keywords,
		cpl_propertylist **keywords_ext,
		const char *filename,
		cpl_imagelist *images_to_save,
		cpl_type image_type,
		espdr_CCD_geometry *CCD_geom);

cpl_error_code espdr_dfs_image_save_with_pxl_nb(cpl_frameset *all_frames,
        const cpl_parameterlist *parameters,
        const cpl_frameset *used_frames,
        const char *recipe,
        cpl_propertylist *keywords,
        cpl_propertylist **keywords_ext,
        const char *filename,
        cpl_imagelist *images_to_save,
        cpl_imagelist *images_pxl_nb_to_save,
        cpl_type image_type,
        espdr_CCD_geometry *CCD_geom);

cpl_error_code espdr_dfs_image_save_one_ext(cpl_frameset *all_frames,
		const cpl_parameterlist *parameters,
		const cpl_frameset *used_frames,
		const char *recipe,
		cpl_propertylist *keywords,
		const char *filename,
		cpl_image *image_to_save,
		cpl_type image_type);

cpl_error_code espdr_dfs_save_data_err_qual(cpl_frameset *all_frames,
		const cpl_parameterlist *parameters,
		const cpl_frameset *used_frames,
		const char *recipe,
		cpl_propertylist *keywords,
		const char *filename,
		cpl_image **images_to_save);

cpl_error_code espdr_dfs_save_data_err_qual_wave(cpl_frameset *all_frames,
		const cpl_parameterlist *parameters,
		const cpl_frameset *used_frames,
		const char *recipe,
		cpl_propertylist *keywords,
		const char *filename,
		cpl_image **images_to_save);

cpl_error_code espdr_dfs_save_S2D(cpl_image *spectrum_img,
        cpl_image *error_img,
        cpl_image *quality_img,
        cpl_frameset* frameset,
        cpl_frameset* used_frames,
        cpl_parameterlist* parameters,
        cpl_propertylist* keywords,
        const char *filename,
        const char *pro_catg,
        const char *recipe);

cpl_error_code espdr_mask_save(cpl_frameset *all_frames,
        const cpl_parameterlist *parameters,
        const cpl_frameset *used_frames,
        const char *recipe,
        cpl_propertylist *keywords,
        cpl_propertylist **keywords_ext,
        const char *filename,
        cpl_mask **masks_to_save,
        espdr_CCD_geometry *CCD_geom);

cpl_error_code espdr_save_table_ASCII(cpl_table *FITS_table,
        const char *filename);

cpl_error_code espdr_keyword_add_int(const char *keyword_name,
		int keyword_value,
		const char *comment,
		cpl_propertylist **keywords_RE);

cpl_error_code espdr_keyword_add_double(const char *keyword_name,
		double keyword_value,
		const char *comment,
		cpl_propertylist **keywords_RE);

cpl_error_code espdr_keyword_add_string(const char *keyword_name,
		const char *keyword_value,
		const char *comment,
		cpl_propertylist **keywords_RE);

cpl_error_code espdr_add_arcfile_to_header(cpl_frameset *frameset,
        cpl_propertylist **keywords);

void espdr_property_dump(cpl_property *property);

char *espdr_add_ext_output_index_to_keyword(const char *keyword,
        const char *prefix,
        const int extension,
        const int output_x,
        const int output_y);

char *espdr_add_ext_detector_index_to_keyword(const char *prefix,
        const char *keyword,
        const int extension,
        const int output_x,
        const int output_y);

char *espdr_add_output_index_to_keyword(const char *prefix,
        const char *postfix,
        const int output_nr);

char *espdr_add_ext_nr_index_to_keyword(const char *prefix,
        const char *postfix,
        const int ext_nr,
        const int nr);

char *espdr_add_index_to_keyword(const char *prefix,
        const char *postfix,
        const int nr);

cpl_error_code espdr_compute_calibrations_intervals(cpl_frameset *frameset,
                                                    espdr_inst_config *inst_config,
                                                    cpl_propertylist *keywords,
                                                    char *wave_cal_source,
                                                    char *fibre_b,
                                                    double *mjd_obs_delta_time_wave,
                                                    char *recipe_name,
                                                    int *recipes);


#endif
