/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2014-10-28 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_CAL_FLUX_H
#define ESPDR_CAL_FLUX_H

/* DFS functions */
#include <espdr_instrument.h>
#include <espdr_dfs.h>
#include <espdr_keywords.h>

/* DRL functions*/
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>
#include <espdr_orders.h>
#include <espdr_background.h>
#include <espdr_fit.h>

/* Library */
#include <cpl.h>
#include <assert.h>

/* Constants */
#define  STD_TABLE_FILE "STD_TABLE.dump"

/* Wavelengths regions to be discarded */

#define  region_1_bound_ini 6260.0 /*Oxigen*/
#define  region_1_bound_end 6340.0 

#define  region_2_bound_ini 6860.0 /*Oxigen*/
#define  region_2_bound_end 7040.0 

#define  region_3_bound_ini 7140.0 /*Water*/
#define  region_3_bound_end 7420.0 

#define  region_4_bound_ini 7580.0 /*Oxigen*/
#define  region_4_bound_end 7720.0 

#define  region_5_bound_ini 9600.0 /* NIR blue side */
#define  region_5_bound_end 9775.0

#define  region_6_bound_ini 11100.0 /* tellurics blue side */
#define  region_6_bound_end 11650.0

//#define  region_7_bound_ini 13600.0 /* 1.4 micron gap */
//#define  region_7_bound_end 13970.0

#define  region_7_bound_ini 13200.0 /* 1.4 micron gap & tellurics */
#define  region_7_bound_end 15000.0

//#define  region_8_bound_ini 18300.0 /* NIR red side */
//#define  region_8_bound_end 18700.0

#define  region_8_bound_ini 17600.0 /* NIR red side & tellurics */
#define  region_8_bound_end 19193.0 /*18800.0*/

/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

int espdr_cal_flux(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);
cpl_error_code espdr_parameters_CAL_FLUX_create(const char* recipe_id,
                                            cpl_parameterlist *list,
                                            espdr_CAL_FLUX_param *p);

cpl_error_code espdr_parameters_CAL_FLUX_delete(espdr_CAL_FLUX_param* p);

cpl_error_code espdr_parameters_CAL_FLUX_get(const char* recipe_id, 
                                         cpl_parameterlist* list,
                                         espdr_CAL_FLUX_param *CAL_FLUX_param);

cpl_error_code espdr_parameters_CAL_FLUX_print(espdr_CAL_FLUX_param *CAL_FLUX_param);

espdr_CAL_FLUX_param *espdr_CAL_FLUX_param_init(const char *recipe_id,
                                        cpl_parameterlist *parameters);

cpl_error_code espdr_CAL_FLUX_read_parameters(cpl_frameset *frameset,
                                              espdr_CCD_geometry *CCD_geom,
                                              espdr_inst_config *inst_config);

cpl_error_code espdr_cal_flux_get_static_tables(cpl_frameset *frameset,
                                                cpl_frameset *used_frames,
                                                const char *star_name,
                                                cpl_table **std_star_table,
                                                cpl_table **extinction_table);

cpl_error_code espdr_convert_photons_to_energy(double tel_surface,
                                               double exp_time,
                                               cpl_table **s1d_energy_RE);

cpl_error_code espdr_load_standard_stars_table(cpl_table *standard_star_table,
                                               const char* star,
                                               cpl_table **selected_star_RE);

cpl_error_code espdr_measure_standard_flux(cpl_table *s1d_flux_energy,
                                           cpl_table *selected_star,
                                           cpl_table **measured_eff_flux_RE);

cpl_error_code espdr_pre_extinction_table_interpolation(cpl_table *ext_table,
                                           cpl_table *std_table,
                                           cpl_table **inter_extinction_RE);

cpl_error_code espdr_correct_extinction(cpl_table *avg_flux,
                                        cpl_table *ext_table,
                                        double airmass,
                                        cpl_table **corrected_flux_RE);

cpl_error_code espdr_correct_slit(cpl_table *extinction_corrected_flux,
                                  double seeing,
                                  espdr_inst_config *inst_config,
                                  cpl_table **slit_corrected_flux_RE);

cpl_error_code espdr_discard_wavelength_region(double bound_ini,
                                     	 double bound_end,
                                         cpl_table **discarded_wave_flux_RE);

cpl_error_code espdr_compute_efficiency(cpl_table *std_star,
                                        cpl_table *avg_flux_corrected,
                                        cpl_table **efficiency_RE);

cpl_error_code espdr_interpolated_eff(cpl_table *eff_table,
                                      cpl_table *s1d_table,
                                      cpl_table **s1d_eff_RE);

cpl_error_code espdr_polynomial_eff(int pol_deg,
                                    cpl_table *eff_table,
                                    cpl_table *s1d_table,
                                    cpl_table **s1d_eff_RE);

cpl_error_code espdr_cal_flux_QC(espdr_CCD_geometry *CCD_geom,
                                 espdr_inst_config *inst_config,
                                 espdr_qc_keywords *qc_kws,
                                 cpl_table *raw_abs_eff,
                                 cpl_table *abs_eff,
                                 double berv,
                                 double bjd,
                                 double bervmax,
                                 double berv_factor,
                                 int *cosmics_nb,
                                 double *snr,
                                 int orders_nr,
                                 int seeing_kw_qc,
                                 cpl_propertylist **keywords_RE);


#endif /* ESPDR_CAL_FLUX_H */
