from __future__ import absolute_import
from __future__ import print_function
from reflex import RecipeParameter


class Parameters(RecipeParameter):

    # This function specifies which are the parameters that should be presented
    # in the window to be edited.
    # Note that the parameter has to be also in the in_sop port (otherwise it 
    # won't appear in the window) 
    # The descriptions are used to show a tooltip. They should match one to one
    # with the parameter list 
    # Note also that parameters have to be prefixed by the 'recipe name:'

    def setOscanParameters(self, paramList, rec_id, group):
        group2 = "overscan"
        name4 = "ovsc_sig_clip_method"
        help4 = "method for sigma clipping in OVSC, can be mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group2, description=help4))

        name5 = "ovsc_ksigma"
        help5 = "ksigma for sigma clipping in OVSC, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group2, description=help5))

        name6 = "ovsc_max_iter"
        help6 = "maximal number of iterations in OVSC, must be between: 1 and 5000000. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group2, description=help6))

    def setBiasParameters(self, paramList, rec_id, group):
        name1 = "bias_sig_clip_method"
        group1 = "frames stack"
        help1 = "method for sigma clipping in MBIAS, can be: mean or median. [median]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group1, description=help1))

        name2 = "bias_ksigma"
        help2 = "ksigma for sigma clipping in MBIAS, must be between: 1.50 and 1000.00. [14.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group1, description=help2))

        name3 = "bias_max_iter"
        help3 = "maximal number of iterations in MBIAS, must be between: 1 and 5000000. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group1, description=help3))

        self.setOscanParameters(paramList, rec_id, group)

    def setDarkParameters(self, paramList, rec_id, group):
        self.setOscanParameters(paramList, rec_id, group)

        # name4="bias_correction_method"
        # help4="method for BIAS correction, can be auto, master_bias or overscan, use master_bias only if there is a permanent BIAS structure. [overscan]"
        # paramList.append(RecipeParameter(rec_id,displayName=name4,group=group,description=help4))
        group1 = "frame stack"
        name5 = "dark_sigma_clipping_method"
        help5 = "method for sigma clipping in master DARK, can be: mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group1, description=help5))

        name6 = "dark_ksigma"
        help6 = "ksigma for sigma clipping in MDARK, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group1, description=help6))

        name7 = "dark_max_iter"
        help7 = "maximal number of iterations in MDARK, must be between: 1 and 5000000. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group1, description=help7))

        group2 = "hotpix"

        name8 = "hot_pix_sig_clipping_method"
        help8 = "method for sigma clipping in HOT PIXELS, can be mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group2, description=help8))

        name9 = "hot_pix_ksigma"
        help9 = "ksigma for sigma clipping in HOT PIXELS, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group2, description=help9))

        name10 = "hot_pix_max_iter"
        help10 = "maximal number of iterations in HOT PIXELS, must be between: 1 and 5000000. [10000]"
        paramList.append(RecipeParameter(rec_id, displayName=name10, group=group2, description=help10))

        # name11="use_hdrl"
        # help11="0: do not use HDRL; 1: use HDRL. [0]"
        # paramList.append(RecipeParameter(rec_id,displayName=name13,group=group,description=help13))

    def setLedFFParameters(self, paramList, rec_id, group):
        self.setOscanParameters(paramList, rec_id, group)
        group1 = "frame stack"
        name5 = "led_ff_sigma_clipping_method"
        help5 = "method for sigma clipping in master LED_FF, can be: mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group1, description=help5))

        name6 = "led_ff_ksigma"
        help6 = "ksigma for sigma clipping in master LED_FF, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group1, description=help6))

        name7 = "led_ff_max_iter"
        help7 = "maximal number of iterations in master LED_FF, must be between: 1 and 5000000. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group1, description=help7))

        group2 = "badpix"

        name8 = "bad_pix_sig_clipping_method"
        help8 = "method for sigma clipping in BAD PIXELS, can be mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group2, description=help8))

        name9 = "bad_pix_ksigma"
        help9 = "ksigma for sigma clipping in BAD PIXELS, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group2, description=help9))

        name10 = "bad_pix_max_iter"
        help10 = "maximal number of iterations in BAD PIXELS, must be between: 1 and 5000000. [10000]"
        paramList.append(RecipeParameter(rec_id, displayName=name10, group=group2, description=help10))

    def setOrderdefParameters(self, paramList, rec_id, group):
        self.setOscanParameters(paramList, rec_id, group)

    def setFlatParameters(self, paramList, rec_id, group):
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "frame stack"
        name5 = "flat_sig_clip_method"
        help5 = "method for sigma clipping in master FLAT, can be: mean or median. [mean]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group2, description=help5))

        name7 = "flat_ksigma"
        help7 = "ksigma for sigma clipping in MFLAT, must be between: 1.50 and 1000.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group2, description=help7))

        name8 = "flat_max_iter"
        help8 = "maximal number of iterations in MFLAT, must be between: 1 and 5000000. [120]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group2, description=help8))

        group3 = "background correction"
        name12 = "background_sw"
        help12 = "Background measurement activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group3, description=help12))

        name13 = "bkgr_grid_size_x"
        help13 = "Grid size in x used to calculate the background, between: 128 and 512. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group3, description=help13))

        name14 = "bkgr_grid_size_y"
        help14 = "Grid size in y used to calculate the background, between: 128 and 512. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group3, description=help14))

        group4 = "extraction"

        # name15="flat_extraction_method"
        # help15="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name15,group=group4,description=help15))

        name16 = "extraction_ksigma"
        help16 = "ksigma for extraction, must be between: -2.00 and 20.00. [-1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name16, group=group4, description=help16))

    def setWaveCalFPParameters(self, paramList, rec_id, group):
        # print("wavecal FP params")
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "extraction"
        # name1="fp_extraction_method"
        # help1="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name1,group=group2,description=help1))

        name2 = "fp_extraction_ksigma"
        help2 = "ksigma for extraction, must be between: -2.00 and 20.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group2, description=help2))

    def setWaveCalTHARParameters(self, paramList, rec_id, group):
        # print("wavecal params")
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "extraction"
        # name1="thar_extraction_method"
        # help1="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name1,group=group2,description=help1))

        name2 = "thar_extraction_ksigma"
        help2 = "ksigma for extraction, must be between: -2.00 and 20.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group2, description=help2))

        group3 = "other"
        name3 = "d_fit_poly_deg"
        help3 = "d fit poly deg in wave_THAR, must be between: 1 and 50. [25]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group3, description=help3))

        name4 = "d_fit_small_res_limit"
        help4 = "d fit small res_limit in wave_THAR, must be between: 99 and 99. [50.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group3, description=help4))

        name5 = "wave_sol_poly_deg"
        help5 = "wavelength solution poly deg in wave_THAR, must be between: 1 and 1. [7]]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group3, description=help5))

    def setWaveCalParameters(self, paramList, rec_id, group):
        # print("wavecal params")
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "extraction"
        # name21="fp_extraction_method"
        # help21="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name21,group=group2,description=help21))

        name6 = "fp_extraction_ksigma"
        help6 = "ksigma for extraction, must be between: -2.00 and 20.00. [4.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group2, description=help6))

    def setContamParameters(self, paramList, rec_id, group):
        # print("contam params")
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "extraction"
        name1 = "contam_extraction_method"
        help1 = "Method used to extract orders. [horne]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group2, description=help1))

        name2 = "contam_extraction_ksigma"
        help2 = "ksigma used to extract orders. [3.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group2, description=help2))

        group3 = "background correction"
        name12 = "background_sw"
        help12 = "Background measurement activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group3, description=help12))

        name13 = "contam_bkgr_grid_size_x"
        help13 = "Grid size in x used to calculate the background, between: 128 and 512. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group3, description=help13))

        name14 = "contam_bkgr_grid_size_y"
        help14 = "Grid size in y used to calculate the background, between: 128 and 512. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group3, description=help14))

    def setEffABParameters(self, paramList, rec_id, group):
        # print("effab params")
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "extraction"
        # name1="eff_ab_extraction_method"
        # help1="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name1,group=group2,description=help1))

        name2 = "eff_ab_extraction_ksigma"
        help2 = "ksigma used to extract orders. [3.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group2, description=help2))

        group3 = "background correction"
        name12 = "background_sw"
        help12 = "Background measurement activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group3, description=help12))

        name13 = "eff_ab_bkgr_grid_size_x"
        help13 = "Grid size in x used to calculate the background, between: 128 and 512. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group3, description=help13))

        name14 = "eff_ab_bkgr_grid_size_y"
        help14 = "Grid size in y used to calculate the background, between: 128 and 512. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group3, description=help14))

        group4 = "efficiency"
        name15 = "eff_ab_poly_deg"
        help15 = "Efficiency computation fit polynomial degree. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name15, group=group4, description=help15))

    def setFluxParameters(self, paramList, rec_id, group):
        # print("effab params")
        self.setOscanParameters(paramList, rec_id, group)

        group2 = "extraction"
        # name1="flux_extraction_method"
        # help1="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name1,group=group2,description=help1))

        name2 = "flux_extraction_ksigma"
        help2 = "ksigma used to extract orders. [3.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group2, description=help2))

        group3 = "background correction"
        name12 = "background_sw"
        help12 = "Background measurement activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group3, description=help12))

        name13 = "bkgr_grid_size_x"
        help13 = "Grid size in x used to calculate the background, between: 128 and 512. [10]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group3, description=help13))

        name14 = "bkgr_grid_size_y"
        help14 = "Grid size in y used to calculate the background, between: 128 and 512. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group3, description=help14))

        group4 = "efficiency"
        name15 = "flux_poly_deg"
        help15 = "Efficiency computation fit polynomial degree. [3]"
        paramList.append(RecipeParameter(rec_id, displayName=name15, group=group4, description=help15))

    def setSciRedParameters(self, paramList, rec_id, group):
        # print("parameters rec id",rec_id)

        group0 = "general"
        name0 = "bias_res_removal_sw"
        help0 = "Flag indicating to remove or not MB residuals (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name0, group=group0, description=help0))

        # name1="extraction_method"
        # help1="Method used to extract orders. [horne]"
        # paramList.append(RecipeParameter(rec_id,displayName=name1,group=group0,description=help1))

        name1 = "cosmic_detection_sw"
        help1 = "LA Cosmic detection activation switch. [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name1, group=group0, description=help1))

        name22 = "extra_products_sw"
        help22 = "Set to TRUE to create extra products to inspect LA Cosmic results. [FALSE]"
        paramList.append(RecipeParameter(rec_id, displayName=name22, group=group0, description=help22))

        name2 = "ksigma_cosmic"
        help2 = "ksigma for removing cosmics on fiber A or SKY, -1.0 - no cosmics removal. [3.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name2, group=group0, description=help2))

        name3 = "wave_cal_source"
        help3 = "Wavelength calibration source to be used on science fiber ('THAR' or        'LFC'). [THAR]"
        paramList.append(RecipeParameter(rec_id, displayName=name3, group=group0, description=help3))

        name4 = "flux_correction_sw"
        help4 = "Flux correction activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name4, group=group0, description=help4))

        name5 = "slit_loss"
        help5 = "Slit loss in flux calibration. [-1.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name5, group=group0, description=help5))

        name6 = "sky_sub_method"
        help6 = "Method used to subtract the sky (pixel-by-pixel/smoothed). [pix-to-pix]"
        paramList.append(RecipeParameter(rec_id, displayName=name6, group=group0, description=help6))

        name7 = "sky_sub_sliding_box_size"
        help7 = "Sliding box size in smoothed sky subtraction. [200]"
        paramList.append(RecipeParameter(rec_id, displayName=name7, group=group0, description=help7))

        self.setOscanParameters(paramList, rec_id, group)

        group2 = "RV"
        name8 = "rv_center"
        help8 = "Approximate RV. In case of default (-9999), the pipeline will use the value of the FITS keyword OCS OBJ RV. [-9999]"
        paramList.append(RecipeParameter(rec_id, displayName=name8, group=group2, description=help8))

        name9 = "rv_range"
        help9 = "Range for the RV table. [20.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name9, group=group2, description=help9))

        name10 = "rv_step"
        help10 = " Range's step for the RV table in [km/s]. [0.5]"
        paramList.append(RecipeParameter(rec_id, displayName=name10, group=group2, description=help10))

        name11 = "mask_table_id"
        help11 = "Mask table to be used, defined by it's spectral type Id ('F9', 'G2', 'G8', 'G9', 'K2', 'K6', 'M0', 'M2', 'M3', 'M4' or 'M5'). In case of default ('XX') the pipeline will read the value of the FITS keyword OCS OBJ SP TYPE and uses a correspondence table to assign the closest available mask to the spectral type given by the FITS keyword or the user. [XX]"
        paramList.append(RecipeParameter(rec_id, displayName=name11, group=group2, description=help11))

        group4 = "background correction"
        name18 = "background_sw"
        help18 = "Background measurement activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name18, group=group4, description=help18))

        name19 = "sci_bkgr_grid_size_x"
        help19 = "Grid size in x used to calculate the background, between: 16 and 10000. [577]"
        paramList.append(RecipeParameter(rec_id, displayName=name19, group=group4, description=help19))

        name12 = "sci_bkgr_grid_size_y"
        help12 = "Grid size in y used to calculate the background, between: 16 and 10000. [256]"
        paramList.append(RecipeParameter(rec_id, displayName=name12, group=group4, description=help12))

        group5 = "drift correction"
        name13 = "drift_correction_sw"
        help13 = "Drift correction activation (on/off). [on]"
        paramList.append(RecipeParameter(rec_id, displayName=name13, group=group5, description=help13))

        name14 = "drift_method_fp"
        help14 = "Method adopted to compute drift. [flux_global_drift_global_sequential_fit]"
        paramList.append(RecipeParameter(rec_id, displayName=name14, group=group5, description=help14))

        name15 = "drift_space"
        help15 = "Space to compute drift (pixel/velocity). [pixel]"
        paramList.append(RecipeParameter(rec_id, displayName=name15, group=group5, description=help15))

        name16 = "drift_ksigma"
        help16 = "ksigma for computing drift, -1.0 - no ksigma clip. [50.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name16, group=group5, description=help16))

        group6 = "la-cosmic"
        name17 = "lacosmic.sigma_lim"
        help17 = "LA Cosmic Poisson fluctuation threshold. [5.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name17, group=group6, description=help17))

        name18 = "lacosmic.f_lim"
        help18 = "LA Cosmic minimum contrast. [5.0]"
        paramList.append(RecipeParameter(rec_id, displayName=name18, group=group6, description=help18))

        name19 = "lacosmic.max_iter"
        help19 = "LA Cosmic max number of iterations. [5]"
        paramList.append(RecipeParameter(rec_id, displayName=name19, group=group6, description=help19))

        name20 = "lacosmic.post-filter-x"
        help20 = "X Size of the post filtering kernel (odd number). [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name20, group=group6, description=help20))

        name21 = "lacosmic.post-filter-y"
        help21 = "Y Size of the post filtering kernel (odd number). [0]"
        paramList.append(RecipeParameter(rec_id, displayName=name21, group=group6, description=help21))
