/*                                                                           a
 *   This file is part of the ESO X-shooter Pipeline                         *
 *   Copyright (C) 2006 European Southern Observatory                        *
 *                                                                           *
 *   This library is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the Free Software             *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA    *
 *                                                                           */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-06 14:49:56 $
 * $Revision: 1.7 $
 * $Name: not supported by cvs2svn $
 */

/*----------------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------------*/

#include <espdr_CCD.h>
#include <espdr_parameters.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_instrument.h>
#include <espdr_keywords.h>

/*----------------------------------------------------------------------------
 Functions
 ----------------------------------------------------------------------------*/
static cpl_error_code
espdr_fill_bias_qc_keywords(espdr_inst_config *inst_config,
			    espdr_qc_keywords *qc_kws) {


  sprintf(qc_kws->qc_bias_outliers_kw, "%s QC BIAS OUTLIERS",
	  inst_config->prefix);

  sprintf(qc_kws->qc_ovsc_outliers_kw, "%s QC OVSC OUTLIERS",
	  inst_config->prefix);

  sprintf(qc_kws->qc_res_test_kw, "%s QC RES TEST",
	  inst_config->prefix);

  sprintf(qc_kws->qc_bias_ron_check_kw, "%s QC BIAS RON CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_bias_mean_check_kw, "%s QC BIAS MEAN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_bias_check_kw, "%s QC BIAS CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_bias_ron_kw, "%s QC OUT BIAS RON",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_ovsc_ron_kw, "%s QC OUT OVSC RON",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_bias_mean_kw, "%s QC OUT BIAS MEAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_res_mean_kw, "%s QC OUT RES MEAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_res_stdev_kw, "%s QC OUT RES STDEV",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_bias_ron_e_kw, "%s QC OUT BIAS RON EL",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_ovsc_ron_e_kw, "%s QC OUT OVSC RON EL",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_bias_mean_e_kw, "%s QC OUT BIAS MEAN EL",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_res_mean_e_kw, "%s QC OUT RES MEAN EL",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_res_stdev_e_kw, "%s QC OUT RES STDEV EL",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_res_test_kw, "%s QC OUT RES TEST",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_bias_ron_kw_part, " BIAS RON");

  sprintf(qc_kws->qc_out_ovsc_ron_kw_part, " OVSC RON");

  sprintf(qc_kws->qc_out_bias_mean_kw_part, " BIAS MEAN");

  sprintf(qc_kws->qc_out_res_mean_kw_part, " RES MEAN");

  sprintf(qc_kws->qc_out_res_stdev_kw_part, " RES STDEV");

  sprintf(qc_kws->qc_out_bias_ron_e_kw_part, " BIAS RON EL");

  sprintf(qc_kws->qc_out_ovsc_ron_e_kw_part, " OVSC RON EL");

  sprintf(qc_kws->qc_out_bias_mean_e_kw_part, " BIAS MEAN EL");

  sprintf(qc_kws->qc_out_res_mean_e_kw_part, " RES MEAN EL");

  sprintf(qc_kws->qc_out_res_stdev_e_kw_part, " RES STDEV EL");

  sprintf(qc_kws->qc_out_res_test_kw_part, " RES TEST");

  sprintf(qc_kws->qc_out_structx_kw_part, " BIAS STRUCTX");

  sprintf(qc_kws->qc_out_structy_kw_part, " BIAS STRUCTY");
  espdr_check_error_code("espdr_fill_bias_qc_keywords");
  return cpl_error_get_code();
}


static cpl_error_code
espdr_fill_dark_qc_keywords(espdr_inst_config *inst_config,
			    espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_dark_mean_check_kw, "%s QC DARK MEAN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_dark_cosmic_check_kw, "%s QC DARK COSMIC CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_dark_hotpix_check_kw, "%s QC DARK HOTPIX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_dark_check_kw, "%s QC DARK CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cosmic_rate_pix_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cosmic_rate_cm2_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cosmic_rate_cm2_kw_last, " COSMIC RATE CM2");

  sprintf(qc_kws->qc_cosmic_rate_pix_kw_last, " COSMIC RATE PIX");

  sprintf(qc_kws->qc_out_dark_mean_kw, "%s QC OUT DARK MEAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_hotpix_nb_kw, "%s QC OUT HOTPIX NB",
	  inst_config->prefix);

    sprintf(qc_kws->qc_out_dark_ron_kw, "%s QC OUT DARK RON",
        inst_config->prefix);

  sprintf(qc_kws->qc_out_dark_mean_kw_part, " DARK MEAN");

  sprintf(qc_kws->qc_out_hotpix_nb_kw_part, " HOTPIX NB");

    sprintf(qc_kws->qc_out_dark_ron_kw_part, " DARK RON");

  espdr_check_error_code("espdr_fill_dark_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_ledff_qc_keywords(espdr_inst_config *inst_config,
			     espdr_qc_keywords *qc_kws) {


  sprintf(qc_kws->qc_ledff_min_flux_kw, "%s QC MASTER MIN FLUX",
	  inst_config->prefix);

  sprintf(qc_kws->qc_ledff_max_flux_kw, "%s QC MASTER MAX FLUX",
	  inst_config->prefix);

  sprintf(qc_kws->qc_ledff_gain_check_kw, "%s QC LEDFF CONAD CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_ledff_badpix_check_kw, "%s QC LEDFF BADPIX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_ledff_flux_check_kw, "%s QC LEDFF MIN FLUX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_ledff_check_kw, "%s QC LEDFF CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_gain_kw, "%s QC OUT CONAD",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_mean_flux_kw, "%s QC OUT MEAN FLUX",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_min_flux_kw, "%s QC OUT MIN FLUX",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_max_flux_kw, "%s QC OUT MAX FLUX",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_badpix_nb_kw, "%s QC OUT BADPIX NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_out_gain_kw_part, " CONAD");

  sprintf(qc_kws->qc_out_mean_flux_kw_part, " MASTER MEAN FLUX");

  sprintf(qc_kws->qc_out_min_flux_kw_part, " MASTER MIN FLUX");

  sprintf(qc_kws->qc_out_max_flux_kw_part, " MASTER MAX FLUX");

  sprintf(qc_kws->qc_out_badpix_nb_kw_part, " BADPIX NB");
  espdr_check_error_code("espdr_fill_ledff_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_orderdef_qc_keywords(espdr_inst_config *inst_config,
				espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_order_nb_kw, "%s QC ORDER NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_order_pos_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_order_pos_kw_last, " POS");

  sprintf(qc_kws->qc_order_stdev_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_order_stdev_kw_last, " RES STDEV");

  sprintf(qc_kws->qc_order_min_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_order_min_kw_last, " RES MIN");

  sprintf(qc_kws->qc_order_max_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_order_max_kw_last, " RES MAX");

  sprintf(qc_kws->qc_order_phys_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_order_phys_nb_kw_last, " NB");

  sprintf(qc_kws->qc_orderdef_satur_check_kw, "%s QC ORDERDEF SATUR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_order_check_kw, "%s QC ORDERDEF ORDER CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_stdev_check_kw, "%s QC ORDERDEF STDEV CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_min_check_kw, "%s QC ORDERDEF MIN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_max_check_kw, "%s QC ORDERDEF MAX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_check_kw, "%s QC ORDERDEF CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_max_flux_kw_first, "%s QC OUTPUT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_orderdef_max_flux_kw_last, " MAX FLUX");
  espdr_check_error_code("espdr_fill_orderdef_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_flat_qc_keywords(espdr_inst_config *inst_config,
			    espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_flat_max_flux_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_max_flux_kw_last, " MAX FLUX");

  sprintf(qc_kws->qc_flat_bkgr_mean_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_bkgr_mean_kw_last, " BKGR MEAN");

  sprintf(qc_kws->qc_flat_bkgr_min_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_bkgr_min_kw_last, " BKGR MIN");

  sprintf(qc_kws->qc_flat_bkgr_max_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_bkgr_max_kw_last, " BKGR MAX");

  sprintf(qc_kws->qc_flat_order_cosmic_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_order_cosmic_nb_kw_last, " COSMIC NB");

  sprintf(qc_kws->qc_flat_order_snr_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_order_snr_kw_last, " SNR");

  sprintf(qc_kws->qc_flat_order_flat_rms_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_order_flat_rms_kw_last, " FLAT RMS");

  sprintf(qc_kws->qc_flat_darkpix_nb_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_darkpix_nb_kw_last, " DARKPIX NB");

  sprintf(qc_kws->qc_flat_satur_check_kw, "%s QC FLAT SATUR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_bkgr_check_kw, "%s QC FLAT BKGR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_snr_check_kw, "%s QC FLAT SNR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_rms_check_kw, "%s QC FLAT RMS CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_darkpix_check_kw, "%s QC FLAT DARKPIX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_flat_check_kw, "%s QC FLAT CHECK",
	  inst_config->prefix);
  espdr_check_error_code("espdr_fill_flat_qc_keywords");
  return cpl_error_get_code();
}


static cpl_error_code
espdr_fill_wave_qc_keywords(espdr_inst_config *inst_config,
			    espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_wave_order_cosmic_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_cosmic_nb_kw_last, "COSMIC NB");

  sprintf(qc_kws->qc_wave_cosmic_nb_kw, "%s QC COSMIC NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_lines_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_lines_nb_kw_last, "FP LINES NB");

  sprintf(qc_kws->qc_wave_lines_nb_kw, "%s QC FP LINES NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_lines_min_check_kw,
	  "%s QC LINES ORDER MIN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_lines_order_check_kw, "%s QC LINES ORDER CHECK",
	  inst_config->prefix);
    
    sprintf(qc_kws->qc_wave_lines_tot_check_kw, "%s QC LINES TOT CHECK",
            inst_config->prefix);
    
  sprintf(qc_kws->qc_wave_satur_lines_check_kw, "%s QC SATUR LINES CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_max_flux_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_max_flux_kw_last, " MAX FLUX");

  sprintf(qc_kws->qc_wave_thar_rejected_lines_kw, "%s QC THAR REJECTED LINES",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_valid_lines_nb_kw, "%s QC THAR LINES NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_fit_wave_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_fit_wave_kw_last, "FIT WAVE");

  sprintf(qc_kws->qc_wave_thar_flux_ratio_kw, "%s QC THAR FLUX RATIO",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_global_shift_kw, "%s QC THAR GLOBAL SHIFT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_chisq_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_chisq_kw_last, "CHI2");

  sprintf(qc_kws->qc_wave_order_rms_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_rms_kw_last, "RMS");

  sprintf(qc_kws->qc_wave_wavecal_error_kw, "%s QC WAVECAL ERROR",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_res_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_res_kw_last, "RESOL");

  sprintf(qc_kws->qc_wave_order_resol_mean_kw, "%s QC THAR RESOL MEAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_order_resol_median_kw, "%s QC THAR RESOL MEDIAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_offset_kw, "%s QC THAR OFFSET",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_satur_lines_nb_kw, "%s QC THAR SATUR LINES NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_flux_ratio_median_kw, "%s QC THAR FLUX RATIO MEDIAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_rv_diff_median_kw, "%s QC THAR RV DIFF MEDIAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_res_mad_kw_first, "%s QC THAR DET",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_res_mad_kw_last, "RESIDUALS MAD");

    sprintf(qc_kws->qc_wave_res_mad2_kw_first, "%s QC THAR DET",
        inst_config->prefix);

    sprintf(qc_kws->qc_wave_res_mad2_kw_last, "RESIDUALS MAD2");

    sprintf(qc_kws->qc_wave_res_rms_kw_first, "%s QC THAR DET",
        inst_config->prefix);

    sprintf(qc_kws->qc_wave_res_rms_kw_last, "RESIDUALS RMS");

    sprintf(qc_kws->qc_wave_res_rms2_kw_first, "%s QC THAR DET",
        inst_config->prefix);

    sprintf(qc_kws->qc_wave_res_rms2_kw_last, "RESIDUALS RMS2");

    sprintf(qc_kws->qc_wave_reject_lines_nb_kw_first, "%s QC THAR DET",
        inst_config->prefix);

    sprintf(qc_kws->qc_wave_reject_lines_nb_kw_last, "REJECT LINES NB");

    sprintf(qc_kws->qc_wave_fit_chi2_kw_first, "%s QC THAR DET",
        inst_config->prefix);

    sprintf(qc_kws->qc_wave_fit_chi2_kw_last, "FIT CHI2");

  sprintf(qc_kws->qc_wave_reject_lines_fraction_kw_first, "%s QC THAR DET",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_reject_lines_fraction_kw_last, "REJECT LINES FRACTION");

  //sprintf(qc_kws->qc_wave_d_offset_kw, "%s QC FP D OFFSET", inst_config->prefix);
  //sprintf(qc_kws->qc_wave_d_offset_err_kw, "%s QC FP D OFFSET ERROR", inst_config->prefix);
  //sprintf(qc_kws->qc_wave_d_offset_rms_kw, "%s QC FP D OFFSET RMS", inst_config->prefix);
    
    sprintf(qc_kws->qc_wave_fp_d_mean_kw, "%s QC FP D MEAN",
            inst_config->prefix);
    sprintf(qc_kws->qc_wave_fp_d_mean_error_kw, "%s QC FP D MEAN ERROR",
            inst_config->prefix);
    sprintf(qc_kws->qc_wave_fp_d_residuals_rms_kw, "%s QC FP D RESIDUALS RMS",
            inst_config->prefix);
    sprintf(qc_kws->qc_wave_fp_d_residuals_min_kw, "%s QC FP D RESIDUALS MIN",
            inst_config->prefix);
    sprintf(qc_kws->qc_wave_fp_d_residuals_max_kw, "%s QC FP D RESIDUALS MAX",
            inst_config->prefix);
    sprintf(qc_kws->qc_wave_fp_d_zone_kw_first, "%s QC FP D ZONE",
            inst_config->prefix);
    sprintf(qc_kws->qc_wave_fp_d_zone_mean_kw_last, "MEAN");
    sprintf(qc_kws->qc_wave_fp_d_zone_mean_error_kw_last, "MEAN ERROR");
    sprintf(qc_kws->qc_wave_fp_d_zone_wave_kw_last, "WAVE");

  sprintf(qc_kws->qc_wave_drift_mean_kw, "%s QC DRIFT MEAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_drift_error_kw, "%s QC DRIFT ERROR",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_drift_rejected_pxls_kw,
	  "%s QC DRIFT REJECTED PXLS", inst_config->prefix);

  sprintf(qc_kws->qc_wave_drift_flux_ratio_kw, "%s QC DRIFT FLUX RATIO",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_lamp_offset_ar_kw, "%s QC THAR LAMP OFFSET AR",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_lamp_offset_ar1_kw, "%s QC THAR LAMP OFFSET AR1",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_lamp_offset_ar2_kw, "%s QC THAR LAMP OFFSET AR2",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_lines_min_check_kw,
	  "%s QC THAR LINES ORDER MIN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_lines_tot_check_kw,
	  "%s QC THAR LINES TOT CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_flux_check_kw, "%s QC THAR FLUX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_chi2_check_kw, "%s QC FP CHI2 CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_rms_check_kw, "%s QC FP RMS CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_wavecal_error_check_kw,
	  "%s QC WAVE WAVECAL ERROR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_resol_check_kw, "%s QC THAR RESOL CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_satur_check_kw, "%s QC WAVE SATUR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_thar_flux_ratio_check_kw, "%s QC THAR FLUX RATIO CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_drift_chi2_check_kw, "%s QC DRIFT CHI2 CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_sol_qual_check_kw, "%s QC FP SOL QUAL CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_res_mad_check_kw, "%s QC THAR RESIDUALS MAD CHECK",
	  inst_config->prefix);

    sprintf(qc_kws->qc_wave_res_rms_check_kw, "%s QC THAR RESIDUALS RMS CHECK",
        inst_config->prefix);

  sprintf(qc_kws->qc_wave_reject_lines_fraction_check_kw,
	  "%s QC THAR REJECT LINES FRACTION CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_wave_check_kw, "%s QC WAVE CHECK",
	  inst_config->prefix);
  espdr_check_error_code("espdr_fill_wave_qc_keywords");
  return cpl_error_get_code();

}

static cpl_error_code
espdr_fill_lfc_qc_keywords(espdr_inst_config *inst_config,
			   espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_lfc_order_lines_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_order_lines_nb_kw_last, "LFC LINES NB");

  sprintf(qc_kws->qc_lfc_lines_nb_kw, "%s QC LFC LINES NB",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_order_lines_min_check_kw,
	  "%s QC LFC LINES ORDER MIN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_lines_tot_check_kw, "%s QC LFC LINES TOT CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_order_fit_wave_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_order_fit_wave_kw_last, "LFC FIT WAVE");

  sprintf(qc_kws->qc_lfc_order_chisq_kw_first, "%s QC LFC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_order_chisq_kw_last, "CHI2");

  sprintf(qc_kws->qc_lfc_order_rms_kw_first, "%s QC LFC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_order_rms_kw_last, "RMS");

  sprintf(qc_kws->qc_lfc_drift_mean_kw, "%s QC LFC DRIFT MEAN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_drift_error_kw, "%s QC LFC DRIFT ERROR",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_drift_rejected_pxls_kw,
	  "%s QC LFC DRIFT REJECTED PXLS", inst_config->prefix);

  sprintf(qc_kws->qc_lfc_drift_flux_ratio_kw,
	  "%s QC LFC DRIFT FLUX RATIO", inst_config->prefix);

  sprintf(qc_kws->qc_lfc_chisq_check_kw, "%s QC LFC CHI2 CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_rms_check_kw, "%s QC LFC RMS CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_lfc_check_kw, "%s QC LFC WAVE CHECK",
	  inst_config->prefix);

  espdr_check_error_code("espdr_fill_lfc_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_drift_qc_keywords(espdr_inst_config *inst_config,
			     espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_drift_prefix_kw, "%s QC DRIFT DET",
	  inst_config->prefix);

  sprintf(qc_kws->qc_drift_first_order_kw, "FIRST_ORDER");

  sprintf(qc_kws->qc_drift_last_order_kw, "LAST_ORDER");

  sprintf(qc_kws->qc_drift_flux_ratio_kw, "FLUX_RATIO");

  sprintf(qc_kws->qc_drift_flux_ratio_err_kw, "FLUX_RATIO_ERR");

  sprintf(qc_kws->qc_drift_mean_kw, "MEAN");

  sprintf(qc_kws->qc_drift_mean_err_kw, "MEAN_ERR");

  sprintf(qc_kws->qc_drift_slope_x_kw, "SLOPE_X");

  sprintf(qc_kws->qc_drift_slope_x_err_kw, "SLOPE_X_ERR");

  sprintf(qc_kws->qc_drift_slope_o_kw, "SLOPE_O");

  sprintf(qc_kws->qc_drift_slope_o_err_kw, "SLOPE_O_ERR");

  sprintf(qc_kws->qc_drift_chisq_kw, "CHISQ");

  sprintf(qc_kws->qc_drift_rejected_kw, "REJECTED");

  espdr_check_error_code("espdr_fill_drift_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_contam_qc_keywords(espdr_inst_config *inst_config,
			      espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_cal_contam_max_flux_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_contam_max_flux_kw_last, " MAX FLUX");

  sprintf(qc_kws->qc_cal_contam_min_flux_check_kw, "%s QC CONTAM FLUX CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_contam_check_kw, "%s QC CONTAM CHECK",
	  inst_config->prefix);

  espdr_check_error_code("espdr_fill_contam_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_effab_qc_keywords(espdr_inst_config *inst_config,
			     espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_mean_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_mean_kw_last, " BKGR MEAN");

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_min_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_min_kw_last, " BKGR MIN");

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_max_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_max_kw_last, " BKGR MAX");

  sprintf(qc_kws->qc_cal_eff_ab_order_cosmic_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_order_cosmic_nb_kw_last, " COSMIC NB");

  sprintf(qc_kws->qc_cal_eff_ab_order_snr_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_order_snr_kw_last, " SNR");

  sprintf(qc_kws->qc_cal_eff_ab_bkgr_check_kw, "%s QC EFFAB BKGR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_snr_check_kw, "%s QC EFFAB SNR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_eff_ab_check_kw, "%s QC EFFAB CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_rel_eff_min_kw, "%s QC REL EFF MIN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_rel_eff_max_kw, "%s QC REL EFF MAX",
	  inst_config->prefix);

  sprintf(qc_kws->qc_rel_eff_avg_kw, "%s QC REL EFF AVG",
	  inst_config->prefix);

  sprintf(qc_kws->qc_rel_eff_rms_kw, "%s QC REL EFF RMS",
	  inst_config->prefix);

  sprintf(qc_kws->qc_rel_eff_min_check_kw, "%s QC REL EFF MIN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_rel_eff_max_check_kw, "%s QC REL EFF MAX CHECK",
	  inst_config->prefix);

  espdr_check_error_code("espdr_fill_effab_qc_keywords");
  return cpl_error_get_code();

}

static cpl_error_code
espdr_fill_flux_qc_keywords(espdr_inst_config *inst_config,
			    espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_cal_flux_raw_abs_eff_min_kw, "%s QC MIN RAW ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_raw_abs_eff_max_kw, "%s QC MAX RAW ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_raw_abs_eff_mean_kw, "%s QC MEAN RAW ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_extcorr_abs_eff_min_kw, "%s QC MIN EXTCORR ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_extcorr_abs_eff_max_kw, "%s QC MAX EXTCORR ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_extcorr_abs_eff_mean_kw, "%s QC MEAN EXTCORR ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_abs_eff_min_kw, "%s QC MIN ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_abs_eff_max_kw, "%s QC MAX ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_abs_eff_mean_kw, "%s QC MEAN ABS EFF",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_abs_eff_min_check_kw, "%s QC MIN ABS EFF CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_abs_eff_max_check_kw, "%s QC MAX ABS EFF CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_max_flux_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_max_flux_kw_last, " MAX FLUX");

  sprintf(qc_kws->qc_cal_flux_bkgr_mean_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_bkgr_mean_kw_last, " BKGR MEAN");

  sprintf(qc_kws->qc_cal_flux_bkgr_min_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_bkgr_min_kw_last, " BKGR MIN");

  sprintf(qc_kws->qc_cal_flux_bkgr_max_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_bkgr_max_kw_last, " BKGR MAX");

  sprintf(qc_kws->qc_cal_flux_order_cosmic_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_order_cosmic_nb_kw_last, " COSMIC NB");

  sprintf(qc_kws->qc_cal_flux_order_snr_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_order_snr_kw_last, " SNR");
    
    sprintf(qc_kws->qc_cal_flux_snr_median_kw, "%s QC CALFLUX SNR MEDIAN",
            inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_satur_check_kw, "%s QC CALFLUX SATUR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_bkgr_check_kw, "%s QC CALFLUX BKGR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_cosmic_check_kw, "%s QC CALFLUX COSMIC CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_snr_check_kw, "%s QC CALFLUX SNR MEDIAN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_seeing_kw_check_kw, "%s QC CALFLUX SEEING KW CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_cal_flux_check_kw, "%s QC CALFLUX CHECK",
	  inst_config->prefix);
  espdr_check_error_code("espdr_fill_flux_qc_keywords");
  return cpl_error_get_code();
}

static cpl_error_code
espdr_fill_scired_qc_keywords(espdr_inst_config *inst_config,
			    espdr_qc_keywords *qc_kws) {

  sprintf(qc_kws->qc_sci_red_max_flux_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_max_flux_kw_last, " MAX FLUX");

    sprintf(qc_kws->qc_sci_red_berv, "%s QC BERV", inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_bjd, "%s QC BJD", inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_bervmax, "%s QC BERVMAX", inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_sed, "%s QC SED", inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_vtot, "%s QC VTOT", inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_berv_factor, "%s QC BERV FACTOR", inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_cosmic_nb2_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_cosmic_nb2_kw_last, " COSMIC NB2");

  sprintf(qc_kws->qc_sci_red_flux_corr_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_flux_corr_kw_last, " FLUX CORR");

  sprintf(qc_kws->qc_sci_ccf_rv, "%s QC CCF RV",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_rv_error, "%s QC CCF RV ERROR",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_fwhm, "%s QC CCF FWHM",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_fwhm_error, "%s QC CCF FWHM ERROR",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_contrast, "%s QC CCF CONTRAST",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_contrast_error, "%s QC CCF CONTRAST ERROR",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_continuum, "%s QC CCF CONTINUUM",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_ccf_mask, "%s QC CCF MASK",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_asym, "%s QC CCF FLUX ASYMMETRY",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_asym_error, "%s QC CCF FLUX ASYMMETRY ERROR",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_bis_span, "%s QC CCF BIS SPAN",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_bis_span_error, "%s QC CCF BIS SPAN ERROR",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_guiding_error, "%s QC GUIDING ERROR",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_expmeter_lowflux_time, "%s QC EXPMETER LOWFLUX TIME",
	  inst_config->prefix);
    sprintf(qc_kws->qc_sci_tmmean_used, "%s QC TMMEAN USED",
            inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_bkgr_mean_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_bkgr_mean_kw_last, " BKGR MEAN");

  sprintf(qc_kws->qc_sci_red_bkgr_min_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_bkgr_min_kw_last, " BKGR MIN");

  sprintf(qc_kws->qc_sci_red_bkgr_max_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_bkgr_max_kw_last, " BKGR MAX");

  sprintf(qc_kws->qc_sci_red_order_cosmic_nb_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_order_cosmic_nb_kw_last, " COSMIC NB");

  sprintf(qc_kws->qc_sci_red_order_snr_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_order_snr_kw_last, " SNR");

  sprintf(qc_kws->qc_sci_red_order_sci_red_rms_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_order_sci_red_rms_kw_last, " SCIRED RMS");

  sprintf(qc_kws->qc_sci_red_darkpix_nb_kw_first, "%s QC EXT",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_darkpix_nb_kw_last, " DARKPIX NB");

  sprintf(qc_kws->qc_sci_red_satur_check_kw, "%s QC SCIRED SATUR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_bkgr_check_kw, "%s QC SCIRED BKGR CHECK",
	  inst_config->prefix);

    
    sprintf(qc_kws->qc_sci_red_oh_corr_oh_lines_nb_kw, "%s QC OHCORR LINES NB",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_oh_lines_nb_norm_kw, "%s QC OHCORR LINES NB NORM",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_oh_lines_check_kw, "%s QC OHCORR LINES CHECK",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_median_ratio_kw, "%s QC OHCORR MEDIAN RATIO",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_median_ratio_norm_kw, "%s QC OHCORR MEDIAN RATIO NORM",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_median_ratio_check_kw, "%s QC OHCORR MEDIAN RATIO CHECK",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_ratio_rms_kw, "%s QC OHCORR RATIO RMS",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_ratio_rms_norm_kw, "%s QC OHCORR RATIO RMS NORM",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_ratio_mad_kw, "%s QC OHCORR RATIO MAD",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_ratio_mad_norm_kw, "%s QC OHCORR RATIO MAD NORM",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_ratio_mad_check_kw, "%s QC OHCORR RATIO MAD CHECK",
            inst_config->prefix);
    sprintf(qc_kws->qc_sci_red_oh_corr_check_kw, "%s QC OHCORR CHECK",
            inst_config->prefix);
    
  sprintf(qc_kws->qc_sci_red_order_flux_corr_kw_first, "%s QC ORDER",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_order_flux_corr_kw_last, " FLUX CORR");

  sprintf(qc_kws->qc_sci_red_flux_corr_min_kw, "%s QC FLUX CORR MIN",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_flux_corr_max_kw, "%s QC FLUX CORR MAX",
	  inst_config->prefix);


  sprintf(qc_kws->qc_sci_red_cosmic_check_kw, "%s QC SCIRED COSMIC CHECK",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_red_flux_corr_check_kw, "%s QC SCIRED FLUX CORR CHECK",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_red_guiding_check_kw, "%s QC SCIRED GUIDING CHECK",
	  inst_config->prefix);
  sprintf(qc_kws->qc_sci_red_expmeter_check_kw, "%s QC SCIRED EXPMETER CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_drift_chi2_check_kw, "%s QC SCIRED DRIFT CHI2 CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_drift_flux_ratio_check_kw, "%s QC SCIRED DRIFT FLUX_RATIO CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_drift_mean_check_kw, "%s QC SCIRED DRIFT MEAN CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_drift_mean_err_check_kw, "%s QC SCIRED DRIFT MEAN_ERR CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_drift_check_kw, "%s QC SCIRED DRIFT CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->qc_sci_red_check_kw, "%s QC SCIRED CHECK",
	  inst_config->prefix);

  sprintf(qc_kws->crval1, "%s RV START",
	  inst_config->prefix);

  sprintf(qc_kws->cdelt1, "%s RV STEP",
	  inst_config->prefix);

  espdr_check_error_code("espdr_fill_scired_qc_keywords");
  return cpl_error_get_code();
}


static cpl_error_code
espdr_fill_shifted_extraction_qc_keywords(espdr_inst_config *inst_config,
                espdr_qc_keywords *qc_kws) {

    sprintf(qc_kws->qc_shifted_extraction_offset_kw, "%s QC EXTRACTION OFFSET",
            inst_config->prefix);
      
    sprintf(qc_kws->qc_shifted_extraction_check_kw, "%s QC SHIFTED EXTRACTION CHECK",
            inst_config->prefix);
    
    espdr_check_error_code("espdr_fill_shifted_extraction_qc_keywords");
    return cpl_error_get_code();
  }


/*----------------------------------------------------------------------------*/
/**
 @brief Fill the QC_keywords structure
 @param         inst_config inst_config structure
 @param[out]    qc_kws      qc_keywords structure
@return   CPL_ERROR_NONE iff OK
 */
/*----------------------------------------------------------------------------*/

cpl_error_code espdr_fill_qc_keywords(espdr_inst_config *inst_config,
				      espdr_qc_keywords *qc_kws) {

  /* There may be problem with prefix = TNG */
  sprintf(qc_kws->pro_catg_kw, "%s PRO CATG", inst_config->prefix);

  sprintf(qc_kws->qc_max_flux_kw, " MAX FLUX");
  sprintf(qc_kws->qc_saturation_check_kw, "%s QC SATURATION CHECK",
	  inst_config->prefix);

  /* mbias KWs*/
  espdr_fill_bias_qc_keywords(inst_config, qc_kws);

  /* mdark KWs */
  espdr_fill_dark_qc_keywords(inst_config, qc_kws);

  /* led_ff KWs */
  espdr_fill_ledff_qc_keywords(inst_config, qc_kws);

  /* orderdef KWs */
  espdr_fill_orderdef_qc_keywords(inst_config, qc_kws);

  /* mflat KWs */
  espdr_fill_flat_qc_keywords(inst_config, qc_kws);

  /* wave KWs*/
  espdr_fill_wave_qc_keywords(inst_config, qc_kws);

  /* LFC KWs*/
  espdr_fill_lfc_qc_keywords(inst_config, qc_kws);

  /* drift KWs */
  espdr_fill_drift_qc_keywords(inst_config, qc_kws);

  /* cal_contam KWs */
  espdr_fill_contam_qc_keywords(inst_config, qc_kws);

  /* cal_eff_ab KWs */
  espdr_fill_effab_qc_keywords(inst_config, qc_kws);

  /* cal_flux KWs */
  espdr_fill_flux_qc_keywords(inst_config, qc_kws);

  /* sci_red KWs */
  espdr_fill_scired_qc_keywords(inst_config, qc_kws);

    /* shifted_extrcation KWs */
    espdr_fill_shifted_extraction_qc_keywords(inst_config, qc_kws);

  espdr_check_error_code("espdr_fill_qc_keywords");
  return cpl_error_get_code();
}

/*----------------------------------------------------------------------------*/
/**
 @brief Print the QC_keywords structure
 @param qc_kws          qc_keywords structure
 @return   CPL_ERROR_NONE iff OK
 */
/*----------------------------------------------------------------------------*/


cpl_error_code espdr_print_qc_keywords(espdr_qc_keywords *qc_kws) {
    
    espdr_msg("PRO CATG: %s", qc_kws->pro_catg_kw);
    espdr_msg("CDELT1 : %s", qc_kws->crval1);
    espdr_msg("CRVAL1 : %s", qc_kws->cdelt1);
    
    /* mbias KWs*/
    espdr_msg("QC BIAS OUTLIERS: %s", qc_kws->qc_bias_outliers_kw);
    espdr_msg("QC OVSC OUTLIERS: %s", qc_kws->qc_ovsc_outliers_kw);
    espdr_msg("QC RES TEST: %s", qc_kws->qc_res_test_kw);
    espdr_msg("QC BIAS RON CHECK: %s", qc_kws->qc_bias_ron_check_kw);
    espdr_msg("QC BIAS MEAN CHECK: %s", qc_kws->qc_bias_mean_check_kw);
    espdr_msg("QC BIAS CHECK: %s", qc_kws->qc_bias_check_kw);
    espdr_msg("QC OUT BIAS RON: %s", qc_kws->qc_out_bias_ron_kw);
    espdr_msg("QC OUT OVSC RON: %s", qc_kws->qc_out_ovsc_ron_kw);
    espdr_msg("QC OUT BIAS MEAN: %s", qc_kws->qc_out_bias_mean_kw);
    espdr_msg("QC OUT RES MEAN: %s", qc_kws->qc_out_res_mean_kw);
    espdr_msg("QC OUT RES STDEV: %s", qc_kws->qc_out_res_stdev_kw);
    espdr_msg("QC OUT RES TEST: %s", qc_kws->qc_out_res_test_kw);
    espdr_msg("BIAS RON: %s", qc_kws->qc_out_bias_ron_kw_part);
    espdr_msg("OVSC RON: %s", qc_kws->qc_out_ovsc_ron_kw_part);
    espdr_msg("BIAS MEAN: %s", qc_kws->qc_out_bias_mean_kw_part);
    espdr_msg("RES MEAN: %s", qc_kws->qc_out_res_mean_kw_part);
    espdr_msg("RES STDEV: %s", qc_kws->qc_out_res_stdev_kw_part);
    espdr_msg("RES TEST: %s", qc_kws->qc_out_res_test_kw_part);
    espdr_msg("BIAS STRUCTX: %s", qc_kws->qc_out_structx_kw_part);
    espdr_msg("BIAS STRUCTY: %s", qc_kws->qc_out_structy_kw_part);
    
    /* mdark KWs */
    espdr_msg("QC DARK MEAN CHECK: %s", qc_kws->qc_dark_mean_check_kw);
    espdr_msg("QC DARK COSMIC CHECK: %s", qc_kws->qc_dark_cosmic_check_kw);
    espdr_msg("QC DARK HOTPIX CHECK: %s", qc_kws->qc_dark_hotpix_check_kw);
    espdr_msg("QC DARK CHECK: %s", qc_kws->qc_dark_check_kw);
    espdr_msg("QC EXT: %s", qc_kws->qc_cosmic_rate_pix_kw_first);
    espdr_msg("QC EXT: %s", qc_kws->qc_cosmic_rate_cm2_kw_first);
    espdr_msg("COSMIC RATE PIX: %s", qc_kws->qc_cosmic_rate_pix_kw_last);
    espdr_msg("COSMIC RATE CM2: %s", qc_kws->qc_cosmic_rate_cm2_kw_last);
    espdr_msg("QC OUT DARK MEAN: %s", qc_kws->qc_out_dark_mean_kw);
    espdr_msg("QC OUT HOTPIX NB: %s", qc_kws->qc_out_hotpix_nb_kw);
    espdr_msg("DARK MEAN: %s", qc_kws->qc_out_dark_mean_kw_part);
    espdr_msg("HOTPIX NB: %s", qc_kws->qc_out_hotpix_nb_kw_part);

    /* led_ff KWs */
    espdr_msg("QC LEDFF MIN FLUX: %s", qc_kws->qc_ledff_min_flux_kw);
    espdr_msg("QC LEDFF MAX FLUX: %s", qc_kws->qc_ledff_max_flux_kw);
    espdr_msg("QC LEDFF GAIN CHECK: %s", qc_kws->qc_ledff_gain_check_kw);
    espdr_msg("QC LEDFF BADPIX CHECK: %s", qc_kws->qc_ledff_badpix_check_kw);
    espdr_msg("QC LEDFF FLUX CHECK: %s", qc_kws->qc_ledff_flux_check_kw);
    espdr_msg("QC LEDFF CHECK: %s", qc_kws->qc_ledff_check_kw);
    espdr_msg("QC OUT GAIN: %s", qc_kws->qc_out_gain_kw);
    espdr_msg("QC OUT MIN FLUX: %s", qc_kws->qc_out_min_flux_kw);
    espdr_msg("QC OUT MAX FLUX: %s", qc_kws->qc_out_max_flux_kw);
    espdr_msg("QC OUT BADPIX NB: %s", qc_kws->qc_out_badpix_nb_kw);
    espdr_msg("GAIN: %s", qc_kws->qc_out_gain_kw_part);
    espdr_msg("MIN FLUX: %s", qc_kws->qc_out_min_flux_kw_part);
    espdr_msg("MAX FLUX: %s", qc_kws->qc_out_max_flux_kw_part);
    espdr_msg("BADPIX NB: %s", qc_kws->qc_out_badpix_nb_kw_part);
    
    /* orderdef KWs */
    espdr_msg("QC ORDER NB: %s", qc_kws->qc_order_nb_kw);
    espdr_msg("QC ORDER: %s", qc_kws->qc_order_pos_kw_first);
    espdr_msg("POS: %s", qc_kws->qc_order_pos_kw_last);
    espdr_msg("QC ORDER: %s", qc_kws->qc_order_stdev_kw_first);
    espdr_msg("STDEV: %s", qc_kws->qc_order_stdev_kw_last);
    espdr_msg("QC ORDER: %s", qc_kws->qc_order_phys_nb_kw_first);
    espdr_msg("PHYS NB: %s", qc_kws->qc_order_phys_nb_kw_last);
    espdr_msg("QC ORDERDEF SATUR CHECK: %s", qc_kws->qc_orderdef_satur_check_kw);
    espdr_msg("QC ORDERDEF ORDER CHECK: %s", qc_kws->qc_orderdef_order_check_kw);
    espdr_msg("QC ORDERDEF STDEV CHECK: %s", qc_kws->qc_orderdef_stdev_check_kw);
    espdr_msg("QC ORDERDEF CHECK: %s", qc_kws->qc_orderdef_check_kw);
    espdr_msg("QC EXT: %s", qc_kws->qc_orderdef_max_flux_kw_first);
    espdr_msg("MAX FLUX: %s", qc_kws->qc_orderdef_max_flux_kw_last);
    
    return(cpl_error_get_code());
}
