/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/


#include <stdio.h>

#include "bepop.h"


int main ( void )
{

  /* pointer to a derived type containing the parameters of the model */
  typeParamBEPOP * ptrBEPOP = NULL ; /* must be initialized at NULL to avoid errors */
  /* structure containing the output of BEPOP_compute routine */
  typeOutBEPOP resBEPOP ;

  /* Input arguments for the BEPOP_compute routine */
  double RightAscension,Declinaison,ProperMotionRightAscension,ProperMotionDeclinaison;
  int year, month, day, hour, minute ;
  double second;
  double TimeToMidExposure ;
  double StationLongitude, StationLatitude, StationAltitude ;


  /* Initialisation of the pointer to default parameters */
  ptrBEPOP=BEPOP_initDefault(1,ptrBEPOP) ; /* 1: most precise model (all nutations terms, all EOPs taken into account) */
  BEPOP_checkInit( ptrBEPOP); /* checks if all fields are consistent (should be useless when using BEPOP_initDefault() routine */

  /* Initialize input arguments */
    /* Star coordinates */
    RightAscension = 6.31 ; /* in decimal hour */
    Declinaison = 20.4 ; /* in degree */
    ProperMotionRightAscension = 0.001 ; /* in arscecond/year */
    ProperMotionDeclinaison = 0.003 ; /* in arscecond/year */
    /* Date and time of observation */
    year = 2007 ; month = 5 ; day = 17 ;
    hour = 23 ; minute = 41 ; second = 43.66 ;
    TimeToMidExposure = 600.0 ;
    /* Coordinates of the station */
    StationLongitude = 10.0 ; /* in degree */
    StationLatitude = 41.5 ; /* in degree */
    StationAltitude = 2300.4 ; /* in meters */

  /* Computes the quantities used for the radial velocities data reductions */
  BEPOP_compute( RightAscension, Declinaison,                       /* source coordinates */
                 ProperMotionRightAscension,ProperMotionDeclinaison,
                 year, month, day, hour, minute , second,           /*   date and time    */
                 TimeToMidExposure,
                 StationLongitude, StationLatitude, StationAltitude,/* station position   */
                 ptrBEPOP,                                          /*  model parameters  */
                 &resBEPOP);                                        /*     results        */

  /* Prints the results */
  printf("  Barycentric Earth Radial Velocity (in km/s)            : %10.6f\n",resBEPOP.BERV) ;
  printf("  maximum value of BERVMX (in km/s)                      : %6.2f\n",resBEPOP.BERVMX) ;
  printf("  Barycentric Time of Light Arrival, in julian day (TDB) : %20.12f\n",resBEPOP.BTLA) ;
  printf("  Barycentric Observer's Velocity (in km/s)              : %10.6f\n",resBEPOP.BOV) ;
  printf("  Sun-Earth distance (in km)                             : %16.6f\n",resBEPOP.SED) ;

/*
  Barycentric Earth Radial Velocity (in km/s)            : -18.465237
  maximum value of BERVMX (in km/s)                      :  31.96
  Barycentric Time of Light Arrival, in julian day (TDB) : 2454238.490423847456
  Barycentric Observer's Velocity (in km/s)              :  29.788654
  Sun-Earth distance (in km)                             : 151303271.819802
*/

  ptrBEPOP=BEPOP_close(ptrBEPOP) ; /* close the pointer and free memory */
  return (0);
}

