/*-----------------------------------------------------------------*/
/*!
  \file itrf_icrf.h
  \brief header file for itrf_icrf.c

  \author  H. Manche
           Astronomie et Systemes Dynamiques, IMCCE, CNRS, Observatoire de Paris.

   Copyright 2014, 2015, 2016, CNRS
   email of the author : herve.manche@obspm.fr

  last revision: 05/06/2014

  History:
  \note H. Manche 05/06/2014 : creation
 */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
/* License  of this file :
 This file is "triple-licensed", you have to choose one  of the three licenses
 below to apply on this file.

    CeCILL-C
    	The CeCILL-C license is close to the GNU LGPL.
    	( http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html )

 or CeCILL-B
        The CeCILL-B license is close to the BSD.
        (http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt)

 or CeCILL v2.0
      The CeCILL license is compatible with the GNU GPL.
      ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )


This library is governed by the CeCILL-C, CeCILL-B or the CeCILL license under
French law and abiding by the rules of distribution of free software.
You can  use, modify and/ or redistribute the software under the terms
of the CeCILL-C,CeCILL-B or CeCILL license as circulated by CEA, CNRS and INRIA
at the following URL "http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C,CeCILL-B or CeCILL license and that you accept its terms.
*/
/*-----------------------------------------------------------------*/

#ifndef ITRF_ICRF_H
#define ITRF_ICRF_H

#include "earth_orientation_parameters.h"



typedef struct
{

  char modelCIP[20] ; /* name of the model for CIP */
  int active_UT1mUTC ;
  int active_CorrectionCIP ;
  int active_PolarMotion ;

  void (*ptrF_XYS)(double,double,double*,double*,double*) ; /* pointer to a function that computes CIP coordinates and S parameter from Julian day TT */
  double (*ptrF_S)(double,double,double,double) ; /* pointer to a function that computes S parameter from Julian day TT and CIP's coordinates */




} t_ITCRF_Model;





void init_CIPmodel(const char *ModelName,t_ITCRF_Model *parameters);
void icrf_to_itrf_matrix(const double JulianDay_TT[2],
                         const EarthOrientationParameters_t EOPvalues,
                         double matrix[3][3], double dmatrix[3][3],
                         const t_ITCRF_Model parameters) ;
void itrf_to_icrf_matrix(const double JulianDay_TT[2],
                         const EarthOrientationParameters_t EOPvalues,
                         double matrix[3][3], double dmatrix[3][3],
                         const t_ITCRF_Model parameters) ;
void eq2000_to_ecl2000(const double vecEQ2000[3], double vecECL2000[3]);

#endif
