# import the needed modules
from __future__ import absolute_import
from __future__ import print_function
try:
  import reflex
  import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")


# import the needed modules
try:
#  import sys
  import numpy
  try:
    from astropy.io import fits as pyfits
  except ImportError:
    import pyfits
    
  import espdr_discrete_slider 
  import espdr_plot_common
  import espdr_parameters_common
#  import wx
#  import matplotlib
  import reflex
  #from xsh_plot_common import *
  from reflex import parseSofJson,RecipeParameter
  from reflex_interactive_app import PipelineInteractiveApp
  import reflex_plot_widgets
  from pipeline_product import PipelineProduct
  from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay
#  matplotlib.use('WXAgg')
  import_sucess = 'true'
  import warnings
  warnings.simplefilter('ignore',UserWarning)

#NOTE for developers: 
# -If you want to modify the current script to cope
#  with different parameters, this is the function to modify:
#  setInteractiveParameters()
# -If you want to modify the current script to read different data from
#  the input FITS, these are the functions (class DataPlotterManager) to modify:
#  readFitsData()    to indicate what are the FITS input to plot
#  setRecId()        to set rec id (used in parameter prefix)
#  getArmId()        to get arm id FITS header info
#
# -If you want to modify the current script to modify the plots (using the same
#  data),  this is the function to modify:
#  plotProductsGraphics()          (from class DataPlotterManager)
# -If you want to modify the text that appears in the "Help" button,
#  this is the function to modify:
#  setWindowHelp()
# -If you want to modify the title of the window, modify this function:
#  setWindowTitle()


  #This class deals with the specific details of data reading and final plotting.
  class DataPlotterManager:

    # This function will read all the columns, images and whatever is needed
    # from the products. The variables , self.plot_x, self.plot_y, etc...
    # are used later in function plotProductsGraphics().
    # Add/delete these variables as you need (only that plotProductsGraphics()
    # has to use the same names).
    # You can also create some additional variables (like statistics) after
    # reading the files.
    # If you use a control variable (self.xxx_found), you can modify 
    # later on the layout of the plotting window based on the presence of 
    # given input files. 
    # sof contains all the set of frames
    def readFitsData(self, fitsFiles):
      #Control variable to check if the interesting files where at the input
      #print fitsFiles
      self.fibre_id = 'fib A'
      self.nima = 0
      self.binx = 1
      self.biny = 1
      self.ext_ima =1
      self.decode_bp=2147483647
      self.fibre_id = 'fib A'
      self.order_id = 10
      self.product_id = 'S2D_A'
      self.table_id = 'S1D_A'
      self.ccf_b_found = False
      self.s1d_skysub_fluxcal_a_found = False 
      self.labels_tab = list()
      self.labels_prod = list()
      self.labels_err = ['yes','no']
      self.error_id = 'no'
      self.fib2_has_fp = False

      self.order_id_change = 'n'
      self.order_id_sto = self.order_id
      self.sci_red_found = False
      self.gauss_plot='y'
      self.rv=None
      self.ccf=None
      self.xg=None
      self.yg=None
      #Read all the products
      frames = dict()
      for frame in fitsFiles:
        if frame == '' :
          continue

        header = pyfits.open(frame.name)
        #Make sure to have only products from the same recipe
        #that used this (common) script 
        if 'ESO PRO REC1 ID' in header[0].header :
           rec_id = header[0].header['ESO PRO REC1 ID']
           #print "rec_id=", rec_id
           if rec_id == self.rec_id :
              category = frame.category
              frames[category] = frame
              #print("frame name:", frame.name,"category:",category)
 
# For any arm search a list of input frames
      #print frames
      key = "S2D_A"
      self.rescale=1

      if key in frames :
        self.s2d_a_found = True
        self.labels_prod.append(key)
        hdulist = frames[key]
        self.s2d_a = PipelineProduct(hdulist)
        #print("found", key)
        self.sci_red_found = True 
        key = 'ESO OBS TARG NAME'
        self.obs_targ_name =  self.s2d_a.readKeyword(key)

        
      key = "S2D_SKYSUB_A"
      if key in frames :
        hdulist = frames[key]
        self.s2d_skysub_a_found = True
        self.labels_prod.append(key)
        pfile = "HARPS_cleaned_wave.fits"
        if pfile == "HARPS_cleaned_wave.fits" :
          self.s2d_skysub_a = PipelineProduct(hdulist)
          #print("found", key)

      key = "S2D_B"
      if key in frames :
        self.s2d_b_found = True
        self.labels_prod.append(key)
        hdulist = frames[key]
        self.s2d_b = PipelineProduct(hdulist)
        #print("found", key)

      key = "S1D_SKYSUB_A"
      if key in frames :
        self.s1d_skysub_a_found = True
        self.labels_tab.append(key)
        hdulist = frames[key]
        self.s1d_skysub_a = PipelineProduct(hdulist)
        #print("found", key)
        #self.s1d_skysub_a = PlotableData( frames["S1D_SKYSUB_A"], x = "wavelength", y = "flux" )
      key = "S1D_SKYSUB_FLUXCAL_A"
      if key in frames :
        self.s1d_skysub_fluxcal_a_found = True
        self.labels_tab.append(key)
        hdulist = frames[key]
        self.s1d_skysub_fluxcal_a = PipelineProduct(hdulist)
        #self.s1d_skysub_fluxcal_a = PlotableData( frames["S1D_SKYSUB_FLUXCAL_A"], x = "wavelength", y = "flux_cal" )     
        #print("found", key)

      key = "S1D_A"
      if key in frames :
        self.s1d_a_found = True
        self.labels_tab.append(key)
        hdulist = frames[key]
        self.s1d_a = PipelineProduct(hdulist)
        #self.s1d_a = PlotableData( frames["S1D_A"], x = "wavelength", y = "flux" )
        #print("found", key)

      key = "S1D_FLUXCAL_A"
      if key in frames :
        self.s1d_fluxcal_a_found = True
        self.labels_tab.append(key)
        hdulist = frames[key]
        self.s1d_fluxcal_a = PipelineProduct(hdulist)
        #self.s1d_fluxcal_a = PlotableData( frames["S1D_FLUXCAL_A"], x = "wavelength", y = "flux_cal" )
        #print("found", key)

      key = "S1D_B"
      if key in frames :
        self.s1d_b_found = True
        self.labels_tab.append(key)
        hdulist = frames[key]
        self.s1d_b = PipelineProduct(hdulist)
        #self.s1d_b = PlotableData( frames["S1D_B"], x = "wavelength", y = "flux" )
        key = 'ESO PRO REC1 RAW1 CATG'
        raw_catg =  self.s1d_b.readKeyword(key)
        if 'FP' in raw_catg :
            self.fib2_has_fp = True
        key = 'ESO DET BINX'
        self.det_binx =  self.s1d_b.readKeyword(key)
        #print("found", key)

      key = "CCF_A"
      if key in frames :
        self.ccf_a_found = True
        self.labels_prod.append(key)
        hdulist = frames[key]
        self.ccf_a = PipelineProduct(hdulist)
        #print("found", key)

        key = 'ESO QC BJD'
        self.bjd_a = self.ccf_a.readKeyword(key)

        key = 'ESO QC BERV'
        self.berv_a = self.ccf_a.readKeyword(key)

        key = 'ESO QC CCF RV'
        self.rv_a = self.ccf_a.readKeyword(key)

        key = 'ESO QC CCF RV ERROR'
        self.rv_a_err = self.ccf_a.readKeyword(key)

        key = 'ESO RV START'
        self.rv_start=self.ccf_a.readKeyword(key)
	
        key = 'ESO RV STEP'
        self.rv_step=self.ccf_a.readKeyword(key)
        key = 'ESO QC SCIRED CHECK'
        self.qc_scired_check =  self.ccf_a.readKeyword(key)        
        
      key = "CCF_B"
      if key in frames :
        self.ccf_b_found = True
        self.labels_prod.append(key)
        
        hdulist = frames[key]
        self.ccf_b = PipelineProduct(hdulist)
        #print("found", key)
        key = 'ESO QC BJD'
        self.bjd_b = self.ccf_b.readKeyword(key)

        key = 'ESO QC BERV'
        self.berv_b = self.ccf_b.readKeyword(key)

        key = 'ESO QC CCF RV'
        self.rv_b = float(self.ccf_b.readKeyword(key))

        key = 'ESO QC CCF RV ERROR'
        self.rv_b_err = self.ccf_b.readKeyword(key)
        key = 'ESO QC SCIRED CHECK'
        self.qc_scired_check =  self.ccf_b.readKeyword(key)        
	
	
	
        
    #Set rec id (to have proper recipe parameters prefix)
    def setRecId(self, rec_id):
      #Recipe ID variable to properly define params
      self.rec_id = rec_id

    #Get arm setting
    def getArmId(self, sof):
      #Recipe ID variable to properly define params
      self.rec_id = "espdr_sci_red"
      nf = 0

      frames = dict()
      files = sof.files
      for f in files:
        frame=f.name
        if frame == '' :
          continue
        else :
           nf += 1
           hdulist = pyfits.open(frame)
           rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
      if nf != 0 :
         self.rec_id = rec_id_list[0:]

      #print "self.rec_id", self.rec_id
      if self.rec_id == "espdr_sci_red" :
         self.rec_subtitle = "Science Reduction. "
            
    # This function creates all the subplots. It is responsible for the plotting 
    # layouts. 
    # There can different layouts, depending on the availability of data
    # Note that subplot(I,J,K) means the Kth plot in a IxJ grid 
    # Note also that the last one is actually a box with text, no graphs.
    def addSubplots(self, figure):
      nrows=self.nima
      if self.sci_red_found == True :
 
        self.subplot_image = figure.add_subplot(4,1,1)
        self.subplot_spectrum  = figure.add_subplot(4,1,2)
        self.subplot_scatter  = figure.add_subplot(4,1,3)
        self.table_selector = figure.add_axes([0.60, 0.01, 0.35, 0.20])
        self.product_selector = figure.add_axes([0.01, 0.01, 0.40, 0.20])
        self.order_selector = figure.add_axes([0.11, 0.015, 0.25, 0.02])
        
        self.error_selector = figure.add_axes([0.45, 0.05, 0.13, 0.13],aspect='equal')

      else : 
        self.subtext_nodata    = figure.add_subplot(1,1,1)

    def plotWidgets(self) :
        widgets = list()

        labels_tab = self.labels_tab
        self.radiobutton_tab = reflex_plot_widgets.InteractiveRadioButtons(self.table_selector, self.setTableSelectCallBack, labels_tab, 0, title="Control lower panel")
        widgets.append(self.radiobutton_tab)

        labels_err = self.labels_err
        self.radiobutton_err = reflex_plot_widgets.InteractiveRadioButtons(self.error_selector, self.setErrorSelectCallBack, labels_err, 1, title="plot error?")
        widgets.append(self.radiobutton_err)


        
        labels_prod = self.labels_prod
        self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector, self.setProductSelectCallBack, labels_prod, 0, title="Control upper panels")
        widgets.append(self.radiobutton_pro)

        min=0
	
        val=self.order_id

        max=self.ima_sy
        title_slider="Select order id by clicking with mouse left button"
        self.slider =espdr_discrete_slider.InteractiveSlider2(self.order_selector,self.setOrderSelectCallBack,min,max,val,1,"order no")

        widgets.append(self.slider)

        return widgets

    def setOrderSelectCallBack(self, order_id) :        
        self.order_id = int(order_id)
        self.subplot_spectrum.cla()
        if 'S2D' in self.product_id :
           self.order_id_sto=self.order_id
        self.prepImage()
        self.plotSpectrum(self.order_id)
        self.order_id_change = 'y'

           

    def setProductSelectCallBack(self, product_id) :
        #print("Selected product id:", product_id)
        self.product_id = product_id
        self.subplot_image.cla()
        self.subplot_spectrum.cla()
        self.plotImage()
        if 'CCF' in self.product_id :
            self.order_id=self.ima_sy-1
            #print 'changed self.order_id to',self.order_id
            self.setOrderSelectCallBack(self.order_id)
            self.plotSpectrum(self.order_id)	    
        else :
            self.plotSpectrum(self.order_id)	    


    def setTableSelectCallBack(self, table_id) :
        self.table_id = table_id
        self.subplot_scatter.cla()
        self.plotQC()

    def setErrorSelectCallBack(self, error_id) :        
        self.error_id = error_id
        #print("error id",self.error_id) 
        self.subplot_scatter.cla()
        self.plotQC()

        
    def preparePlotQC(self) :
        #print("table id:", self.table_id)
        self.table=self.s1d_a
        x='wavelength'
        xLab='wavelength [$\AA$]'
        if self.table_id == "S1D_FLUXCAL_A" :
           y='flux_cal'
           yLab='flux [erg/s/cm$^2$/$\AA$]'
           self.table=self.s1d_fluxcal_a
           e='error_cal'
           q='quality'
           title='Flux and Wavelength Calibrated Object Spectrum   '
        else:
           yLab='flux [ADU]'
           y='flux'
           e='error_cal'
           q='quality'
           title='Spectrum in fibre B'
        if self.table_id == "S1D_SKYSUB_A" :
           self.table=self.s1d_skysub_a
           e='error'
           q='quality'
           title='Sky Corrected and Wavelength Calibrated Object Spectrum'
        elif self.table_id == "S1D_A" :
           self.table=self.s1d_a
           e='error'
           title='Wavelength Calibrated Object Spectrum'
        elif self.table_id == "S1D_B" :
           self.table=self.s1d_b
           y='flux'
           e='error'
           q='quality'
           if self.fib2_has_fp == True :
              if self.error_id == 'no' :
                 if self.det_binx == 2 :
                    self.rescale=3
                 else: 
                    self.rescale=6
              else :
                 if self.det_binx == 2 :
                    self.rescale=14
                 else: 
                    self.rescale=30

        elif  self.table_id == "S1D_SKYSUB_FLUXCAL_A" :
           y='flux_cal'
           e='error_cal'
           q=None
           self.table=self.s1d_skysub_fluxcal_a
           title='Sky Cor. Flux and Wavelength Calibrated Object Spectrum'
        elif  self.table_id == "S1D_FLUXCAL_A" :
           self.table=self.s1d_fluxcal_a
           e='error_cal'
           q=None
           title='Flux and Wavelength Calibrated Object Spectrum'

        tooltip='plot of '+title
                       
        self.title=title
        self.tooltip=tooltip
        
        self.x=x
        self.y=y
        self.e=e
        self.q=q
        self.xLab=xLab
        self.yLab=yLab
                
    def prepTitleAndTooltipImage(self) :
        title_pref = 'Linear-extracted and Merged Spectrum.'          

        tooltip_spectrum ="""\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """

        title_spectrum   = title_pref

        #Image
        spec_frameON   = ''
        #print "Recipe ID:",self.rec_id
        if self.fibre_id == 'fib A' :
             self.spec_frame   = 'Arc Lamp fibre A '
        else :
             self.spec_frame   = 'Arc Lamp fibre B '
        self.tooltip_frameON ="""\
           Overscan and bias structure corrected extracted (wavelength,order) science image. 
           """
    def prepTitleAndTooltipSpectrum(self) :
        self.s1db_title    = "Spectrum Fibre B"
        self.s1db_tooltip  = "Grey: non-rebinned data; green: rebinned data; blue: "\
                       "equalized data." 
        s1db_y_label  = r"SNR / pixel size [$\mathdefault{nm^{-1}}$]"
        all_x_label  = "Wavelength [nm]" 
        if 'CCF_A' in self.product_id:
          self.title_spectrum   = 'fit to CCF data points.'
          self.tooltip_spectrum ="Plot of the "+self.title_spectrum+" In green scatter plot of CCF data points"
        else :  
          self.title_spectrum   = 'Extracted Spectrum.'
          self.tooltip_spectrum ="""\
        Plot of the extracted spectrum. 
        Select on the slider above to choose the order to display.
        """

    def read_ccf( self ):
        """
        Read a CCF
        """
	
        key = 'ESO RV START'
        rv_arr0 = self.obj.readKeyword(key)
	
        key = 'ESO RV STEP'
        rv_arrd = self.obj.readKeyword(key)

        
        ccf = self.obj.all_hdu[1].data[self.order_id,:].copy()
	
        rv_arrN = len( ccf )
        #print "rv_arr0=",rv_arr0, "rv_arrd=",rv_arrd, "rv_arrN",rv_arrN
        rv_arr  = numpy.arange(rv_arrN)*rv_arrd + rv_arr0
        #print "size rv_arr",len(rv_arr)
        return rv_arr, ccf


    def get_gauss( self, x, v0, contrast, sig ):
        return contrast * numpy.exp( -( ( (x-v0)/sig )**2 )/2. ) 


    def prepGaussFit(self):
    
  
        self.rv, self.ccf = self.read_ccf()
        
        key = 'ESO QC CCF CONTRAST'
        contrast = self.obj.readKeyword(key)*0.01
	
        key = 'ESO QC CCF FWHM'
        fwhm = self.obj.readKeyword(key)
	
        key = 'ESO QC CCF MASK'
        self.rv_mask = self.obj.readKeyword(key)
	

        rv_arrN = len(self.obj.all_hdu[1].data[self.order_id,:])
	
	
	# get continuum
        nsamp=20
        continuum = numpy.median( sorted(self.ccf)[-nsamp:] )
	
        key = 'ESO QC CCF RV'
        v0 = self.obj.readKeyword(key)
        sig =  fwhm/(2*numpy.sqrt(2*numpy.log(2)))
        #print self.rv.min(), self.rv.max()
        xplot = numpy.linspace( self.rv.min(), self.rv.max(), numpy.ceil(numpy.ptp(self.rv))*5+1 )
        #print 'xplot=',xplot,"size xplot",len(xplot)
        ccf_fit = continuum * (1 - self.get_gauss(xplot,v0,contrast,sig))
        #print 'ccf_fit=',ccf_fit
        return xplot, ccf_fit
	   
        
     
    def prepImage(self) :
        #2D frame PRE format (predict/orderpos/2dmap/wavecal/flexcomp)
        self.xLabel='X [pix]'
	#print "self.order_id_sto",self.order_id_sto
        if self.order_id_change == 'y' and 'S2D' in self.product_id:
           self.order_id = self.order_id_sto
        if self.product_id == 'S2D_A' :
           self.obj = self.s2d_a
           self.spc = self.s2d_a
           spec_frame   = 'Fiber A '
           object = ' [ '+self.obs_targ_name+ ' ]'
           self.xLabel='X [pix]'
           self.yLabel='ADU'

        elif self.product_id == 'S2D_SKYSUB_A' :
           self.obj = self.s2d_skysub_a
           self.spc = self.s2d_skysub_a
           spec_frame   = 'Object Sky Subtracted fiber A '
           object = ' [ '+self.obs_targ_name+ ' ]'
           self.xLabel='X [pix]'
           self.yLabel='ADU'

          
        elif self.product_id == 'S2D_B' :
           self.obj = self.s2d_b
           self.spc = self.s2d_b
           spec_frame   = 'Fiber B'
           object = ' [Calibrator]'
           self.xLabel='X [pix]'
           self.yLabel='ADU'

        elif self.product_id == 'CCF_A' :
           self.obj = self.ccf_a
           self.spc = self.ccf_a

           self.obj.readImage(fits_extension=1)
           self.obj.read2DLinearWCS(fits_extension=1)
           y_size, x_size = self.obj.image.shape
           if self.order_id_change == 'n' :
              self.order_id=y_size-1

	   #Prepare Gauss fit
           self.gauss_plot='y'
           self.xg, self.yg= self.prepGaussFit()
           spec_frame   = 'CCFs for Fiber A '
           rv_info='\n RV=%#.4f+%#.4f km/s BERV=%#.4f km/s BJD=%.2f [JD]'% (self.rv_a,self.rv_a_err,self.berv_a,self.bjd_a)
           object = ' [ '+self.obs_targ_name+ ' ]'+rv_info
           self.xLabel='radial velocity [km/s]'
           self.yLabel='CCF'
           self.title_spectrum   = 'Cross Correlation Function'+' Spectral Type Mask '+self.rv_mask

        elif self.product_id == 'CCF_B' :
           self.obj = self.ccf_b
           self.spc = self.ccf_b
           spec_frame   = 'CCFs for Fiber B '
           self.gauss_plot='n'
           self.obj.readImage(fits_extension=1)
           self.obj.read2DLinearWCS(fits_extension=1)
           y_size, x_size = self.obj.image.shape
           key = 'ESO QC CCF RV'
           key = 'ESO PRO REC1 PARAM6 VALUE'
           self.rv_center = float(self.obj.readKeyword(key))

           self.order_id=y_size-1
           self.rv_x_off = self.rv_center - (x_size-1) / 2



           rv_info='\n RV=%#.4f+%#.4f km/s BERV=%#.4f km/s BJD=%.2f [JD]'% (self.rv_b,self.rv_b_err,self.berv_b,self.bjd_b)
           object = ' [Calibrator]'+rv_info
           self.xLabel='radial velocity [km/s]'
           self.yLabel='CCF'
           self.title_spectrum   = 'Cross Correlation Function'
 
        self.title_frame   = spec_frame+object+ ' QC CHECK:%#.1d'% (self.qc_scired_check)
        self.spec_frame = spec_frame
        sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']
        self.ima_sy=sy

    def plotImage(self) :
        self.prepTitleAndTooltipImage()
        self.prepImage()
        self.dpm.plotImageOnly(self.obj,self.ext_ima, self.binx,self.biny,self.xLabel, 'order number', self.subplot_image,self.title_frame,self.tooltip_frameON)

    def plotSpectrum2(self) :
        self.prepTitleAndTooltipSpectrum()
        self.prepImage()
        self.obj.plot(self.subplot_spectrum, self.s1db_title, 
                      self.s1db_tooltip, x_label = all_x_label, y_label = s1db_y_label)

    def plotSpectrum(self,order_id) :
        self.prepTitleAndTooltipSpectrum()
        self.prepImage()
	#print "xg=",self.xg, "yg=",self.yg
	#print "caller", self.gauss_plot
        self.dpm.plotImageSlice2(self.spc,self.spc,order_id,self.subplot_spectrum,self.title_spectrum,self.tooltip_spectrum,self.xLabel,self.yLabel,'None',self.gauss_plot,self.rv,self.ccf,self.xg,self.yg)

        
    def plotQC(self) :
        self.preparePlotQC()
        #print("table err")
        self.dpm.plotTableErrQual(self.table,self.x,self.y,self.e,self.q,self.decode_bp,self.error_id,self.xLab,self.yLab,self.subplot_scatter,self.title,self.tooltip,rescale=self.rescale)
        #self.dpm.plotTable(self.table,self.x,self.y,self.xLab,self.yLab,self.subplot_scatter,self.title,self.tooltip)
        
    def caseNodata(self) :
        #Data not found info
        self.subtext_nodata.set_axis_off()
        self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
        self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c', 
                                 fontsize=18, ha='left', va='center', alpha=1.0)
        self.subtext_nodata.tooltip="""\
                                    Merged spectrum not found in the products"""
        #print "found no spectrum data"
 
      
    # This is the function that makes the plots.
    # Add new plots or delete them using the given scheme.
    # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
    # It is mandatory to add a tooltip variable to each subplot.
    # One might be tempted to merge addSubplots() and plotProductsGraphics().
    # There is a reason not to do it: addSubplots() is called only once at
    # startup, while plotProductsGraphics() is called always there is a resize.
    def plotProductsGraphics(self):
      #print("self.sci_red_found:",self.sci_red_found)
      if (self.sci_red_found == True): 
        self.dpm = espdr_plot_common.DataPlotterManager()
        #print(self.product_id[0:3], self.fibre_id, self.product_id)
        if (self.product_id[0:3] == 'S1D' and self.fibre_id == 'fib A') or (self.product_id == 'S1D_B') :
            self.plotSpectrum2()
        elif (self.product_id[0:3] == 'S2D' or self.product_id[0:3] == 'CCF') :
            self.plotImage()
            self.plotSpectrum(self.order_id)  
        self.plotQC()
      else :
        self.caseNodata()
        
    # This function specifies which are the parameters that should be presented
    # in the window to be edited.
    # Note that the parameter has to be also in the in_sop port (otherwise it 
    # won't appear in the window) 
    # The descriptions are used to show a tooltip. They should match one to one
    # with the parameter list 
    # Note also that parameters have to be prefixed by the 'recipe name:'

    def setInteractiveParameters(self):
      paramList = list()
      rec_id=self.rec_id
      self.par = espdr_parameters_common.Parameters()
      #self.par.setGeneralCalibParameters(paramList,rec_id)
      if rec_id == "espdr_sci_red" :
         self.par.setSciRedParameters(paramList,"espdr_sci_red","all")

      else :
         print("recipe" ,rec_id,  "not supported")

      return paramList

    def setWindowHelp(self):
      help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
      return help_text

    def setWindowTitle(self):
      title = 'ESPRESSO Interactive Workflow: ' + self.rec_subtitle  
      return title

except ImportError:
  import_sucess = 'false'
  print("Error importing modules pyfits, wx, matplotlib, numpy")
  raise


#This is the 'main' function
if __name__ == '__main__':

  # import reflex modules
  from reflex import *
  from reflex_interactive_app import *
  from pipeline_display import *
  from pipeline_product import *

  # Create interactive application
  interactive_app = PipelineInteractiveApp(enable_init_sop=True)

  # PECULIAR XSH needs this in order to be able later to get from an input FITS
  # the ins-mode, arm (and recipe) IDs, used in titles and param setting
  # get inputs from the command line
  interactive_app.parse_args()
  inputs = interactive_app.inputs
  #(inputs, args) = interactive_app.parse_args()

  #Check if import failed or not
  if import_sucess == 'false' :
     interactive_app.setEnableGUI(false)

  #interactive_app.setEnableGUI(True)
  #Open the interactive window if enabled
  if interactive_app.isGUIEnabled() :
    #Get the specific functions for this window
    dataPlotManager = DataPlotterManager()
    #print inputs.in_sof
    #dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
    #With the following call XSH get the: ins-mode, arm (and recipe) IDs
    dataPlotManager.getArmId(inputs.in_sof)
    #Set recipe ID in order to build proper param list, display layout
    dataPlotManager.setRecId("espdr_sci_red")


    interactive_app.setPlotManager(dataPlotManager)
    interactive_app.showGUI()
  else :
    interactive_app.passProductsThrough()
   
  #Print outputs. This is parsed by the Reflex python actor to get the results
  #Do not remove
  interactive_app.print_outputs()
  sys.exit()
