# import the needed modules
from __future__ import absolute_import
from __future__ import print_function

try:
    import reflex

    import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")

# import the needed modules
try:
    #  import sys
    import numpy

    try:
        from astropy.io import fits as pyfits
    except ImportError:
        import pyfits

    import espdr_discrete_slider
    import espdr_plot_common
    import espdr_parameters_common
    #  import wx
    #  import matplotlib
    import reflex
    # from xsh_plot_common import *
    from reflex import parseSofJson, RecipeParameter
    from reflex_interactive_app import PipelineInteractiveApp
    import reflex_plot_widgets
    from pipeline_product import PipelineProduct
    from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay

    #  matplotlib.use('WXAgg')
    import_sucess = 'true'
    import warnings

    warnings.simplefilter('ignore', UserWarning)


    # NOTE for developers:
    # -If you want to modify the current script to cope
    #  with different parameters, this is the function to modify:
    #  setInteractiveParameters()
    # -If you want to modify the current script to read different data from
    #  the input FITS, these are the functions (class DataPlotterManager) to modify:
    #  readFitsData()    to indicate what are the FITS input to plot
    #  setRecId()        to set rec id (used in parameter prefix)
    #  getArmId()        to get arm id FITS header info
    #
    # -If you want to modify the current script to modify the plots (using the same
    #  data),  this is the function to modify:
    #  plotProductsGraphics()          (from class DataPlotterManager)
    # -If you want to modify the text that appears in the "Help" button,
    #  this is the function to modify:
    #  setWindowHelp()
    # -If you want to modify the title of the window, modify this function:
    #  setWindowTitle()

    # This class deals with the specific details of data reading and final plotting.
    class DataPlotterManager:

        # This function will read all the columns, images and whatever is needed
        # from the products. The variables , self.plot_x, self.plot_y, etc...
        # are used later in function plotProductsGraphics().
        # Add/delete these variables as you need (only that plotProductsGraphics()
        # has to use the same names).
        # You can also create some additional variables (like statistics) after
        # reading the files.
        # If you use a control variable (self.xxx_found), you can modify
        # later on the layout of the plotting window based on the presence of
        # given input files.
        # sof contains all the set of frames
        def readFitsData(self, fitsFiles):
            # Control variable to check if the interesting files where at the input
            # print fitsFiles
            self.fibre_id = 'fib A'
            self.nima = 0
            self.plot = 'table'

            self.binx = 1
            self.lfc_fitted_line_table_lfc_fp_a_found = False
            # self.qc_id = 'Resolution vs wavelength'
            self.qc_id = 'RMS wavelength solution vs order'
            self.ext_ima = 1
            self.biny = 1
            self.order_id = 10
            self.colorbar_check = 0
            self.labels_image = list()
            self.product_id = 'S2D_LFC_FP_A'

            # self.labels_qc= ['Resolution vs wavelength','Resolution Trend','SIG_K vs wavelength','RMS wavelength solution vs order','CHI2 vs order']
            self.labels_qc = ['RMS wavelength solution vs order', 'CHI2 vs order']

            # Read all the products
            frames = dict()
            # print frames
            for frame in fitsFiles:
                if frame == '':
                    continue

                header = pyfits.open(frame.name)
                # print "input frame name:", frame.name
                # Make sure to have only products from the same recipe
                # that used this (common) script
                if 'ESO PRO REC1 ID' in header[0].header:
                    rec_id = header[0].header['ESO PRO REC1 ID']
                    # print "rec_id=", rec_id, "category=",frame.category
                    if rec_id == self.rec_id or rec_id == "wave":
                        category = frame.category
                        frames[category] = frame
                        # print("frame name:", frame.name, "category:",category)

            # print("rec id:",rec_id)
            # print frames.keys()

            # For any arm search a list of input frames
            # print "frames=", frames
            key = "S2D_LFC_FP_A"
            if key in frames:
                self.s2d_lfc_fp_a_found = True
                hdulist = frames[key]
                self.s2d_lfc_fp_a = PipelineProduct(hdulist)
                self.labels_image.append(key)
                # print("found", key)

            key = "S2D_LFC_FP_B"
            if key in frames:
                self.s2d_lfc_fp_b_found = True
                hdulist = frames[key]
                self.s2d_lfc_fp_b = PipelineProduct(hdulist)
                self.labels_image.append(key)
                # print("found", key)

            key = "S2D_BLAZE_LFC_FP_A"
            if key in frames:
                self.s2d_blaze_lfc_fp_a_found = True
                hdulist = frames[key]
                self.s2d_blaze_lfc_fp_a = PipelineProduct(hdulist)
                self.labels_image.append(key)
                # print("found", key)

            key = "S2D_BLAZE_LFC_FP_B"
            if key in frames:
                self.s2d_blaze_lfc_fp_b_found = True
                hdulist = frames[key]
                self.s2d_blaze_lfc_fp_b = PipelineProduct(hdulist)
                self.labels_image.append(key)
                # print("found", key)

            key = "AIR_WAVE_MATRIX_LFC_FP_A"
            if key in frames:
                self.wave_matrix_lfc_fp_a_found = True
                hdulist = frames[key]
                self.wave_matrix_lfc_fp_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "AIR_DLL_MATRIX_LFC_FP_A"
            if key in frames:
                self.dll_matrix_lfc_fp_a_found = True
                hdulist = frames[key]
                self.dll_matrix_lfc_fp_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "LFC_FITTED_LINE_TABLE_LFC_FP_A"
            if key in frames:
                self.lfc_fitted_line_table_lfc_fp_a_found = True
                hdulist = frames[key]
                self.lfc_fitted_line_table_lfc_fp_a = PipelineProduct(hdulist)
                # print("found", key)

                key = 'ESO INS MODE'
                self.ins_mode = self.lfc_fitted_line_table_lfc_fp_a.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 170
                else:
                    self.ord_max = 86

                self.rms_a = list()
                self.chi2_a = list()
                self.order_nb_a = list()
                port = 0
                for ord in range(1, self.ord_max):
                    key1 = 'ESO QC ORDER%#.1d RMS' % (ord)
                    # print key
                    self.order_nb_a.append(ord)
                    self.rms_a.append(self.lfc_fitted_line_table_lfc_fp_a.readKeyword(key1))
                    key2 = 'ESO QC ORDER%#.1d CHI2' % (ord)
                    self.chi2_a.append(self.lfc_fitted_line_table_lfc_fp_a.readKeyword(key2))

                key = 'ESO QC LFC LINES NB'
                # print key
                self.tot_lines_nb_a = self.lfc_fitted_line_table_lfc_fp_a.readKeyword(key)
                key = 'ESO QC LFC WAVE CHECK'
                self.qc_wave_check = self.lfc_fitted_line_table_lfc_fp_a.readKeyword(key)

            key = "LINE_TABLE_RAW_THAR_FP_A"
            if key in frames:
                self.line_table_raw_thar_fp_a_found = True
                hdulist = frames[key]
                self.line_table_raw_thar_fp_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "WAVE_TABLE_THAR_FP_A"
            if key in frames:
                self.wave_table_thar_fp_a_found = True
                hdulist = frames[key]
                self.wave_table_thar_fp_a = PipelineProduct(hdulist)
                # print("found", key)

            key = "FP_FITTED_LINE_TABLE_THAR_FP_A"
            if key in frames:
                self.fp_fitted_line_table_thar_fp_a_found = True
                hdulist = frames[key]
                self.fp_fitted_line_table_tha_fp_a = PipelineProduct(hdulist)
                # print("found", key)

        # Set rec id (to have proper recipe parameters prefix)
        def setRecId(self, rec_id):
            # Recipe ID variable to properly define params
            self.rec_id = rec_id

        # Get arm setting
        def getArmId(self, sof):
            # Recipe ID variable to properly define params
            self.rec_id = "espdr_wave_LFC"
            nf = 0

            frames = dict()
            files = sof.files
            for f in files:
                frame = f.name
                if frame == '':
                    continue
                else:
                    nf += 1
                    hdulist = pyfits.open(frame)
                    rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
            if nf != 0:
                self.rec_id = rec_id_list[0:]

            # print("self.rec_id", self.rec_id)
            if self.rec_id == "espdr_wave_LFC":
                self.rec_subtitle = "Wavelength Calibration. "

        # This function creates all the subplots. It is responsible for the plotting
        # layouts.
        # There can different layouts, depending on the availability of data
        # Note that subplot(I,J,K) means the Kth plot in a IxJ grid
        # Note also that the last one is actually a box with text, no graphs.
        def addSubplots(self, figure):
            nrows = self.nima
            row = 1;

            if self.s2d_lfc_fp_a_found == True and \
                    self.s2d_lfc_fp_b_found == True:

                self.subplot_image = figure.add_subplot(4, 1, 1)
                self.subplot_spectrum = figure.add_subplot(4, 1, 2)
                self.subplot_scatter = figure.add_subplot(4, 1, 3)
                self.figure = figure

                self.product_selector = figure.add_axes([0.0, 0.001, 0.45, 0.16])
                self.order_selector = figure.add_axes([0.1, 0.01, 0.25, 0.01])
                # self.line_selector = figure.add_axes([-0.03, 0.28, 0.25, 0.13],aspect='equal')
                self.line_selector = figure.add_axes([0.50, 0.001, 0.45, 0.16])
                row += 1
                self.figure = figure
            else:
                self.subtext_nodata = figure.add_subplot(1, 1, 1)

        def plotWidgets(self):
            widgets = list()

            labels_image = self.labels_image
            self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector,
                                                                               self.setImageSelectCallBack,
                                                                               labels_image, 0,
                                                                               title="Control top panels")
            widgets.append(self.radiobutton_pro)

            labels_qc = self.labels_qc
            self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.line_selector,
                                                                               self.setQCSelectCallBack, labels_qc, 0,
                                                                               title="Control bottom panel")
            widgets.append(self.radiobutton_pro)

            min = 0
            val = self.order_id

            max = self.ima_sy
            title_slider = "Select order no by clicking with mouse left button"
            self.slider = espdr_discrete_slider.InteractiveSlider2(self.order_selector, self.setOrderSelectCallBack,
                                                                   min, max, val, 1, "order no")

            widgets.append(self.slider)

            return widgets

        def setOrderSelectCallBack(self, order_id):

            self.order_id = int(order_id)
            self.subplot_spectrum.cla()
            self.plotSpectrum()

        def setQCSelectCallBack(self, qc_id):

            self.qc_id = qc_id
            self.subplot_scatter.cla()
            if self.colorbar_check == 1:
                self.colorbar.cla()
            self.plotQC()

        def setImageSelectCallBack(self, product_id):
            self.product_id = product_id

            self.subplot_image.cla()
            self.plotImage()
            self.subplot_spectrum.cla()
            self.plotSpectrum()

        def preparePlotQC(self):
            xLab = 'xLab'
            yLab = 'yLab'
            title = 'title'
            tooltip = 'tooltip'
            x = 'LL'
            if self.qc_id == 'FP cavity size (D) vs wavelength':
                self.plot = 'table'
                y = 'D'
                title = 'FP cavity size vs wavelength'
                xLab = 'wavelength [$\AA$]'
                yLab = 'FP cavity size'

            elif self.qc_id == 'SIG_K vs wavelength':
                self.plot = 'table'
                y = 'SIG_K'
                title = 'sigma of FP cavity size vs wavelength'

                xLab = 'wavelength [$\AA$]'
                yLab = 'sigma of FP cavity size'

            elif self.qc_id == 'Resolution vs wavelength':
                self.plot = 'table'
                y = 'DLLDX'
                title = 'DLLDX vs wavelength'

                xLab = 'wavelength [$\AA$]'
                yLab = 'resolution'

            elif self.qc_id == 'Resolution Trend':
                self.plot = 'table color'
                x = "X0"
                y = "ORDER"
                self.z = "DLLDX"
                title = 'DLLDX vs detector x,y position'

                xLab = 'X'
                yLab = 'Order number'
                # print("case resolution trend")

            elif self.qc_id == 'RMS wavelength solution vs order':
                self.plot = 'scatter'
                x = self.order_nb_a
                y = self.rms_a
                title = 'RMS wavelength solution vs wavelength'

                xLab = 'Order number'
                yLab = 'RMS wavelength solution'

            elif self.qc_id == 'CHI2 vs order':
                self.plot = 'scatter'
                x = self.order_nb_a
                y = self.chi2_a
                title = 'CHI2 wave sol vs wavelength'
                xLab = 'Order number'
                yLab = 'CHI2 wavelength solution'

            self.x = x
            self.y = y

            self.xLab = xLab
            self.yLab = yLab
            self.title = title
            self.tooltip_note = ". Slices 1 and 2 have different relative efficiencies (different optical path in the spectrograph)"
            if 'RMS' in self.qc_id or 'CHI2' in self.qc_id:
                self.tooltip = 'plot of ' + title + self.tooltip_note
            else:
                self.tooltip = 'plot of ' + title

        def prepTitleAndTooltipCommon(self):

            self.tooltip_spectrum = """\
        Plot of the linear-extracted and merged spectrum of the object 
        (blue line) as total flux (ADU) versus wavelength (nm). 
        The  +-1 sigma uncertainties are plotted as upper and lower
        red curves. Note that this spectrum is not flux calibrated.
        """

            self.title_spectrum = 'Linear-extracted and Merged Spectrum.'

        def prepTitleAndTooltipQC(self):
            self.prepTitleAndTooltipCommon()

            if self.product_id == 'AIR_WAVE_MATRIX_LFC_FP_A':
                self.obj = self.wave_matrix_lfc_fp_a
                self.spc = self.wave_matrix_lfc_fp_a

                spec_frame = 'Air Wave Matrix fib B '
                self.tooltip_spectrum = """\
           Extracted spectrum corresponding to the
           wave matrix image
           traced at the order position indicated by the image slicer.
           """

            elif self.product_id == 'AIR_DLL_MATRIX_LFC_FP_A':
                self.obj = self.dll_matrix_lfc_fp_a
                self.spc = self.dll_matrix_lfc_fp_a

                spec_frame = 'Air DLL Matrix fib B '
                self.tooltip_spectrum = """\
           Extracted spectrum corresponding to the
           DLL matrix image
           traced at the order position indicated by the image slicer.
           """

        def prepTitleAndTooltipImage(self):
            self.prepTitleAndTooltipCommon()

            # Image
            spec_frameON = ''
            if self.rec_id == "espdr_wave_LFC":
                if self.fibre_id == 'fib A':
                    spec_frame = 'Arc Lamp fib A '

            # 2D frame PRE format (predict/orderpos/2dmap/wavecal/flexcomp)
            if self.product_id == 'S2D_LFC_FP_A':
                self.obj = self.s2d_lfc_fp_a
                self.spc = self.s2d_lfc_fp_a
                spec_frame = 'Arc Lamp fib A '
                self.tooltip_frameON = """\
           2D Image (wavelength,order) of the overscan and inter order 
           background corrected fibre image illuminated by a Fabry Perot 
           and LFC lamp. 
            """
                self.tooltip_spectrum = """\
           Extracted spectrum corresponding to the
           overscan and inter-order background corrected fibre image
           illuminated by a Fabry Perot and LFC lamp
           traced at the order position indicated by the image slicer.
           """
            elif self.product_id == 'S2D_LFC_FP_B':
                self.obj = self.s2d_lfc_fp_b
                self.spc = self.s2d_lfc_fp_b

                spec_frame = 'Arc Lamp fib B '
                self.tooltip_frameON = """\
           2D Image (wavelength,order) of the overscan and inter order 
           background corrected fibre image illuminated by a Fabry Perot 
           and LFC lamp. 
            """
                self.tooltip_spectrum = """\
           Extracted spectrum corresponding to the
           overscan and inter-order background corrected fibre image
           illuminated by a Fabry Perot and LFC lamp
           traced at the order position indicated by the image slicer.
           """

            elif self.product_id == 'S2D_BLAZE_LFC_FP_A':
                self.obj = self.s2d_blaze_lfc_fp_a
                self.spc = self.s2d_blaze_lfc_fp_a

                spec_frame = 'Arc Lamp fib A '
                self.tooltip_frameON = """\
           2D Image (wavelength,order) of the blaze image of the 
           overscan and inter order 
           background corrected fibre image illuminated by a Fabry Perot 
           and LFC lamp. 
            """
                self.tooltip_spectrum = """\
           Extracted spectrum corresponding to the blaze of the
           overscan and inter-order background corrected fibre image
           illuminated by a Fabry Perot and LFC lamp
           traced at the order position indicated by the image slicer.
           """

            elif self.product_id == 'S2D_BLAZE_LFC_FP_B':
                self.obj = self.s2d_blaze_lfc_fp_b
                self.spc = self.s2d_blaze_lfc_fp_b

                spec_frame = 'Arc Lamp fib B '
                self.tooltip_frameON = """\
           2D Image (wavelength,order) of the blaze image of the 
           overscan and inter order 
           background corrected fibre image illuminated by a Fabry Perot 
           and LFC lamp. 
            """
                self.tooltip_spectrum = """\
           Extracted spectrum corresponding to the blaze of the
           overscan and inter-order background corrected fibre image
           illuminated by a Fabry Perot and LFC lamp
           traced at the order position indicated by the image slicer.
           """

            self.title_frame = spec_frame + 'Image. '
            self.dpm.verify_qc_check(self.subplot_image, self.qc_wave_check, 1.15)

        def plotImage(self):

            self.prepTitleAndTooltipImage()

            sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']
            self.ima_sy = sy

            # print("do wave plot")
            self.dpm.plotImageWave(self.obj, self.lfc_fitted_line_table_lfc_fp_a, 1, 1, self.binx, self.biny, 'X [pix]',
                                   'Order number', 'X0', 'ORDER', self.subplot_image, self.title_frame,
                                   self.tooltip_frameON)

        def plotSpectrum(self):

            self.dpm.plotImageSlice2(self.spc, self.spc, self.order_id, self.subplot_spectrum, self.title_frame,
                                     self.tooltip_spectrum, 'X [pix]', 'ADU')

        def plotQC(self):
            self.prepTitleAndTooltipQC()
            self.preparePlotQC()
            if self.qc_id == 'Resolution Trend':
                self.colorbar = self.figure.add_axes([0.10, 0.215, 0.85, 0.01])
                self.colorbar_check = 1

            if self.plot == 'table':
                self.dpm.plotTableScatter(self.lfc_fitted_line_table_lfc_fp_a, self.x, self.y, self.xLab, self.yLab,
                                          self.subplot_scatter, self.title, self.tooltip)

            elif self.plot == 'table color':
                self.dpm.plotTableColor(self.lfc_fitted_line_table_lfc_fp_a, self.x, self.y, self.z, self.xLab,
                                        self.yLab, self.colorbar, self.subplot_scatter, self.title, self.tooltip)


            else:
                # print(len(self.x), len(self.y))
                self.dpm.scatterPlotScatter3(self.subplot_scatter, self.x, self.y, self.xLab, self.yLab, self.title,
                                             self.tooltip)

        def caseNodata(self):

            # Data not found info
            self.subtext_nodata.set_axis_off()
            self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
            self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c',
                                     fontsize=18, ha='left', va='center', alpha=1.0)
            self.subtext_nodata.tooltip = """\
                                    Merged spectrum not found in the products"""
            # print "found no spectrum data"

        # This is the function that makes the plots.
        # Add new plots or delete them using the given scheme.
        # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
        # It is mandatory to add a tooltip variable to each subplot.
        # One might be tempted to merge addSubplots() and plotProductsGraphics().
        # There is a reason not to do it: addSubplots() is called only once at
        # startup, while plotProductsGraphics() is called always there is a resize.
        def plotProductsGraphics(self):

            self.dpm = espdr_plot_common.DataPlotterManager()

            if (self.s2d_lfc_fp_a_found == True and \
                    self.s2d_lfc_fp_b_found == True):
                self.plotImage()

                self.plotSpectrum()

            if (self.lfc_fitted_line_table_lfc_fp_a_found == True):

                self.plotQC()

            else:
                self.caseNodata()

                # This function specifies which are the parameters that should be presented

        # in the window to be edited.
        # Note that the parameter has to be also in the in_sop port (otherwise it
        # won't appear in the window)
        # The descriptions are used to show a tooltip. They should match one to one
        # with the parameter list
        # Note also that parameters have to be prefixed by the 'recipe name:'

        def setInteractiveParameters(self):
            paramList = list()
            rec_id = self.rec_id
            self.par = espdr_parameters_common.Parameters()
            # self.par.setGeneralCalibParameters(paramList,rec_id)
            if rec_id == "espdr_wave_LFC":
                self.par.setWaveCalTHARParameters(paramList, "espdr_wave_LFC", "all")

            else:
                print("recipe", rec_id, "not supported")

            return paramList

        def setWindowHelp(self):
            help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
            return help_text

        def setWindowTitle(self):
            title = 'ESPRESSO Interactive Workflow: ' + self.rec_subtitle
            return title

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")
    raise

# This is the 'main' function
if __name__ == '__main__':

    # import reflex modules
    from reflex import *
    from reflex_interactive_app import *
    from pipeline_display import *
    from pipeline_product import *

    # Create interactive application
    interactive_app = PipelineInteractiveApp(enable_init_sop=True)

    # PECULIAR XSH needs this in order to be able later to get from an input FITS
    # the ins-mode, arm (and recipe) IDs, used in titles and param setting
    # get inputs from the command line
    interactive_app.parse_args()
    inputs = interactive_app.inputs
    # (inputs, args) = interactive_app.parse_args()

    # Check if import failed or not
    if import_sucess == 'false':
        interactive_app.setEnableGUI(false)

    # interactive_app.setEnableGUI(True)
    # Open the interactive window if enabled
    if interactive_app.isGUIEnabled():
        # Get the specific functions for this window
        dataPlotManager = DataPlotterManager()
        # print inputs.in_sof
        # dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
        # With the following call XSH get the: ins-mode, arm (and recipe) IDs
        dataPlotManager.getArmId(inputs.in_sof)
        # Set recipe ID in order to build proper param list, display layout
        dataPlotManager.setRecId("espdr_wave_LFC")

        interactive_app.setPlotManager(dataPlotManager)
        interactive_app.showGUI()

    else:
        interactive_app.passProductsThrough()

    # Print outputs. This is parsed by the Reflex python actor to get the results
    # Do not remove
    interactive_app.print_outputs()
    sys.exit()
