# AREA A1: the import statements
# import statements needed by esoreflex
import reflex
import sys
from optparse import OptionParser
import json
import os

# Import statements needed by the 
# algorithm to execute
from astropy.io import fits as fits
import numpy as np
from astropy.io.fits import Header


# END OF AREA A1

# AREA A2: the algorithm(s)


def set_hdr1():
    hdr = Header()
    hdr.append(card=('XTENSION', 'IMAGE   ', 'EExtension first keyword (see SIMPLE)'))
    hdr.append(card=('BITPIX', 16, '# oof bits storing pix values'))
    hdr.append(card=('NAXIS', 2, ' n of axes in framen'))
    hdr.append(card=('NAXIS1', 2148, ' n pixels/axis'))
    hdr.append(card=('NAXIS2', 4096, ' n pixels/axis'))
    hdr.append(card=('PCOUNT', 0, ' Number of parameters per group'))
    hdr.append(card=('GCOUNT', 1, ' Number of groups'))
    hdr.append(card=('EXTNAME', 'CCD-44  ', ' Extension name'))
    hdr.append(card=('BZERO', 32768.0, ' pixel=FITS*BSCALE+BZERO'))
    hdr.append(card=('BSCALE', 1.0, ' pixel=FITS*BSCALE+BZERO'))
    hdr.append(card=('ORIGIN', 'ESO     ', ' European Southern Observatory'))
    hdr.append(card=('DATE', '2017-06-09T09:06:36.991', ' UT date when this file was written'))
    hdr.append(card=('EXPTIME', 38.8241, ' Total integration time'))
    hdr.append(card=('MJD-OBS', 57913.37912514, ' MJD start '))
    hdr.append(card=('DATE-OBS', '2017-06-09T09:05:56.412', ' Date of observation'))
    hdr.append(card=('CTYPE1', 'PIXEL   ', ' Pixel coordinate system'))
    hdr.append(card=('CTYPE2', 'PIXEL   ', ' Pixel coordinate system'))
    hdr.append(card=('CRVAL1', 1.0, ' value of ref pixel'))
    hdr.append(card=('CRVAL2', 1.0, ' value of ref pixel'))
    hdr.append(card=('CRPIX1', 51.0, ' Ref. pixel of center of rotation'))
    hdr.append(card=('CRPIX2', 1.0, ' Ref. pixel of center of rotation'))
    hdr.append(card=('CDELT1', 1.0, ' Binning factor'))
    hdr.append(card=('CDELT2', 1.0, ' Binning factor'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 DATE', '2001-11-14', ' Date of installation [YYYY-MM-DD]'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 ID', 'CCD-44  ', ' Detector chip identification'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 INDEX', 1, ' Chip index'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 NAME', 'EEV, EEV', ' Detector chip name'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 NX', 2048, ' # of pixels along X'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 NY', 4096, ' # of pixels along Y'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 PSZX', 15.0, ' Size of pixel in X'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 PSZY', 15.0, ' Size of pixel in Y'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 X', 1, ' X location in array'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 XGAP', 0.000000, ' Gap between chips along x'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 Y', 1, ' Y location in array'))
    hdr.append(card=('HIERARCH ESO DET CHIP1 YGAP', 0.000000, ' Gap between chips along y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 CHIP', 1, ' Chip to which the output belongs'))
    hdr.append(card=('HIERARCH ESO DET OUT1 CONAD', 1.33, ' Conversion from ADUs to electrons'))
    hdr.append(card=('HIERARCH ESO DET OUT1 GAIN', 0.75, ' Conversion from electrons to ADU'))
    hdr.append(card=('HIERARCH ESO DET OUT1 ID', 'R       ', ' Output ID as from manufacturer'))
    hdr.append(card=('HIERARCH ESO DET OUT1 INDEX', 2, ' Output index'))
    hdr.append(card=('HIERARCH ESO DET OUT1 NAME', 'R       ', ' Description of output'))
    hdr.append(card=('HIERARCH ESO DET OUT1 NX', 2048, ' valid pixels along X'))
    hdr.append(card=('HIERARCH ESO DET OUT1 NY', 4096, ' valid pixels along Y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 OVSCX', 50, ' Overscan region in X'))
    hdr.append(card=('HIERARCH ESO DET OUT1 OVSCY', 0, ' Overscan region in Y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 PRSCX', 50, ' Prescan region in X'))
    hdr.append(card=('HIERARCH ESO DET OUT1 PRSCY', 0, ' Prescan region in Y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 RON', 6.08, ' Readout noise per output (e-)'))
    hdr.append(card=('HIERARCH ESO DET OUT1 X', 2048, ' X location of output'))
    hdr.append(card=('HIERARCH ESO DET OUT1 Y', 1, ' Y location of output'))
    hdr.append(card=('INHERIT', 'T', ' denotes the INHERIT keyword convention'))
    hdr.append(card=('CHECKSUM', 'arnRcokOaokOaokO', ' HDU checksum updated 2017-06-09T09:07:02'))
    hdr.append(card=('DATASUM', '1376096828', ' data unit checksum updated 2017-06-09T09:07:02'))
    #          """, sep="\n")

    return hdr


def set_hdr2():
    hdr = Header()
    hdr.append(card=('XTENSION', 'IMAGE   ', ' Extension first keyword (see SIMPLE)'))
    hdr.append(card=('BITPIX', 16, ' n of bits storing pix values'))
    hdr.append(card=('NAXIS', 2, ' n of axes in frame'))
    hdr.append(card=('NAXIS1', 2148, ' n pixels/axis'))
    hdr.append(card=('NAXIS2', 4096, ' n pixels/axis'))
    hdr.append(card=('PCOUNT', 0, ' Number of parameters per group'))
    hdr.append(card=('GCOUNT', 1, ' Number of groups'))
    hdr.append(card=('EXTNAME', 'CCD-44  ', ' Extension name'))
    hdr.append(card=('BZERO', 32768.0, ' pixel=FITS*BSCALE+BZERO'))
    hdr.append(card=('BSCALE', 1.0, ' pixel=FITS*BSCALE+BZERO'))
    hdr.append(card=('ORIGIN', 'ESO     ', ' European Southern Observatory'))
    hdr.append(card=('DATE', '2017-06-09T09:06:36.991', ' UT date when this file was written'))
    hdr.append(card=('EXPTIME', 38.8241, ' Total integration time'))
    hdr.append(card=('MJD-OBS', 57913.37912514, ' MJD start (2017-06-09T09:05:56.412)'))
    hdr.append(card=('DATE-OBS', '2017-06-09T09:05:56.412', ' Date of observation'))
    hdr.append(card=('CTYPE1', 'PIXEL   ', ' Pixel coordinate system'))
    hdr.append(card=('CTYPE2', 'PIXEL   ', ' Pixel coordinate system'))
    hdr.append(card=('CRVAL1', 1.0, ' value of ref pixel'))
    hdr.append(card=('CRVAL2', 1.0, ' value of ref pixel'))
    hdr.append(card=('CRPIX1', -1997.0, ' Ref. pixel of center of rotation'))
    hdr.append(card=('CRPIX2', 1.0, ' Ref. pixel of center of rotation'))
    hdr.append(card=('CDELT1', 1.0, ' Binning factor'))
    hdr.append(card=('CDELT2', 1.0, ' Binning factor'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 DATE', '2001-11-14', ' Date of installation [YYYY-MM-DD]'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 ID', 'CCD-44  ', ' Detector chip identification'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 INDEX', 2, ' Chip index'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 NAME', 'EEV, EEV', ' Detector chip name'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 NX', 2048, ' # of pixels along X'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 NY', 4096, ' # of pixels along Y'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 PSZX', 15.0, ' Size of pixel in X'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 PSZY', 15.0, ' Size of pixel in Y'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 X', 2, ' X location in array'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 XGAP', 0.000000, ' Gap between chips along x'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 Y', 1, ' Y location in array'))
    hdr.append(card=('HIERARCH ESO DET CHIP2 YGAP', 0.000000, ' Gap between chips along y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 CHIP', 2, ' Chip to which the output belongs'))
    hdr.append(card=('HIERARCH ESO DET OUT1 CONAD', 1.36, ' Conversion from ADUs to electrons'))
    hdr.append(card=('HIERARCH ESO DET OUT1 GAIN', 0.74, ' Conversion from electrons to ADU'))
    hdr.append(card=('HIERARCH ESO DET OUT1 ID', 'R       ', ' Output ID as from manufacturer'))
    hdr.append(card=('HIERARCH ESO DET OUT1 INDEX', 2, ' Output index'))
    hdr.append(card=('HIERARCH ESO DET OUT1 NAME', 'R       ', ' Description of output'))
    hdr.append(card=('HIERARCH ESO DET OUT1 NX', 2048, ' valid pixels along X'))
    hdr.append(card=('HIERARCH ESO DET OUT1 NY', 4096, ' valid pixels along Y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 OVSCX', 50, ' Overscan region in X'))
    hdr.append(card=('HIERARCH ESO DET OUT1 OVSCY', 0, ' Overscan region in Y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 PRSCX', 50, ' Prescan region in X'))
    hdr.append(card=('HIERARCH ESO DET OUT1 PRSCY', 0, ' Prescan region in Y'))
    hdr.append(card=('HIERARCH ESO DET OUT1 RON', 7.07, ' Readout noise per output (e-)'))
    hdr.append(card=('HIERARCH ESO DET OUT1 X', 4096, ' X location of output'))
    hdr.append(card=('HIERARCH ESO DET OUT1 Y', 1, ' Y location of output'))
    hdr.append(card=('INHERIT', 'T', ' denotes the INHERIT keyword convention'))
    hdr.append(card=('CHECKSUM', 'SccMVbcLSbcLSbcL', ' HDU checksum updated 2017-06-09T09:07:02'))
    hdr.append(card=('DATASUM', '1996069725', ' data unit checksum updated 2017-06-09T09:07:02'))

    return hdr


def modify_file(d, output_name):
    head = d[0].header
    data = d[0].data
    d1 = data[:, :2148]
    d2 = data[:, 2148:]
    d.close()

    keys_to_modif = ['DATE', 'EXPTIME', 'MJD-OBS', 'DATE-OBS']
    values_to_modif = {i: (head[i], head.comments[i]) for i in keys_to_modif}
    head['NAXIS'] = 0
    # place the EXTEND new keyword after 'NAXIS'
    head.set('EXTEND', True, 'Extension may be present', after='NAXIS')
    # Remove keywords
    head.remove('NAXIS1')
    head.remove('NAXIS2')

    # Modify a frame with the correct format
    hdr1_tmp = set_hdr1()
    hdr2_tmp = set_hdr2()
    hdu0 = fits.PrimaryHDU(header=head)
    hdu1 = fits.ImageHDU(data=d1, header=hdr1_tmp)
    hdu2 = fits.ImageHDU(data=d2, header=hdr2_tmp)
    raw_frame_modif = fits.HDUList([hdu0, hdu1, hdu2])

    for key in keys_to_modif:
        raw_frame_modif[1].header[key] = values_to_modif[key]
        raw_frame_modif[2].header[key] = values_to_modif[key]

    try:
        raw_frame_modif.writeto(output_name, overwrite=True)
    except:
        raw_frame_modif.writeto(output_name, clobber=True)


# END OF AREA A2

# AREA A3: the interface.
# This is the main Phython script. It contains 2 general parts and a
# customized part, that is responsible of calling the desired
# reduction function.

if __name__ == '__main__':

    # ***  PART P1: Input/output ports ***

    # Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("-i", "--in_sof", dest="in_sof")
    parser.add_output("-o", "--out_sof", dest="out_sof")
    # parser.add_input("-k", "--extra_input_port", dest="extra_input_port")
    # parser.add_output("-q", "--extra_output_port", dest="extra_output_port")
    inputs = parser.get_inputs()
    outputs = parser.get_outputs()
    in_sof = inputs.in_sof
    files = in_sof.files
    # in_sof2 = inputs.extra_input_port
    # files2 = in_sof2.files

    # Define the list of outputs
    output_files = list()
    output_datasetname = in_sof.datasetName

    # Get the name of the output directory
    pattern = '--products-dir'
    for arg in sys.argv:
        if arg.split("=")[0] == pattern:
            output_dir = arg.split("=")[1]

    # ***  END OF PART P1 ***

    # ***  PART P2: customized part***

    # THE SCRIPT DOES A LOOP ON THE INPUT FILES AND PROCESS ONLY SPECIFIED CATEGORIES
    # INDIVIDUALLY
    for file in files:
        d = fits.open(file.name)
        head = d[0].header
        if head['NAXIS'] == 2:

            # The output file has the suffix _new
            infile = file.name.rsplit('/', 1)[1]
            output_filename = output_dir + '/' + infile + '_nfmt.fits'

            # This is the call to the reduction function. It can be any script.
            modify_file(d, output_filename)

            # Append the newly produced file to the list of outputs
            output_files.append(reflex.FitsFile(output_filename, file.category, None, file.purposes))

        else:
            # IF FILE IS NOT PROCESSED, IT IS INCLUDED IN THE OUTPUT SOF AS IT IS. IF YOU DO NOT WANT
            # THE FILE TO BE BROADCASTED, COMMENT THE LINE BELOW.
            output_files.append(reflex.FitsFile(file.name, file.category, None, file.purposes))

    # *** END OF PART P2***

    # *** PART P3: broadcast products ***

    # After the script is completed, the list of products is
    # broadcasted to the output sof.
    new_sof = reflex.SetOfFiles(output_datasetname, output_files)
    outputs.out_sof = new_sof
    #  Broadcast outputs on the extra output port, if needed
    # outputs.extra_output_port = new_sof

    # broadcast outputs:
    parser.write_outputs()
    sys.exit()
    # ***  END OF PART P2 ***
    # ***  END OF AREA A3***
