from .hawki_utils import HawkiSetupInfo
from adari_core.data_libs.master_detmon import MasterDetmonReport
from adari_core.plots.text import TextPlot




class HawkiDetlinReport(MasterDetmonReport):
    detectors = {
        "CHIP1.INT1": [1, 1],
        "CHIP2.INT1": [2, 1],
        "CHIP3.INT1": [2, 2],
        "CHIP4.INT1": [1, 2],
    }  # dictionary values indicate typical (x,y) mosaic position
    nominal_gain = {
        "CHIP1.INT1": 1.979,
        "CHIP2.INT1": 2.133,
        "CHIP3.INT1": 1.991,
        "CHIP4.INT1": 2.429,
    }  # from HAWK-I User Manual, Doc. No. VLT-MAN-ESO-14800-3486, Issue 111, Sep 2022
    files_needed = {
        "on": "ON_RAW",
        "off": "OFF_RAW",
        "gain_info": "GAIN_INFO",
        "detlin_info": "DET_LIN_INFO",
        "coeffs_cube": "COEFFS_CUBE",
    }
    center_size = 200

    def __init__(self):
        super().__init__("hawki_detlin", self.files_needed)

    def access_port(self, im_hdu, port):
        return im_hdu

    def generate_panels(self, **kwargs):
        panels = {}

        exts = self.detectors.keys()
        for ext in exts:

            data_info = {}
            data_info["exptime_key"] = "HIERARCH ESO DET DIT"
            data_info["gain_nominal_value"] = self.nominal_gain[ext]
            data_info["lintime_key"] = "DIT"

            new_panels = super().generate_panels(
                data_info=data_info,
                ext=ext,
                port=1,
            )

            for panel, panel_descr in new_panels.items():

                # Metadata
                metadata = HawkiSetupInfo.detlin(list(self.hdus[0].values())[0])
                text2 = TextPlot(v_space=self.METADATA_V_SPACING)
                text2.add_data(metadata)
                panel.assign_plot(text2, 1, 0)

            panels = {**panels, **new_panels}

        return panels


rep = HawkiDetlinReport()
