class HawkiReportMixin(object):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._version = "2.5.15b4"

class HawkiSetupInfo:
    @staticmethod
    def dark(hdul):
        metadata = [
            "DET.NCORRS.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET NCORRS NAME", "N/A")),
            "DET.DIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET DIT", "N/A")),
            "DET.NDIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET NDIT", "N/A")),
            "DET.RSPEED: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET RSPEED", "N/A")),
        ]
        return metadata

    @staticmethod
    def flat(hdul):
        metadata = [
            "DET.NCORRS.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET NCORRS NAME", "N/A")),
            "DET.DIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET DIT", "N/A")),
            "DET.NDIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET NDIT", "N/A")),
            "DET.RSPEED: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET RSPEED", "N/A")),
            "INS.FILT1.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS FILT1 NAME", "N/A")),
            "INS.FILT2.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS FILT2 NAME", "N/A")),
        ]
        return metadata

    @staticmethod
    def std(hdul):
        metadata = [
            "DET.NCORRS.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET NCORRS NAME", "N/A")),
            "DET.DIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET DIT", "N/A")),
            "DET.NDIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET NDIT", "N/A")),
            "DET.RSPEED: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET RSPEED", "N/A")),
            "INS.MODE: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS MODE", "N/A")),
            "INS.FILT1.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS FILT1 NAME", "N/A")),
            "INS.FILT2.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS FILT2 NAME", "N/A")),
            "OBS.TARG.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO OBS TARG NAME", "N/A")),
        ]
        return metadata

    @staticmethod
    def detlin(hdul):
        metadata = [
            "DET.RSPEED: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET RSPEED", "N/A")),
        ]
        return metadata
