from edps import classification_rule

from . import hawki_keywords as kwd
from . import hawki_rules as rules

# --- Dictionaries containing the values of header keywords that define calibrations and science
hawki = {kwd.instrume: "HAWKI"}
calib_image = {**hawki, kwd.dpr_catg: "CALIB", kwd.dpr_tech: "IMAGE"}
science_image = {**hawki, kwd.dpr_catg: "SCIENCE", kwd.dpr_tech: "IMAGE"}
science_image_hit = {
    **hawki,
    kwd.dpr_catg: "SCIENCE",
    kwd.dpr_tech: ["IMAGE,HIT", "IMAGE,BURST"],
    kwd.det_ncorrs_name: "DoubleRdRstRd",
}

# --- CLASSIFICATION RULES ---------------------------------------------------------------------------------------------
# Raw data
dark_class = classification_rule("DARK", rules.is_dark)
dark_windowed_class = classification_rule("DARK_WINDOWED", rules.is_dark_windowed)
detnoise_dark_class = classification_rule("DARK", rules.is_detnoise_dark)
detnoise_flat_class = classification_rule("FLAT_TWILIGHT", rules.is_detnoise_flat)
sky_flat_class = classification_rule("FLAT_TWILIGHT", rules.is_sky_flat)
sky_flat_windowed_class = classification_rule(
    "FLAT_WINDOWED", rules.is_sky_flat_windowed
)

standard_class = classification_rule("STD", {**calib_image, kwd.dpr_type: "STD"})
off_raw_class = classification_rule("OFF_RAW", rules.is_off_raw)
on_raw_class = classification_rule("ON_RAW", rules.is_on_raw)
object_class = classification_rule("OBJECT", {**science_image, kwd.dpr_type: "OBJECT"})
sky_class = classification_rule("SKY", {**science_image, kwd.dpr_type: "SKY"})
object_hit_class = classification_rule(
    "OBJECT", {**science_image_hit, kwd.dpr_type: "OBJECT"}
)

#   Static calibrations
master_readgain_class = classification_rule(
    "MASTER_READGAIN", {**hawki, kwd.pro_catg: "MASTER_READGAIN"}
)
photcal_tab_class = classification_rule(
    "PHOTCAL_TAB", {**hawki, kwd.pro_catg: "PHOTCAL_TAB"}
)
schlegel_map_south_class = classification_rule(
    "SCHLEGEL_MAP_SOUTH", {**hawki, kwd.pro_catg: "SCHLEGEL_MAP_SOUTH"}
)
schlegel_map_north_class = classification_rule(
    "SCHLEGEL_MAP_NORTH", {**hawki, kwd.pro_catg: "SCHLEGEL_MAP_NORTH"}
)
reference_dark_class = classification_rule(
    "REFERENCE_DARK", {**hawki, kwd.pro_catg: "REFERENCE_DARK"}
)
reference_flat_class = classification_rule(
    "REFERENCE_TWILIGHT_FLAT", {**hawki, kwd.pro_catg: "REFERENCE_TWILIGHT_FLAT"}
)
photom_2mass_class = classification_rule("MASTER_2MASS_CATALOGUE_PHOTOM")
astrom_2mass_class = classification_rule("MASTER_2MASS_CATALOGUE_ASTROM")
photom_ppmxl_class = classification_rule("MASTER_PPMXL_CATALOGUE_PHOTOM")
astrom_ppmxl_class = classification_rule("MASTER_PPMXL_CATALOGUE_ASTROM")
photom_custom_class = classification_rule("MASTER_LOCAL_CATALOGUE_PHOTOM")
astrom_custom_class = classification_rule("MASTER_LOCAL_CATALOGUE_ASTROM")
distortion_class = classification_rule(
    "DISTORTION", {**hawki, kwd.pro_catg: "DISTORTION"}
)
distortion_class_x = classification_rule(
    "DISTORTION_X", {**hawki, kwd.pro_catg: "DISTORTION_X"}
)
distortion_class_y = classification_rule(
    "DISTORTION_Y", {**hawki, kwd.pro_catg: "DISTORTION_Y"}
)
standar_star_catalogue_class = classification_rule(
    "STDSTARS_CATS", {**hawki, kwd.pro_catg: "STDSTARS_CATS"}
)

# MASTER calibrations
MASTER_DARK = classification_rule("MASTER_DARK", {**hawki, kwd.pro_catg: "MASTER_DARK"})
MASTER_BPM = classification_rule("MASTER_BPM", {**hawki, kwd.pro_catg: "MASTER_BPM"})
MASTER_CONF = classification_rule("MASTER_CONF", {**hawki, kwd.pro_catg: "MASTER_CONF"})
HIT_MASTER_DARK = classification_rule(
    "HIT_MASTER_DARK", {**hawki, kwd.pro_catg: "HIT_MASTER_DARK"}
)
MASTER_FLAT = classification_rule(
    "MASTER_TWILIGHT_FLAT", {**hawki, kwd.pro_catg: "MASTER_TWILIGHT_FLAT"}
)
HIT_MASTER_TWILIGHT_FLAT = classification_rule(
    "HIT_MASTER_TWILIGHT_FLAT", {**hawki, kwd.pro_catg: "HIT_MASTER_TWILIGHT_FLAT"}
)
MASTER_READGAIN = classification_rule(
    "MASTER_READGAIN", {**hawki, kwd.pro_catg: "MASTER_READGAIN"}
)
MATCHSTD_PHOTOM = classification_rule(
    "MATCHSTD_PHOTOM", {**hawki, kwd.pro_catg: "MATCHSTD_PHOTOM"}
)
BASIC_VAR_MAP = classification_rule(
    "BASIC_VAR_MAP", {**hawki, kwd.pro_catg: "BASIC_VAR_MAP"}
)
BASIC_CALIBRATED_STD = classification_rule(
    "BASIC_CALIBRATED_STD", {**hawki, kwd.pro_catg: "BASIC_CALIBRATED_STD"}
)
BASIC_CAT_STD = classification_rule(
    "BASIC_CAT_STD", {**hawki, kwd.pro_catg: "BASIC_CAT_STD"}
)
MATCHSTD_ASTROM = classification_rule(
    "MATCHSTD_ASTROM", {**hawki, kwd.pro_catg: "MATCHSTD_ASTROM"}
)
