from edps import (
    ONE_DAY, TWO_WEEKS, THREE_WEEKS, ONE_MONTH, IN_THE_PAST, UNLIMITED,
    data_source, match_rules
)

from .hawki_classification import *

# Convention for Data sources Association rule levels:
# Each data source can have several match function which correspond to different
# quality levels for the selected data. The level is specified as a number that
# follows this convention:
#   level < 0: more restrictive than the calibration plan
#   level = 0 follows the calibration plan
#   level = 1 quality sufficient for QC1 certification
#   level = 2 probably still acceptable quality
#   level = 3 significant risk of bad quality results


dit_ndits = [kwd.det_dit, kwd.det_ndit]
filters = [kwd.ins_filt1_name, kwd.ins_filt2_name]
setup = dit_ndits + [kwd.det_ncorrs_name, kwd.det_rspeed]
setup_and_filters = setup + filters
setup_standards = dit_ndits + filters + [kwd.det_ncorrs_name, kwd.ins_mode, kwd.obs_targ_name]
match_standards = [kwd.det_ncorrs_name, kwd.det_rspeed] + filters
assoc_dark = [kwd.instrume, kwd.det_dit, kwd.det_rspeed]
assoc_flat = filters + [kwd.det_ncorrs_name, kwd.det_rspeed]
assoc_reference_dark = dit_ndits + [kwd.det_ncorrs_name]
assoc_reference_flat = filters + [kwd.det_ncorrs_name]

window_setup = [kwd.det_nx, kwd.det_ny, kwd.det_startx, kwd.det_startx1, kwd.det_starty, kwd.det_starty1,
                kwd.det_win_type]

# Raw exposures
raw_detlin = (data_source()
              .with_classification_rule(off_raw_class)
              .with_classification_rule(on_raw_class)
              .with_setup_keywords([kwd.det_rspeed])
              .with_grouping_keywords([kwd.det_rspeed, kwd.tpl_start])
              .build())

raw_dark = (data_source()
            .with_classification_rule(dark_class)
            .with_classification_rule(detnoise_dark_class)
            .with_setup_keywords(setup)
            .with_grouping_keywords(setup_and_filters + [kwd.obs_start])
            .with_min_group_size(3)
            .with_match_keywords(assoc_dark, time_range=ONE_DAY, level=0)
            .with_match_keywords(assoc_dark, time_range=ONE_MONTH, level=2)
            .with_match_keywords(assoc_dark, time_range=UNLIMITED, level=3)
            .build())

raw_dark_windowed = (data_source()
                     .with_classification_rule(dark_windowed_class)
                     .with_setup_keywords(setup + window_setup)
                     .with_grouping_keywords(setup + window_setup + [kwd.tpl_start])
                     .with_match_keywords(assoc_dark, time_range=ONE_DAY, level=0)
                     .with_match_keywords(assoc_dark, time_range=ONE_MONTH, level=2)
                     .with_match_keywords(assoc_dark, time_range=UNLIMITED, level=3)
                     .build())

match_dark_win_for_science = (match_rules()
                              .with_match_keywords(assoc_dark + window_setup, time_range=ONE_DAY, level=0)
                              .with_match_keywords(assoc_dark + window_setup, time_range=ONE_MONTH, level=2)
                              .with_match_keywords(assoc_dark + window_setup, time_range=UNLIMITED, level=3))

detnoise_dark = (data_source()
                 .with_classification_rule(detnoise_dark_class)
                 .with_grouping_keywords([kwd.arcfile])
                 .with_match_keywords([kwd.instrume], time_range=ONE_DAY, level=0)
                 .with_match_keywords([kwd.instrume], time_range=ONE_MONTH, level=2)
                 .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
                 .build())

raw_flat = (data_source()
            .with_classification_rule(sky_flat_class)
            .with_grouping_keywords(setup_and_filters + [kwd.obs_start])
            .with_min_group_size(10)
            .with_setup_keywords(setup_and_filters)
            .with_match_keywords(assoc_flat, time_range=ONE_DAY, level=-1)
            .with_match_keywords(assoc_flat, time_range=THREE_WEEKS, level=0)
            .with_match_keywords(assoc_flat, time_range=ONE_MONTH, level=2)
            .with_match_keywords(assoc_flat, time_range=UNLIMITED, level=3)
            .build())

raw_flat_windowed = (data_source()
                     .with_classification_rule(sky_flat_windowed_class)
                     .with_setup_keywords(setup_and_filters)
                     .with_grouping_keywords(setup_and_filters + [kwd.tpl_start])
                     .with_match_keywords(assoc_flat, time_range=THREE_WEEKS, level=0)
                     .with_match_keywords(assoc_flat, time_range=ONE_MONTH, level=2)
                     .with_match_keywords(assoc_flat, time_range=UNLIMITED, level=3)
                     .build())

detnoise_flat = (data_source()
                 .with_classification_rule(detnoise_flat_class)
                 .with_grouping_keywords([kwd.arcfile])
                 .with_match_function(rules.is_assoc_flat_notsame)
                 .build())

raw_standard = (data_source()
                .with_classification_rule(standard_class)
                .with_min_group_size(4)
                .with_grouping_keywords(setup_standards + [kwd.obs_start])
                .with_setup_keywords(setup_standards)
                .with_match_keywords(match_standards, time_range=TWO_WEEKS, level=0)
                .with_match_keywords(match_standards, time_range=UNLIMITED, level=3)
                .build())

raw_sky = (data_source()
           .with_classification_rule(sky_class)
           .with_grouping_keywords(setup_and_filters + [kwd.ins_mode, kwd.tpl_start])
           .with_match_keywords(setup_and_filters + [kwd.ins_mode, kwd.tpl_start], level=0)
           .build())

raw_science = (data_source()
               .with_classification_rule(object_class)
               .with_grouping_keywords(setup_and_filters + [kwd.ins_mode, kwd.tpl_start])
               .with_setup_keywords(setup_and_filters)
               .build())

raw_science_hit = (data_source()
                   .with_classification_rule(object_hit_class)
                   .with_grouping_keywords(setup_and_filters + [kwd.ins_mode, kwd.tpl_start])
                   .with_setup_keywords(setup_and_filters)
                   .build())

# Reference data
reference_dark = (data_source()
                  .with_classification_rule(reference_dark_class)
                  .with_match_keywords(assoc_reference_flat, time_range=THREE_WEEKS, level=0)
                  .with_match_keywords(assoc_reference_dark, time_range=ONE_MONTH, level=2)
                  .with_match_keywords(assoc_reference_dark, time_range=UNLIMITED, level=3)
                  .build())

reference_flat = (data_source()
                  .with_classification_rule(reference_flat_class)
                  .with_match_keywords(assoc_reference_flat, time_range=THREE_WEEKS, level=0)
                  .with_match_keywords(assoc_reference_flat, time_range=ONE_MONTH, level=2)
                  .with_match_keywords(assoc_reference_flat, time_range=UNLIMITED, level=3)
                  .build())

# Static calibrations
schlegel_map_south = (data_source()
                      .with_classification_rule(schlegel_map_south_class)
                      .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                      .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
                      .build())

schlegel_map_north = (data_source()
                      .with_classification_rule(schlegel_map_north_class)
                      .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                      .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
                      .build())

astrom_2mass = (data_source()
                .with_classification_rule(astrom_2mass_class)
                .with_match_function(rules.is_true)
                .build())

astrom_ppmxl = (data_source()
                .with_classification_rule(astrom_ppmxl_class)
                .with_match_function(rules.is_true)
                .build())

astrom_custom = (data_source()
                 .with_classification_rule(astrom_custom_class)
                 .with_match_function(rules.is_true)
                 .build())

photom_2mass = (data_source()
                .with_classification_rule(photom_2mass_class)
                .with_match_function(rules.is_true)
                .build())

photom_ppmxl = (data_source()
                .with_classification_rule(photom_ppmxl_class)
                .with_match_function(rules.is_true)
                .build())

photom_custom = (data_source()
                 .with_classification_rule(photom_custom_class)
                 .with_match_function(rules.is_true)
                 .build())

photcal_tab = (data_source()
               .with_classification_rule(photcal_tab_class)
               .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
               .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
               .build())

# Master calibrations
master_bpm = (data_source()
              .with_classification_rule(MASTER_BPM)
              .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
              .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
              .build())

master_conf = (data_source()
               .with_classification_rule(MASTER_CONF)
               .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
               .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
               .build())

master_readgain = (data_source()
                   .with_classification_rule(master_readgain_class)
                   .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                   .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=3)
                   .build())
