from edps import task, QC0, QC1_CALIB, CALCHECKER, subworkflow

from .hawki_datasources import *
from .hawki_task_functions import catalogs, which_band


@subworkflow("hawki_hit", "")
def hawki_hit(flat, astrometric_catalogs, photometric_catalogs):
    dark_windowed = (task('dark_windowed')
                     .with_main_input(raw_dark_windowed)
                     .with_meta_targets([QC1_CALIB])
                     .build())

    flat_windowed = (task('flat_windowed')
                     .with_main_input(raw_flat_windowed)
                     .with_associated_input(dark_windowed, [HIT_MASTER_DARK])
                     .with_meta_targets([QC1_CALIB])
                     .build())

    science_hit = (task('object_hit')
                   .with_main_input(raw_science_hit)
                   .with_job_processing(catalogs)
                   .with_dynamic_parameter("which_band", which_band)
                   .with_associated_input(flat, [MASTER_FLAT, MASTER_CONF])
                   .with_associated_input(dark_windowed, [HIT_MASTER_DARK], match_rules=match_dark_win_for_science)
                   .with_associated_input(flat_windowed, [HIT_MASTER_TWILIGHT_FLAT], min_ret=0)
                   .with_associated_input(master_readgain)
                   .with_alternatives(astrometric_catalogs)
                   .with_alternatives(photometric_catalogs)
                   .with_associated_input(schlegel_map_north)
                   .with_associated_input(schlegel_map_south)
                   .with_associated_input(photcal_tab)
                   .with_meta_targets([QC0, CALCHECKER])
                   .build())

    return dark_windowed, flat_windowed, science_hit
