# IIINSTRUMENT_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([IIINSTRUMENT_SET_VERSION_INFO],
[
    iiinstrument_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    iiinstrument_major_version=`echo "$iiinstrument_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    iiinstrument_minor_version=`echo "$iiinstrument_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    iiinstrument_micro_version=`echo "$iiinstrument_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$iiinstrument_major_version"; then iiinstrument_major_version=0
    fi

    if test -z "$iiinstrument_minor_version"; then iiinstrument_minor_version=0
    fi

    if test -z "$iiinstrument_micro_version"; then iiinstrument_micro_version=0
    fi

    IIINSTRUMENT_VERSION="$iiinstrument_version"
    IIINSTRUMENT_MAJOR_VERSION=$iiinstrument_major_version
    IIINSTRUMENT_MINOR_VERSION=$iiinstrument_minor_version
    IIINSTRUMENT_MICRO_VERSION=$iiinstrument_micro_version

    if test -z "$4"; then IIINSTRUMENT_INTERFACE_AGE=0
    else IIINSTRUMENT_INTERFACE_AGE="$4"
    fi

    IIINSTRUMENT_BINARY_AGE=`expr 100 '*' $IIINSTRUMENT_MINOR_VERSION + $IIINSTRUMENT_MICRO_VERSION`
    IIINSTRUMENT_BINARY_VERSION=`expr 10000 '*' $IIINSTRUMENT_MAJOR_VERSION + \
                          $IIINSTRUMENT_BINARY_AGE`

    AC_SUBST(IIINSTRUMENT_VERSION)
    AC_SUBST(IIINSTRUMENT_MAJOR_VERSION)
    AC_SUBST(IIINSTRUMENT_MINOR_VERSION)
    AC_SUBST(IIINSTRUMENT_MICRO_VERSION)
    AC_SUBST(IIINSTRUMENT_INTERFACE_AGE)
    AC_SUBST(IIINSTRUMENT_BINARY_VERSION)
    AC_SUBST(IIINSTRUMENT_BINARY_AGE)

    AC_DEFINE_UNQUOTED(IIINSTRUMENT_MAJOR_VERSION, $IIINSTRUMENT_MAJOR_VERSION,
                       [IIINSTRUMENT major version number])
    AC_DEFINE_UNQUOTED(IIINSTRUMENT_MINOR_VERSION, $IIINSTRUMENT_MINOR_VERSION,
                       [IIINSTRUMENT minor version number])
    AC_DEFINE_UNQUOTED(IIINSTRUMENT_MICRO_VERSION, $IIINSTRUMENT_MICRO_VERSION,
                       [IIINSTRUMENT micro version number])
    AC_DEFINE_UNQUOTED(IIINSTRUMENT_INTERFACE_AGE, $IIINSTRUMENT_INTERFACE_AGE,
                       [IIINSTRUMENT interface age])
    AC_DEFINE_UNQUOTED(IIINSTRUMENT_BINARY_VERSION, $IIINSTRUMENT_BINARY_VERSION,
                       [IIINSTRUMENT binary version number])
    AC_DEFINE_UNQUOTED(IIINSTRUMENT_BINARY_AGE, $IIINSTRUMENT_BINARY_AGE,
                       [IIINSTRUMENT binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# IIINSTRUMENT_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([IIINSTRUMENT_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/${PACKAGE}'
    fi

    if test -z "$reportsdir"; then
       reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(workflowdir)
    AC_SUBST(reportsdir)


])


# IIINSTRUMENT_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([IIINSTRUMENT_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    IIINSTRUMENT_INCLUDES='-I$(top_srcdir)/iiinstrument -I$(top_srcdir)/irplib'
    IIINSTRUMENT_LDFLAGS='-L$(top_builddir)/iiinstrument'

    # Library aliases

    LIBIIINSTRUMENT='$(top_builddir)/iiinstrument/libiiinstrument.la'
    LIBIRPLIB='$(top_builddir)/irplib/libirplib.la'

    # Substitute the defined symbols

    AC_SUBST(IIINSTRUMENT_INCLUDES)
    AC_SUBST(IIINSTRUMENT_LDFLAGS)

    AC_SUBST(LIBIIINSTRUMENT)
    AC_SUBST(LIBIRPLIB)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(IIINSTRUMENT_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES) $(XXCLIPM_INCLUDES)'
    all_ldflags='$(IIINSTRUMENT_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS) $(XXCLIPM_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
