/*
 * This file is part of the IIINSTRUMENT Pipeline
 * Copyright (C) 2002-2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef IIINSTRUMENT_DFS_H
#define IIINSTRUMENT_DFS_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>


/*----------------------------------------------------------------------------*/
/**
 *                              Defines
 */
/*----------------------------------------------------------------------------*/

/* Define here the RAW   tag keywords */
#define RRRECIPE_RAW                    "RRRECIPE_DOCATG_RAW"

/* Define here the CALIB tag keywords */
#define RRRECIPE_CALIB_RAW              "RRRECIPE_CALIB_DOCATG_RAW"
#define IIINSTRUMENT_CALIB_FLAT         "FLAT"

/* Define here the static calibration tag keywords */
#define LINE_INTMON_TABLE               "LINE_INTMON_TABLE"

/* Define here the OUT   tag keywords */
#define RRRECIPE_OUT_PROCATG            "RRRECIPE_DOCATG_RESULT"
#define RRRECIPE_OUT_CALIB_PROCATG      "RRRECIPE_DOCATG_CALIB_RESULT"
#define RRRECIPE_OUT_POSTPROC_PROCATG      "RRRECIPE_DOCATG_POSTPROC_RESULT"

/*----------------------------------------------------------------------------*/
/**
 *                              Functions prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code iiinstrument_dfs_set_groups(cpl_frameset *);

#endif
