from adari_core.data_libs.master_rawdisp import MasterRawdispReport
import os
import numpy as np
from .iiinstrument_util import IiinstrumentSetupInfo


class IiinstrumentRawdispReport(MasterRawdispReport):
    raw_extensions = {
        "PRIMARY": "blue",
        "CCD-20": "redu",
        "CCD-44": "redl",
        # Special case for red 2x3 binning
        "WIN1": "2x3bin1",
        "WIN2": "2x3bin2",
    }

    def __init__(self):
        super().__init__("uves_rawdisp")
        self.extensions = []
        self.tasks = {
            "RRRECIPE_CALIB_DOCATG_RAW": "rrrecipe_calib",
        }
        self.setup_info = IiinstrumentSetupInfo

    def parse_sof(self):
        # we building multiple report sets, so we append multiple reports to file_lists
        # get a list of tags
        tags = list(self.tasks.keys())
        added = {}
        file_lists = []
        for filename, catg in self.inputs:
            if catg in tags:
                if filename is not None and catg not in added:
                    file_lists.append({"filename": filename})
                    added[catg] = self.tasks[catg]
                    self.sof_tag.append(catg)
        print ("FILE")
        print (file_lists)
        self.extensions = ["PRIMARY"]
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        new_panels = super().generate_panels(ext=self.extensions)
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # Alter the cut pos, or remove CutPlot(s) completely,
            # depending on task name
            try:
                task_name = panel_descr["task_name"]
            except KeyError:
                raise RuntimeError(
                    "A report has been created by "
                    "MasterRawdispReport that did "
                    "not come back with a task name "
                    "attached!"
                )
            panel_descr["report_name"] = "iiinstrument_rawdisp_{}_{}".format(
                task_name,
                self.sof_tag[i].lower(),
            )
            panel_descr["report_description"] = (
                f"IIINSTRUMENT rawdisp panel - "
                f"{panel_descr['task_name']}, "
                f"{panel_descr['tag']}, "
                f"{os.path.basename(panel_descr['filename'])}, "
                f"{panel_descr['ext']}"
            )
        panels = {**panels, **new_panels}

        return panels


rep = IiinstrumentRawdispReport()
