from edps.generator.task_builder import data_source

from .iiinstrument_classification import *
from .iiinstrument_rules import *

group_by = [kwd.filt_name, kwd.obs_id, kwd.obs_name, kwd.targ_name, kwd.tpl_start]

# Data sources
rrrecipe_docatg_raw = (data_source()
                       .with_classification_rule(rrrecipe_docatg_raw_class)
                       .with_grouping_keywords(group_by)
                       .with_match_function(is_assoc)
                       .build())

rrrecipe_calib_docatg_raw = (data_source()
                             .with_classification_rule(rrrecipe_calib_docatg_raw_class)
                             .with_grouping_keywords(group_by)
                             .with_match_function(is_assoc)
                             .build())

line_intmon_table = (data_source()
                     .with_classification_rule(line_intmon_table_class)
                     .with_match_function(is_assoc)
                     .build())
