from edps.generator.task_builder import task
from edps import qc1calib, science, qc0

from .iiinstrument_datasources import *

# Tasks
calib_img = (task('calib_img')
             .with_recipe('rrrecipe_calib')
             .with_main_input(rrrecipe_calib_docatg_raw)
             .with_meta_targets([qc1calib])
             .build())

combine_img = (task('combine_img')
               .with_recipe('rrrecipe')
               .with_main_input(rrrecipe_docatg_raw)
               .with_associated_input(calib_img, [img_calibrated])
               .with_associated_input(line_intmon_table)
               .with_meta_targets([qc0, science])
               .build())
