from edps import subworkflow, task, QC1_CALIB, CALCHECKER, ReportInput, alternative_association

from .kmos_datasources import *
from .kmos_task_functions import use_sky_flats, use_lamp_flats


# This subworkflow generates the illumination correction
@subworkflow("illumination", "")
def select_illumination(dark, lamp_flat, wavelength):
    # --- Process sky flats for illumination correction

    match_darks_for_skyflats = (match_rules()
                                .with_match_function(rules.is_assoc_dark, time_range=RelativeTimeRange(-7.5, 7.5),
                                                     level=0)
                                .with_match_function(rules.is_assoc_dark, time_range=TWO_WEEKS, level=1)
                                .with_match_function(rules.is_assoc_dark, time_range=UNLIMITED, level=3))

    sky_flat = (task('sky_flat')
                .with_recipe('kmos_illumination')
                .with_report('kmos_rawdisp', ReportInput.RECIPE_INPUTS, driver='png')
                .with_report('kmos_sky_flat', ReportInput.RECIPE_INPUTS_OUTPUTS, driver='png')
                .with_main_input(raw_flat_sky)
                .with_associated_input(dark, [MASTER_DARK], match_rules=match_darks_for_skyflats)
                .with_associated_input(static_wave_band)
                .with_associated_input(lamp_flat, [XCAL, YCAL, MASTER_FLAT])
                .with_associated_input(wavelength, [LCAL])
                .with_input_filter(MASTER_DARK, LCAL, XCAL, YCAL, MASTER_FLAT, wave_band_class)
                .with_meta_targets([QC1_CALIB, CALCHECKER])
                .build())

    # --- Process lamp flats for illumination correction
    illumination = (task('illumination')
                    .with_recipe('kmos_illumination')
                    .with_report('kmos_illumination', ReportInput.RECIPE_INPUTS_OUTPUTS, driver='png')
                    .with_main_input(raw_flat_on)
                    .with_associated_input(static_wave_band)
                    .with_associated_input(wavelength, [LCAL])
                    .with_associated_input(lamp_flat, [XCAL, YCAL])
                    .with_input_filter(LCAL, XCAL, YCAL, wave_band_class)
                    .with_meta_targets([QC1_CALIB])
                    .build())

    # The illumination correction to be used (sky flats or lamp flats) depends on
    # the desired data reduction strategy.
    # The strategy is determined by the parameter "use_sky_flats" in the parameter file.
    # "use_sky_flats": "true". Uses the twilight sky flats for illumination correction.
    # "use_sky_flats": "false". Uses the lamp flats for illumination correction.
    illumination_correction = (alternative_association()
                               .with_associated_input(sky_flat, [ILLUM_CORR], min_ret=0, max_ret=1,
                                                      condition=use_sky_flats)
                               .with_associated_input(illumination, [ILLUM_CORR], min_ret=0, max_ret=1,
                                                      condition=use_lamp_flats))

    return illumination_correction, sky_flat, illumination
