# ----  CLASSIFICATION RULES -----------------------------------------------------------------------
from . import kmos_keywords as kwd


def is_kmos(f):
    return f[kwd.instrume] == "KMOS"


def is_single_cubes(f):
    return is_kmos(f) and f[kwd.pro_catg] in ("SCI_RECONSTRUCTED", "SINGLE_CUBES") and f[kwd.tpl_id] != "KMOS_spec_acq"


# ---- ASSOCIATION RULES -----------------------------------------------------------------------
# f=file to associate (e.g. calibration) ref=trigger (e.g. science)


def is_assoc_dark(ref, f):
    return 30.0 <= f[kwd.dit1] <= 100.0


def is_assoc_std_cal(ref, f):
    return ref[kwd.grat1_id] == f[kwd.grat1_id] and abs(f[kwd.airmass] - ref[kwd.airmass]) <= 0.2


def is_assoc(ref, f):
    return True


def is_assoc_filt(ref, f):
    return ref[kwd.grat1_id] == f[kwd.filt_id]
