from edps import JobParameters, get_parameter, Job


########################################################################################################################
###         Functions that define conditions depending on the values of the the workflow parameters                  ###
########################################################################################################################


def not_qc0_not_molecfit(params: JobParameters):
    return get_parameter(params, 'qc0') == 'false' and get_parameter(params, "molecfit") == 'false'


def not_qc0_molecfit(params: JobParameters):
    return get_parameter(params, 'qc0') == 'false' and get_parameter(params, "molecfit") != 'false'


def is_qc0(params: JobParameters):
    return get_parameter(params, 'qc0') == 'true'


def use_lamp_flats(params: JobParameters):
    return get_parameter(params, 'use_sky_flats') == 'false'


def use_sky_flats(params: JobParameters):
    return get_parameter(params, 'use_sky_flats') == 'true'


def use_telluric_standard(params: JobParameters):
    return get_parameter(params, 'molecfit') == 'false'


def use_molecfit(params: JobParameters):
    return get_parameter(params, 'molecfit') != 'false'


def molecfit_on_standard(params: JobParameters):
    return get_parameter(params, 'molecfit') == 'standard'


def molecfit_on_science(params: JobParameters):
    return get_parameter(params, 'molecfit') == 'science'


# Function to set recipe parameters according to workflow parameter configuration
def set_combination_parameters(job: Job):
    ifus = job.parameters.get_workflow_param('ifus')  # 'all'
    target_name = job.parameters.get_workflow_param('target_name')  # 'all'
    offset_filename = job.parameters.get_workflow_param('offset_filename')  # 'auto'

    if ifus != 'all':
        job.parameters.recipe_parameters['kmos.kmos_combine.ifus'] = ifus
    if target_name != 'all':
        job.parameters.recipe_parameters['kmos.kmos_combine.name'] = target_name
    if offset_filename != 'auto':
        job.parameters.recipe_parameters['kmos.kmos_combine.filename'] = offset_filename


def set_reduction_parameters(job: Job):
    object_sky_association = job.parameters.get_workflow_param('object_sky_association')  # 'auto'
    if object_sky_association != 'auto':
        job.parameters.recipe_parameters['kmos.kmos_sci_red.obj_sky_table'] = object_sky_association
