/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_CONFIG_CALC_H
#define MF_WRAP_CONFIG_CALC_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

//#include <telluriccorr.h>
/*#include <mf_wrap_fits.h>
#include <mf_wrap_data.h>
#include <mf_wrap_dfs.h>*/

#include <mf_wrap_utils.h>
#include <mf_wrap_config.h>
#include <mf_calctrans.h>
//#include <telluriccorr.h>
//#include "mf_calctrans_lblrtm_results.h"

//#include "mf_constants.h" //?
//#include "mf_configuration.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

typedef struct {

  cpl_boolean                      use_only_input_pri_ext;       /* If the user want to use only the  SCIENCE_CALCTRANS/SCIENCE input FITS primary extension                                    */
  int                              dflux_extension_data;         /* If use_only_input_pri_ext == CPL_TRUE, you can provide a extension as DFLUX (error flux)                                    */
  int                              mask_extension_data;          /* If use_only_input_pri_ext == CPL_TRUE, you can provide a extension as MASK                                                  */

  cpl_boolean                      use_input_kernel;             /* If the user provided, use or not the user kernel                                                                            */

  const char                       *mapping_kernel;              /* Mapping extensions : SCIENCE-CALCTRANS_KERNEL_LIBRARY; i.e. {Science_ext1-Kernel_lib_ext, ..., Science_extN-Kernel_lib_ext} */
  cpl_table                        *mapping_kernel_table;        /* Mapping kernel extensions cpl_table. Contains 1 columns [KERNEL_LIBRARY_EXT]                                                */

  const char                       *mapping_atmospheric;         /* Mapping extensions : SCIENCE-ATM_PARAMETERS, i.e. {Science_ext1-Lblrtm_results_ext, ..., Science_extN-Lblrtm_results_ext}   */
  cpl_table                        *mapping_atmospheric_table;   /* Mapping lblrtm_results extensions cpl_table. Contains 1 columns [LBLRTM_RESULTS_EXT]                                        */

  const char                       *mapping_convolve;            /* Mapping extensions : SCIENCE-LBLRTM_RESULTS, i.e. {Science_ext1-Lblrtm_results_ext, ..., Science_extN-Lblrtm_results_ext}   */
  cpl_table                        *mapping_convolve_table;      /* Mapping lblrtm_results extensions cpl_table. Contains 1 columns [LBLRTM_RESULTS_EXT]                                        */

  /* Calibration */
  mf_wrap_fits                    *atm_parameters;              /* cpl_table's in the ATM_PARAMETERS      (output of molecfit_model)                                                           */
  mf_wrap_fits                    *best_fit_parameters;         /* cpl_table's in the BEST_FIT_PARAMETERS (output of molecfit_model)                                                           */

  /* Science */
  cpl_size                         n_ext;                        /* Number of extensions                                                                                                        */
  cpl_propertylist                 **telluriccorr_head;          /* Science spectrum header array                                                                                               */
  cpl_table                        **telluriccorr_data;          /* Science spectrum data   array                                                                                               */
  cpl_table                        **best_fit_parameters_table;  /* Best fit parameters array                                                                                                   */
  mf_calctrans_lblrtm_results      **results_lblrtm;             /* Results execute mf_calctrans_lblrtm for every input extension                                                               */
  mf_calctrans_convolution_results **results_convolution;        /* Results of telluric corrections after execute mf_calctrans_convolution                                                      */

  mf_configuration                 *mf_config;                   /* Telluric Correction configuration parameter                                                                                 */

  cpl_boolean                      chip_extensions;              /* If the user want to combine the input FITS extensions                                                                       */

  cpl_propertylist                 *pl;                          /* All input parameters to save in the output files                                                                            */

} molecfit_calctrans_parameter;

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code load_tag_science(mf_wrap_fits *data, cpl_frame * input_frame);

cpl_error_code load_tag_molecules (cpl_frameset *frameset, cpl_table * molecules);


cpl_error_code load_tag_calc_kernel_lib(mf_wrap_fits * kernel_data, cpl_table       *mapping_kernel,
		cpl_frameset * frameset, molecfit_calctrans_parameter * parameters);

cpl_error_code load_tag_mapping_atm(cpl_table *mapping_atmospheric, molecfit_calctrans_parameter * parameters );

cpl_error_code load_tag_mapping_conv(cpl_table *mapping_convolve, molecfit_calctrans_parameter * parameters );

//cpl_error_code mf_wrap_config_calc_setup_input_filenames(cpl_parameterlist* ilist, const char* suffix, const char* input_name);

//cpl_error_code mf_wrap_config_calc_setup_output_filenames(cpl_parameterlist* ilist, const char* suffix);

/* Parse output header and add to the mf_parameters_config and the header propertylist */
mf_configuration * molecfit_config_load_header_parameters(
    const cpl_propertylist   *header,
    const cpl_propertylist   *data_header,
    cpl_propertylist         *pl);

/* Cleanup any memory allocations that were created by calling
     molecfit_config_load_header_parameters */
void molecfit_config_delete_configuration(mf_configuration* cfg) ;


molecfit_calctrans_parameter * mf_wrap_config_calc_init(cpl_frameset * frameset, const cpl_parameterlist  *list,cpl_propertylist *scientific_head_pri,cpl_size n_ext, const char* combined_suffix);

/*-----------------------------------------------------------------------------*/


molecfit_calctrans_parameter * molecfit_calctrans_parameters(
    const cpl_frameset              *frameset,
    const cpl_parameterlist         *list,
    const cpl_propertylist          *scientific_head_pri,
    const cpl_size                  n_ext);

void molecfit_calctrans_parameter_delete(
    molecfit_calctrans_parameter *parameters);


// mf_wrap_sciframe(cpl_frameset *frameset, const cpl_parameterlist  *parlist, mf_wrap_model_parameter *parameters); // DO WE NEED THIS ??


CPL_END_DECLS


#endif /* MF_WRAP_CONFIG_CALC_H */
