/*
 * This file is part of the Molecfit Pipeline
 * Copyright (C) 2001-2019 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_DATA_H
#define MF_WRAP_DATA_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

//#include <telluriccorr.h>
#include "mf_parameters.h"

#include "mf_wrap_fits.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/* Extract spectrum from cpl_table */
cpl_table * mf_wrap_data_extract_spectrum_from_cpl_table(
    cpl_propertylist         *header,
    const cpl_table          *table,
    const int                chip,
    const char               *column_lambda,
    const char               *column_flux,
    const char               *column_dflux,
    const char               *column_mask);

/* Extract spectrum from cpl_propertylist and cpl_vector's */
cpl_table * mf_wrap_data_extract_spectrum_from_cpl_vector(
    cpl_propertylist         *header,
    const cpl_vector         *flux_in,
    const cpl_vector         *dflux_in,
    const cpl_vector         *mask_in,
    const int                chip,
    const char               *column_lambda,
    const char               *column_flux,
    const char               *column_dflux,
    const char               *column_mask);

/* Extract spectrum from cpl_image */
cpl_table * mf_wrap_data_extract_spectrum_from_cpl_image(
    cpl_propertylist         *header,
    const cpl_image          *img,
    const cpl_image          *dflux_in,
    const cpl_image          *mask_in,
    const int                chip,
    const char               *column_lambda,
    const char               *column_flux,
    const char               *column_dflux,
    const char               *column_mask);

/* Extract spectrum from cpl_imagelist (datacube) */
cpl_table * mf_wrap_data_extract_spectrum_from_cpl_imagelist(
    cpl_propertylist         *header,
    const cpl_imagelist      *cube,
    const cpl_image          *dflux_in,
    const cpl_image          *mask_in,
    const int                chip,
    const char               *column_lambda,
    const char               *column_flux,
    const char               *column_dflux,
    const char               *column_mask);


/* Update cpl_table with molecfit_data cpl_table */
cpl_error_code mf_wrap_data_update_table(
    const cpl_table          *molecfit_data,
    const cpl_boolean        chip_extensions,
    mf_wrap_fits            *data,
    const cpl_size           ext_ini,
    const char               *column_flux);

/* Update cpl_vector with molecfit_data cpl_table */
cpl_error_code mf_wrap_data_update_vector(
    const cpl_table          *molecfit_data,
    const cpl_boolean        chip_extensions,
    mf_wrap_fits            *data,
    const cpl_size           ext_ini);

/* Update cpl_image with molecfit_data cpl_table */
cpl_error_code mf_wrap_data_update_image(
    const cpl_table          *molecfit_data,
    const cpl_boolean        chip_extensions,
    mf_wrap_fits            *data,
    const cpl_size           ext_ini);

/* Update cpl_imagelist with molecfit_data cpl_table */
cpl_error_code mf_wrap_data_update_cube(
    const cpl_table          *molecfit_data,
    const cpl_boolean        chip_extensions,
    mf_wrap_fits            *data,
    const cpl_size           ext_ini);


CPL_END_DECLS


#endif /* MOLECFIT_DATA_H */
