# define installation location with: prefix=/path
# to use on macos:
# make -f BuildThirdParty.mk lnfl_target=osxGNUsgl lnfl_bin=lnfl_v2.6_OS_X_gnu_sgl \
#                            lblrtm_target=osxGNUsgl lblrtm_bin=lblrtm_v12.2_OS_X_gnu_sgl \
#                            prefix=/path


# Check system
OS := $(shell uname)
ifeq ($(OS), Darwin)
   lnfl_bin ?= lnfl_v3.2_OS_X_gnu_sgl
   lblrtm_bin ?= lblrtm_v12.11_OS_X_gnu_sgl
   lnfl_target ?= customOsxGNUsgl
else
   lnfl_bin ?= lnfl_v3.2_linux_gnu_sgl
   lblrtm_bin ?= lblrtm_v12.11_linux_gnu_sgl
   lnfl_target ?= customLinuxGNUsgl
endif
lblrtm_target ?= $(lnfl_target)

# Check fortran compiler
FC_SEARCH := TRUE
ifdef FC
    
   $(if $(shell command -v $(FC) 2> /dev/null),\
        $(info     Found in the system the Fortran Compiler specified in FC=$(FC)); $(eval FC_SEARCH=FALSE),\
        $(info Not found in the system the Fortran Compiler specified in FC=$(FC))\
   )
   
   ifneq ($(FC_SEARCH),TRUE)
        ifeq ($(FC),f77)
           $(info Compiler f77 not supported [FC=$(FC)])
           FC_SEARCH = TRUE
        endif
   endif
   
endif

# if not define Fortran compiler or not exist search Fortran compiler installed
ifeq ($(FC_SEARCH),TRUE)

    $(info Searching valid Fortran compilers in the system ...)

    FC_COMPILERS := xlf90 absoft g95 ifortran pgf90 f90 gfortran
    
    # Check general compilers
    FC_FOUND := FALSE
    $(foreach fc_compiler,$(FC_COMPILERS),\
       $(if $(shell command -v $(fc_compiler) 2> /dev/null),\
            $(info Found     FC=$(fc_compiler)); $(eval FC_FOUND=$(fc_compiler)),\
            $(info Not found FC=$(fc_compiler))\
       )\
    )
    
    # Check gfortran-mp-[version] compilers
    ifeq ($(FC_FOUND),FALSE)
        $(foreach i,$(shell seq 1 20),\
            $(if $(shell command -v gfortran-mp-$(i) 2> /dev/null),\
                 $(info Found     FC=gfortran-mp-$(i)); $(eval FC_FOUND=gfortran-mp-$(i)),\
                 $(info Not found FC=gfortran-mp-$(i));\
                 $(foreach j,$(shell seq 1 20),\
                     $(if $(shell command -v gfortran-mp-$(i).$(j) 2> /dev/null),\
                          $(info Found     FC=gfortran-mp-$(i).$(j)); $(eval FC_FOUND=gfortran-mp-$(i).$(j)),\
                          $(info Not found FC=gfortran-mp-$(i).$(j))\
                     )\
                 )\
            )\
        )    
    endif
    
    # Check and export variable
    ifeq ($(FC_FOUND),FALSE)
        $(error "Not found valid Fortran compilers in the system!")
    else
        export FC := $(FC_FOUND)
        $(info "Fortran compiler : FC = $(FC)")
    endif


endif

##############################################################
# Custom
##############################################################
value = $(shell $(FC) -dumpversion | sed 's/\..*//g')
ifeq ($(shell expr $(value) \>= 10), 1)
   export ESOFCFLAG = "-fallow-argument-mismatch "
   $(info "FCVERSION : $(value)")
else ifeq ($(shell expr $(value) \< 10), 1)
   export ESOFCFLAG = ""
   $(info "FCVERSION : $(value)")
endif

   
all: lnfl lblrtm aer

check-prefix:
	@echo "Checking prefix"
	test -n "$(prefix)"
	# install -d not supported on mac
	mkdir -p $(DESTDIR)$(prefix)/bin/
	mkdir -p $(DESTDIR)$(prefix)/share/molecfit/data/hitran

install: check-prefix lnfl lblrtm aer
	install -m 744 lblrtm/$(lblrtm_bin) $(DESTDIR)$(prefix)/bin/lblrtm
	install -m 744 lnfl/$(lnfl_bin) $(DESTDIR)$(prefix)/bin/lnfl
	install -m 644 aer/line_file/aer_v_3.8.1.2 $(DESTDIR)$(prefix)/share/molecfit/data/hitran/aer_v_3.8.1.2
	install -m 644 aer/extra_brd_params/* $(DESTDIR)$(prefix)/share/molecfit/data/hitran/
	install -m 644 aer/spectral_lines_for_MonoRTM/* $(DESTDIR)$(prefix)/share/molecfit/data/hitran/
	chmod a+x $(DESTDIR)$(prefix)/bin/lnfl
	chmod a+x $(DESTDIR)$(prefix)/bin/lblrtm

clean:
	rm -rf lnfl/
	rm -rf lblrtm/
	rm -rf aer/
	rm -f *-stamp

lnfl: lnfl-stamp
lnfl-stamp:
	tar xfz aerlnfl*.tar.*
	$(MAKE) -C lnfl/build -f make_lnfl $(lnfl_target)
	touch $@
    	
lblrtm: lblrtm-stamp
lblrtm-stamp:
	tar xfz aerlbl*.tar.*
	$(MAKE) -C lblrtm/build -f make_lblrtm $(lblrtm_target)
	touch $@

aer: aer-stamp
aer-stamp:
	tar xfz aer_v3.8.1.2.tar.*
	touch $@

.PHONY: lnfl lblrtm aer check-prefix install
