from adari_core.plots.text import TextPlot
from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport

import os
import logging

from . import KmosReportMixin

logger = logging.getLogger(__name__)

center_size = 200


class KmosMasterDarkReport(KmosReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("kmos_master_dark")
        self.center_size = center_size

    def parse_sof(self):
        # Need to generate two report sets:
        # MASTER_DARK
        master_dark = None

        for filename, catg in self.inputs:
            if catg == "MASTER_DARK" and master_dark is None:
                master_dark = filename

        # Build and return the file name list
        file_lists = []
        if master_dark is not None:
            file_lists.append({"master_im": master_dark})
        logger.debug(file_lists)
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}

        exts = ["DET.1.DATA", "DET.2.DATA", "DET.3.DATA"]
        for ext in exts:
            new_panels = super().generate_panels(
                # ext=ext,
                master_im_ext=ext,
                master_title="Master dark",
                **kwargs,
            )
            for i, (panel, panel_descr) in enumerate(new_panels.items()):
                panel_descr["report_description"] = (
                    f"KMOS dark panel - "
                    f"{os.path.basename(panel_descr['master_im'])}, "
                    f"{panel_descr['master_im_ext']}"
                )
                master_im = self.hdus[i]["master_im"]

                # Text Plot
                px = 0
                py = 0
                # which hdul and ext to use
                vspace = 0.3
                fname = os.path.basename(str(master_im.filename()))
                t1 = TextPlot(columns=1, v_space=vspace)
                col1 = (
                    str(master_im["PRIMARY"].header.get("INSTRUME")),
                    "EXTNAME: " + str(master_im[ext].header.get("EXTNAME", "N/A")),
                    "PRO CATG: "
                    + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                    "FILE NAME: " + fname,
                    "RAW1 NAME: "
                    + str(
                        master_im["PRIMARY"].header.get(
                            "HIERARCH ESO PRO REC1 RAW1 NAME"
                        )
                    ),
                )
                t1.add_data(col1)
                panel.assign_plot(t1, px, py, xext=2)

                px = px + 2
                t2 = TextPlot(columns=1, v_space=vspace, xext=1)
                col2 = (
                    "DET SEQ1 DIT: "
                    + str(
                        master_im["PRIMARY"].header.get("HIERARCH ESO DET SEQ1 DIT ")
                    ),
                )
                t2.add_data(col2)
                panel.assign_plot(t2, px, py, xext=1)

            panels = {**panels, **new_panels}

        return panels


rep = KmosMasterDarkReport()
