class KmosSetupInfo:
    def dark(hdul):
        metadata = [
            "DET SEQ1 DIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET SEQ1 DIT ", "N/A")),
        ]
        return metadata

    def flat(hdul):
        metadata = [
            "INS.GRAT1.NAME: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT1 NAME", "N/A")),
            "INS.GRAT1.WLEN: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT1 WLEN", "N/A")),
            "DET.SEQ1.DIT: "
            + str(hdul["PRIMARY"].header.get("HIERARCH ESO DET SEQ1 DIT", "N/A")),
        ]
        return metadata

    def arc(hdul):
        return KmosSetupInfo.flat(hdul)

    def sky_flat(hdul):
        return KmosSetupInfo.flat(hdul)

    def illumination(hdul):
        return KmosSetupInfo.flat(hdul)

    def standard(hdul):
        metadata = KmosSetupInfo.flat(hdul)
        # The requirements include PRO.ROT.ANGLE
        # but that is not contained in the PRIMARY
        return metadata

    def acquisition_profile(hdul):
        return KmosSetupInfo.flat(hdul)

    def astrometry_profile(hdul):
        return KmosSetupInfo.flat(hdul)
