from edps import classification_rule

from . import kmos_keywords as kwd
from . import kmos_rules as rules

# Dictionaries containing the values of header keywords that define calibrations and science in different
# tech modes (image, spectra, and ifu)
kmos = {kwd.instrume: "KMOS"}
spectra_calibs = {**kmos, kwd.dpr_tech: "SPECTRUM", kwd.dpr_catg: "CALIB"}
image_calibs = {**kmos, kwd.dpr_tech: "IMAGE", kwd.dpr_catg: "CALIB"}
ifu_calibs = {**kmos, kwd.dpr_tech: "IFU", kwd.dpr_catg: "CALIB"}
ifu_acquisition = {**kmos, kwd.dpr_tech: "IFU", kwd.dpr_catg: "ACQUISITION"}
ifu_science = {**kmos, kwd.dpr_tech: "IFU", kwd.dpr_catg: "SCIENCE"}

# raw files
dark_class = classification_rule("DARK", {**image_calibs, kwd.dpr_type: "DARK"})
flat_on_class = classification_rule("FLAT_ON", {**spectra_calibs, kwd.dpr_type: "FLAT,LAMP"})
flat_off_class = classification_rule("FLAT_OFF", {**image_calibs, kwd.dpr_type: "FLAT,OFF"})
arc_on_class = classification_rule("ARC_ON", {**spectra_calibs, kwd.dpr_type: "WAVE,LAMP"})
arc_off_class = classification_rule("ARC_OFF", {**image_calibs, kwd.dpr_type: "WAVE,OFF"})
flat_sky_class = classification_rule("FLAT_SKY", {**ifu_calibs, kwd.dpr_type: "FLAT,SKY"})
std_class = classification_rule("STD", {**ifu_calibs, kwd.dpr_type: "OBJECT,SKY,STD,FLUX"})
science_class = classification_rule("SCIENCE", {**ifu_science, kwd.dpr_type: "OBJECT,SKY"})
astrometry_class = classification_rule("OBJECT", {**ifu_calibs, kwd.dpr_type: "OBJECT,SKY"})
acquisition_class = classification_rule("OBJECT", rules.is_acquisition)
sky_acquisition_class = classification_rule("OBJECT", rules.is_acquisition_sky)
reduced_class = classification_rule("SINGLE_CUBES", rules.is_single_cubes)

# static calibrations
ref_lines_class = classification_rule("REF_LINES", {**kmos, kwd.pro_catg: "REF_LINES"})
wave_band_class = classification_rule("WAVE_BAND", {**kmos, kwd.pro_catg: "WAVE_BAND"})
arc_list_class = classification_rule("ARC_LIST", {**kmos, kwd.pro_catg: "ARC_LIST"})
solar_spec_class = classification_rule("SOLAR_SPEC", {**kmos, kwd.pro_catg: "SOLAR_SPEC"})
atmos_model_class = classification_rule("ATMOS_MODEL", {**kmos, kwd.pro_catg: "ATMOS_MODEL"})
spec_type_lookup_class = classification_rule("SPEC_TYPE_LOOKUP", {**kmos, kwd.pro_catg: "SPEC_TYPE_LOOKUP"})
response_class = classification_rule("RESPONSE", {**kmos, kwd.pro_catg: "RESPONSE"})
gdas_class = classification_rule("GDAS", {**kmos, kwd.pro_catg: "GDAS"})
oh_spec_class = classification_rule("OH_SPEC", {**kmos, kwd.pro_catg: "OH_SPEC"})

# master calibrations
STAR_SPEC = classification_rule("STAR_SPEC", {**kmos, kwd.pro_catg: "STAR_SPEC"})
TELLURIC = classification_rule("TELLURIC", {**kmos, kwd.pro_catg: "TELLURIC"})
TELLURIC_CORR = classification_rule("TELLURIC_CORR", {**kmos, kwd.pro_catg: "TELLURIC_CORR"})
TELLURIC_GEN = classification_rule("TELLURIC_GEN", {**kmos, kwd.pro_catg: "TELLURIC_GEN"})
SCI_RECONSTRUCTED = classification_rule("SCI_RECONSTRUCTED", {**kmos, kwd.pro_catg: "SCI_RECONSTRUCTED"})
SCI_RECONSTRUCTED_COLL = classification_rule("SCI_RECONSTRUCTED_COLL", {**kmos, kwd.pro_catg: "SCI_RECONSTRUCTED_COLL"})

SINGLE_CUBES = classification_rule("SINGLE_CUBES", {**kmos, kwd.pro_catg: "SINGLE_CUBES"})
KERNEL_LIBRARY = classification_rule("KERNEL_LIBRARY", {**kmos, kwd.pro_catg: "KERNEL_LIBRARY"})
MASTER_DARK = classification_rule("MASTER_DARK", {**kmos, kwd.pro_catg: "MASTER_DARK"})
MASTER_FLAT = classification_rule("MASTER_FLAT", {**kmos, kwd.pro_catg: "MASTER_FLAT"})
BADPIXEL_FLAT = classification_rule("BADPIXEL_FLAT", {**kmos, kwd.pro_catg: "BADPIXEL_FLAT"})
BADPIXEL_DARK = classification_rule("BADPIXEL_DARK", {**kmos, kwd.pro_catg: "BADPIXEL_DARK"})
XCAL = classification_rule("XCAL", {**kmos, kwd.pro_catg: "XCAL"})
YCAL = classification_rule("YCAL", {**kmos, kwd.pro_catg: "YCAL"})
FLAT_EDGE = classification_rule("FLAT_EDGE", {**kmos, kwd.pro_catg: "FLAT_EDGE"})
ILLUM_CORR = classification_rule("ILLUM_CORR", {**kmos, kwd.pro_catg: "ILLUM_CORR"})
LCAL = classification_rule("LCAL", {**kmos, kwd.pro_catg: "LCAL"})
DET_IMG_WAVE = classification_rule("DET_IMG_WAVE", {**kmos, kwd.pro_catg: "DET_IMG_WAVE"})
BEST_FIT_MODEL = classification_rule("BEST_FIT_MODEL", {**kmos, kwd.pro_catg: "BEST_FIT_MODEL"})
BEST_FIT_PARM = classification_rule("BEST_FIT_PARM", {**kmos, kwd.pro_catg: "BEST_FIT_PARM"})
ATMOS_PARM = classification_rule("ATMOS_PARM", {**kmos, kwd.pro_catg: "ATMOS_PARM"})
CUBE_ACQUISITION = classification_rule("CUBE_ACQUISITION", {**kmos, kwd.pro_catg: "CUBE_ACQUISITION"})
CUBE_ASTROMETRY = classification_rule("CUBE_ASTROMETRY", {**kmos, kwd.pro_catg: "CUBE_ASTROMETRY"})
CUBE_OBJECT = classification_rule("CUBE_OBJECT", {**kmos, kwd.pro_catg: "CUBE_OBJECT"})
CUBE_SCIENCE = classification_rule("CUBE_SCIENCE", {**kmos, kwd.pro_catg: "CUBE_SCIENCE"})
MAKE_IMAGE = classification_rule("MAKE_IMAGE", {**kmos, kwd.pro_catg: "MAKE_IMAGE"})
COMMAND_LINE = classification_rule("COMMAND_LINE", {**kmos, kwd.pro_catg: "COMMAND_LINE"})
CALCTRANS_ATMOS_PARM = classification_rule("CALCTRANS_ATMOS_PARM", {**kmos, kwd.pro_catg: "CALCTRANS_ATMOS_PARM"})
