from edps import subworkflow, task, qc1calib, ReportInput, Job

from .kmos_datasources import *


# Subworkflow for computing the spatial profile of acquisition images and astrometric fields.
# Not needed for science reduction.
@subworkflow('kmos_fit_profiles', '')
def kmos_fit_profiles(flats, wavelength):
    # ------ Tasks for fitting the profile of acquisition images -------------------------------------------------------

    # Process only the last acquisition
    def process_last_file(job: Job):
        job.input_files = [job.input_files[-1]]

    acquisition_reconstruct = (task('acquisition_reconstruct')
                               .with_recipe('kmos_reconstruct')
                               .with_report('kmos_rawdisp', ReportInput.RECIPE_INPUTS, driver='png')
                               .with_main_input(raw_acquisition)
                               .with_associated_input(static_wave_band)
                               .with_associated_input(flats, [XCAL, YCAL])
                               .with_associated_input(wavelength, [LCAL])
                               .with_input_filter(LCAL, XCAL, YCAL, wave_band_class)
                               .with_job_processing(process_last_file)  # Only the last main input file is processed
                               .with_meta_targets([qc1calib])
                               .build())

    acquisition_image = (task('acquisition_image')
                         .with_recipe('kmo_make_image')
                         .with_main_input(acquisition_reconstruct)
                         .with_input_filter(CUBE_OBJECT, CUBE_SCIENCE)
                         .with_meta_targets([qc1calib])
                         .build())

    acquisition_profile = (task('acquisition_profile')
                           .with_recipe('kmo_fit_profile')
                           .with_report('kmos_acquisition', ReportInput.RECIPE_INPUTS_OUTPUTS, driver='png')
                           .with_main_input(acquisition_image)
                           .with_input_map({MAKE_IMAGE: COMMAND_LINE})
                           .with_input_filter(MAKE_IMAGE)
                           .with_meta_targets([qc1calib])
                           .build())
    # ------------------------------------------------------------------------------------------------------------------

    # ------ Tasks for fitting the profile of astrometric fields -------------------------------------------------------
    astrometry_reconstruct = (task('astrometry_reconstruct')
                              .with_recipe('kmos_reconstruct')
                              .with_report('kmos_rawdisp', ReportInput.RECIPE_INPUTS, driver='png')
                              .with_main_input(raw_astrometry)
                              .with_associated_input(static_wave_band)
                              .with_associated_input(flats, [XCAL, YCAL])
                              .with_associated_input(wavelength, [LCAL])
                              .with_input_filter(LCAL, XCAL, YCAL, wave_band_class)
                              .with_meta_targets([qc1calib])
                              .build())

    astrometry_image = (task('astrometry_make_image')
                        .with_recipe('kmo_make_image')
                        .with_main_input(astrometry_reconstruct)
                        .with_input_filter(CUBE_OBJECT, CUBE_SCIENCE)
                        .with_meta_targets([qc1calib])
                        .build())

    astrometry_profile = (task('astrometry_profile')
                          .with_recipe('kmo_fit_profile')
                          .with_report('kmos_astrometry', ReportInput.RECIPE_INPUTS_OUTPUTS, driver='png')
                          .with_main_input(astrometry_image)
                          .with_input_map({MAKE_IMAGE: COMMAND_LINE})
                          .with_input_filter(MAKE_IMAGE)
                          .with_meta_targets([qc1calib])
                          .build())
    # ------------------------------------------------------------------------------------------------------------------

    return acquisition_profile, astrometry_profile
