from edps import JobParameters, get_parameter


########################################################################################################################
###         Functions that define conditions depending on the values of the the workflow parameters                  ###
########################################################################################################################

def not_qc0(params: JobParameters):
    return get_parameter(params, 'qc0') == 'false'


def use_lamp_flats(params: JobParameters):
    return get_parameter(params, 'use_sky_flats') == 'false'


def use_sky_flats(params: JobParameters):
    return get_parameter(params, 'use_sky_flats') == 'true'


def use_telluric_standard(params: JobParameters):
    return get_parameter(params, 'molecfit') == 'false'


def use_molecfit(params: JobParameters):
    return get_parameter(params, 'molecfit') != 'false'


def molecfit_on_standard(params: JobParameters):
    return get_parameter(params, 'molecfit') == 'standard'


def molecfit_on_science(params: JobParameters):
    return get_parameter(params, 'molecfit') == 'science'
