/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef TELLURICCORR_H
#define TELLURICCORR_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

/* Defines to use on telluriccoor and externally */
#include "mf_constants.h"

/* Default parameters of telluriccoor */
#include "mf_configuration.h"

/* telluriccoor parameters and defines : User and internal structures and management */
#include "mf_parameters.h"

/* Structures for LNFL and LBLRTM and functions of data layer */
#include "mf_io.h"

/* Structures for string list parameter API functions */
/*#include "mf_strlst.h"*/

/* telluriccoor LNFL parameters and defines : User and internal structures and management */
#include "mf_lnfl.h"

/* telluriccoor LBLRTM parameters and defines : User and internal structures and management */
#include "mf_lblrtm.h"

/* Tools to work with molecules */
#include "mf_molecules.h"

/* Tools to generate the input user kernel */
#include "mf_kernel_user.h"

/* Build telluriccoor input spectrum and check ranges */
#include "mf_spectrum.h"

/* Check user GDAS input */
#include "mf_gdas.h"

/* Check user ATM_PROFILE_STANDARD */
#include "mf_atm_combined_gdas.h"

/* Calculate the atmospheric profile with the best-fit parameters and model */
#include "mf_model.h"

/* Calculate the telluric correction */
#include "mf_calctrans.h"

#include "mf_convolution.h"

#include "mf_wrap_config.h"

#include "mf_wrap.h"


//#include "mf_wrap_data.h"

//#include "mf_wrap_dfs.h"

//#include "mf_wrap_fits.h"

//#include "mf_wrap_utils.h"

#endif /* TELLURICCORR_H */
