
# MATISSE_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([MATISSE_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


# MATISSE_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([MATISSE_SET_VERSION_INFO],
[
    matisse_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    matisse_major_version=`echo "$matisse_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    matisse_minor_version=`echo "$matisse_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    matisse_micro_version=`echo "$matisse_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$matisse_major_version"; then matisse_major_version=0
    fi

    if test -z "$matisse_minor_version"; then matisse_minor_version=0
    fi

    if test -z "$matisse_micro_version"; then matisse_micro_version=0
    fi

    MATISSE_VERSION="$matisse_version"
    MATISSE_MAJOR_VERSION=$matisse_major_version
    MATISSE_MINOR_VERSION=$matisse_minor_version
    MATISSE_MICRO_VERSION=$matisse_micro_version

    if test -z "$4"; then MATISSE_INTERFACE_AGE=0
    else MATISSE_INTERFACE_AGE="$4"
    fi

    MATISSE_BINARY_AGE=`expr 100 '*' $MATISSE_MINOR_VERSION + $MATISSE_MICRO_VERSION`
    MATISSE_BINARY_VERSION=`expr 10000 '*' $MATISSE_MAJOR_VERSION + \
                          $MATISSE_BINARY_AGE`

    AC_SUBST(MATISSE_VERSION)
    AC_SUBST(MATISSE_MAJOR_VERSION)
    AC_SUBST(MATISSE_MINOR_VERSION)
    AC_SUBST(MATISSE_MICRO_VERSION)
    AC_SUBST(MATISSE_INTERFACE_AGE)
    AC_SUBST(MATISSE_BINARY_VERSION)
    AC_SUBST(MATISSE_BINARY_AGE)

    AC_DEFINE_UNQUOTED(MATISSE_MAJOR_VERSION, $MATISSE_MAJOR_VERSION,
                       [MATISSE major version number])
    AC_DEFINE_UNQUOTED(MATISSE_MINOR_VERSION, $MATISSE_MINOR_VERSION,
                       [MATISSE minor version number])
    AC_DEFINE_UNQUOTED(MATISSE_MICRO_VERSION, $MATISSE_MICRO_VERSION,
                       [MATISSE micro version number])
    AC_DEFINE_UNQUOTED(MATISSE_INTERFACE_AGE, $MATISSE_INTERFACE_AGE,
                       [MATISSE interface age])
    AC_DEFINE_UNQUOTED(MATISSE_BINARY_VERSION, $MATISSE_BINARY_VERSION,
                       [MATISSE binary version number])
    AC_DEFINE_UNQUOTED(MATISSE_BINARY_AGE, $MATISSE_BINARY_AGE,
                       [MATISSE binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# MATISSE_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([MATISSE_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
         pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$privatelibdir"; then
       privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$wkfextradir"; then
       wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
       wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/${PACKAGE}'
    fi

    if test -z "$reportsdir"; then
       reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(privatelibdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(workflowdir)
    AC_SUBST(reportsdir)

    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(MATISSE_PLUGIN_DIR, "esopipes-plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/\/${PACKAGE}-${VERSION}.*$//"`

    AC_DEFINE_UNQUOTED(MATISSE_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

])


# MATISSE_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([MATISSE_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    MATISSE_INCLUDES='-I$(top_srcdir)/matisse'
    MATISSE_LDFLAGS='-L$(top_builddir)/matisse'

    # No -L for IRPLIB which is statically linked
    all_includes='$(MATISSE_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(MATISSE_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS)'

    # Library aliases

    LIBMATISSE='$(top_builddir)/matisse/libmatisse.la'

    # Substitute the defined symbols

    AC_SUBST(MATISSE_INCLUDES)
    AC_SUBST(MATISSE_LDFLAGS)

    AC_SUBST(LIBMATISSE)

    # Check for CPL and user defined libraries
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(MATISSE_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(MATISSE_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
