/* $Id: mat_apply_staticcalib.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/03/28 11:03:00 $
 * $Revision: 0.5 $
 * $Name: mat_apply_staticcalib.h $
 */

#ifndef MAT_APPLY_STATICCALIB_H
#define MAT_APPLY_STATICCALIB_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "mat_drl.h"
#include "mat_frame.h"
#include "mat_badpixel.h"
#include "mat_flatfield.h"
#include "mat_nonlinearity.h"
#include "mat_obsflat.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

typedef struct {
  int         expno;                /*!< Value of ESO TPL EXPNO */
  double      timstart;             /*!< Start of the detector specific TIM-Board trigger (ESO INS TIMDL/N START, only the fractional part [s]) */
  double      timperiod;            /*!< Trigger period (ESO INS TIMDL/N PERIOD [s]) */
  double      framestart;           /*!< Time of the first frame (only the fractional part [s]) */
  double      chopfreq;             /*!< Frequency of the chopper (ESO ISS CHOP FREQ, in [Hz]) */
  double      delay;                /*!< Time between starting the TIM-Board trigger and the first frame of the exposure */
  int         nbsky;                /*!< Largest number of consecutive sky frames including dead frames */
  int         nbtarget;             /*!< Largest number of consecutive target frames including dead frames */
  int         nbdead;               /*!< Number of dead frames */
  int         est_time_shift;       /*!< Frame shift derived fom timing information */
  int         est_V_shift;          /*!< Frame shift derived from V value (Allouche + Lagarde) */
  int         est_S_shift;          /*!< Frame shift derived from fitting a square wave to the intensity */
  int         est_N_shift;          /*!< Frame shift derived froma C code implementation of resynchro.py */
  double      sky_relint[4];        /*!< Frame relative intensity for the first and last two sky frames of a chopping cycle. */
  double      tar_relint[4];        /*!< Frame relative intensity for the first and last two target frames of a chopping cycle. */
} mat_tartyp_result;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_gendata *mat_calibration_detector(mat_gendata *raw,
				      mat_badpixel *bpm,
				      mat_flatfield *ffm,
				      mat_nonlinearity *nlm,
				      mat_obsflat *ofm,
				      mat_frame *pbm,
				      int compensation,
				      int reduce,
				      int inplace);

mat_gendata *mat_apply_staticcalib(mat_gendata *gendata,
				   mat_badpixel *bad, 
				   mat_nonlinearity *nonlin,
				   mat_obsflat *obsflat);

void mat_tartyp_check(mat_gendata *data,
		      int flags,
		      int excess_count,
		      int skip_count,
		      mat_tartyp_result *result);

#endif
