/* $Id: mat_cal_cphase_lib.c,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/11/29  $
 * $Revision: 0.5 $
 * $Name: mat_cal_cphase_lib.c $
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/

#include "mat_cal_cphase_lib.h"


/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/






/*----------------------------------------------------------------------------*/
/**
   @brief This function is called by the mat_cal_cphase recipe
   @param parlist    contains the parameters supported by 
   the recipe
   @param frameset   the list of frames that have been given to
   the recipe for processing
   @param recname    Name of the recipes calling this function
   @return 0 if everything is ok
*/
/*----------------------------------------------------------------------------*/

int mat_cal_cphase_lib(cpl_parameterlist *parlist, cpl_frameset *frameset,
                       const char *recname) {
    
    cpl_frame *cur_frame=NULL;
    cpl_frame *frame=NULL;
    cpl_frameset *usedframes = NULL;
    cpl_propertylist *p_list = NULL;
    cpl_propertylist *p_list_array = NULL;
    cpl_propertylist *p_list_oitransfunc = NULL;
    cpl_propertylist *qclist = NULL;
    cpl_table *table = NULL;
    /* int expert = 0; */
    int nb_extent = 0;
    int nbfile = 0;
    int i = 0;
    int j = 0;
    int k = 0;
    int l = 0;
    int m = 0;
    int cpt = 0;
    int nbBlockTotal = 0;
    int *nbBlock=NULL;
    int nbTel=0;
    int nbTriplet=0;
    int index1 = 0;
    int index2 = 0;
    int index3 = 0;
    int flag = 0;
    int nbOifitscal = 0;
    int indexChipName=0;
    /* char filename[200] = " "; */
    char *filename=NULL;
    double **aux = NULL;
    double **auxerr = NULL;
    double *data = NULL;
    double *dataerr = NULL;
    double mean = 0.0;
    double stdev = 0.0;
    char *p_filename = NULL;
    char *p_filetag = NULL;
    char *keyExtname = NULL;
    char *qcname1 = NULL;
    char *qcname2 = NULL;
    char *pszChipName = NULL;
    mat_oifits *oifits = NULL;
    mat_oifits **oifitscal = NULL;
    mat_array *oiarray = NULL;
    mat_array *oiarray_tempo = NULL;
    mat_oiwavelength *oiwave = NULL;
    mat_oiwavelength *oiwave_tempo = NULL;
    cpl_frameset_iterator *it=NULL;
    cpl_errorstate prestate = cpl_errorstate_get();


    double      valIm       = 0., valRe       = 0.;
    double      phasorIm    = 0., phasorRe    = 0.;
    double      phasorTF_Im = 0., phasorTF_Re = 0.;
    double      phi         = 0.;

   
    nbfile = cpl_frameset_get_size( frameset);
    oifitscal = cpl_calloc(nbfile-1,sizeof(mat_oifits));
    usedframes = cpl_frameset_new();
    qclist = cpl_propertylist_new();

    /*target file, reference */
    /*to compare with calib files */
    prestate=cpl_errorstate_get();
    it= cpl_frameset_iterator_new(frameset);
    do {
        cur_frame = cpl_frameset_iterator_get(it);
        if (cur_frame != NULL) {
            /* cur_frame = cpl_frameset_get_first( frameset ); */
            /* while(cur_frame) { */
            cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
            p_filename = (char *)cpl_frame_get_filename(cur_frame);       
            p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
            if (!strcmp(p_filetag,"TARGET_RAW_INT")){
                /* if (mat_check_tag(p_filename, p_filetag, expert) == TRUE)  */
                /* { */
                nb_extent = cpl_frame_get_nextensions(cur_frame);
                for(i = 0; i<nb_extent; i++)
                {
                    p_list = cpl_propertylist_load(
                        cpl_frame_get_filename(cur_frame),i+1);
                    keyExtname = 
                        (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
                    /*oi_array data*/
                    if (!strcmp(keyExtname,"OI_ARRAY")) 
                    {                   
                        table=cpl_table_load(p_filename,i+1,0);
                        oiarray = mat_array_from_table(p_list,table);
                        cpl_table_delete(table);
                    }
                    if (!strcmp(keyExtname,"OI_WAVELENGTH") ) 
                    {                     
                        oiwave=mat_oiwavelength_load(cur_frame);
                    }
                    cpl_propertylist_delete(p_list);
                }
                /* } */
                /* else */
                /* { */
                /*      cpl_msg_info(cpl_func,"mat_cal_cphase, no TARGET_RAW_INT "); */
                /*      return 1; */
                /* } */
                break;
            }
        }
    } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
    cpl_frameset_iterator_delete(it);
    if (!cpl_errorstate_is_equal(prestate)) {
        cpl_errorstate_set(prestate);
    }
    /*   cur_frame = cpl_frameset_get_next( frameset ); */
    /* }  */

    /*check tag*/
    /*load oifits structure*/
    /*load oifitscal structures if oiarray and oiwavelength are equal to oifits */
    prestate=cpl_errorstate_get();
    it= cpl_frameset_iterator_new(frameset);
    do {
        cur_frame = cpl_frameset_iterator_get(it);
        if (cur_frame != NULL) {
            /* cur_frame = cpl_frameset_get_first( frameset ); */
            /* while(cur_frame)  */
            /*   { */
            /* Get Classification Tag */
            p_filename = (char *)cpl_frame_get_filename(cur_frame);
            p_filetag  = (char *)cpl_frame_get_tag(cur_frame);      
            /* if (mat_check_tag(p_filename, p_filetag, expert) == TRUE)  */
            /* { */
            nb_extent = cpl_frame_get_nextensions(cur_frame);
            for(i = 0; i<nb_extent; i++)
            {
                p_list = cpl_propertylist_load(
                    cpl_frame_get_filename(cur_frame),i+1);
                keyExtname = 
                    (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
                /*oi_array data*/
                if (!strcmp(keyExtname,"OI_ARRAY")) 
                {
                    table=cpl_table_load(p_filename,i+1,0);
                    p_list_array = cpl_propertylist_duplicate(p_list);
                    if (!strcmp(p_filetag,"CALIB_RAW_INT"))
                    {
                        oiarray_tempo = mat_array_from_table(p_list_array,table);                       
                    }               
                }
                if (!strcmp(keyExtname,"TF2") && flag ==0) 
                {
                    p_list_oitransfunc = cpl_propertylist_load(
                        cpl_frame_get_filename(cur_frame),i+1);
                    flag = 1;
                }
                if (!strcmp(keyExtname,"OI_WAVELENGTH") ) 
                {
                    if (!strcmp(p_filetag,"CALIB_RAW_INT"))
                        oiwave_tempo=mat_oiwavelength_load(cur_frame);
                }
                cpl_propertylist_delete(p_list);
            }

            if (!strcmp(p_filetag,"TARGET_RAW_INT"))
            {
                frame = cpl_frame_duplicate(cur_frame);
                cpl_frame_set_group(frame,CPL_FRAME_GROUP_RAW);
                cpl_frameset_insert(usedframes, frame);
                oifits = mat_oifits_load(cur_frame);
                if (oifits->oit3 == NULL) 
                {
                    cpl_msg_warning(cpl_func,
                                    "%s does not contain OIT3 binary table",
                                    p_filename);
                    mat_oifits_delete(oifits);
                    cpl_frameset_delete(usedframes);
                    cpl_propertylist_delete(qclist);
                    cpl_propertylist_delete(p_list_oitransfunc);
                    cpl_propertylist_delete(p_list_array);
                    for(i=0;i<=j;i++) {
                        if (oifitscal[j] != NULL) 
                        {
                            mat_oifits_delete(oifitscal[j]);
                        }
                    }
                    cpl_free(oifitscal);
                    mat_oiwavelength_delete(oiwave);
                    mat_array_delete(oiarray);
                    mat_oiwavelength_delete(oiwave_tempo);
                    mat_array_delete(oiarray_tempo);
                    cpl_table_delete(table);
                    return CPL_ERROR_INCOMPATIBLE_INPUT;
                }
            }

            if (!strcmp(p_filetag,"CALIB_RAW_INT"))
            {
                if (mat_array_compare(oiarray, oiarray_tempo) == CPL_TRUE &&
                    mat_oiwavelength_compare(oiwave, oiwave_tempo) == CPL_TRUE)
                {
                    frame = cpl_frame_duplicate(cur_frame);
                    cpl_frame_set_group(frame,CPL_FRAME_GROUP_RAW);
                    cpl_frameset_insert(usedframes, frame);
                    oifitscal[j] = mat_oifits_load(cur_frame);
                    if (oifitscal[j]->oit3 == NULL) 
                    {
                        cpl_msg_warning(cpl_func,
                                        "%s does not contain OIT3 binary table",
                                        p_filename);
                        mat_oifits_delete(oifits);
                        cpl_frameset_delete(usedframes);
                        cpl_propertylist_delete(qclist);
                        cpl_propertylist_delete(p_list_oitransfunc);
                        cpl_propertylist_delete(p_list_array);
                        for(i=0;i<=j;i++) 
                        {
                            if (oifitscal[j] != NULL) 
                            {
                                mat_oifits_delete(oifitscal[j]);
                            }
                        }
                        cpl_free(oifitscal);
                        mat_oiwavelength_delete(oiwave);
                        mat_array_delete(oiarray);
                        mat_oiwavelength_delete(oiwave_tempo);
                        mat_array_delete(oiarray_tempo);
                        cpl_table_delete(table);
                        return CPL_ERROR_INCOMPATIBLE_INPUT;
                    }
                    j = j+1;
                }
            }

            cpl_propertylist_delete(p_list_array);      
            cpl_table_delete(table);

            if (!strcmp(p_filetag,"CALIB_RAW_INT"))
            {
                mat_array_delete(oiarray_tempo);
                mat_oiwavelength_delete(oiwave_tempo);    
            }
            /* } */
            /* else  */
            /* { */
            /*     cpl_msg_error(cpl_func,"mat_check tag ko %s",p_filename); */
            /*     return CPL_ERROR_INCOMPATIBLE_INPUT; */
            /* } */

        }
    } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
    cpl_frameset_iterator_delete(it);
    if (!cpl_errorstate_is_equal(prestate)) {
        cpl_errorstate_set(prestate);
    }
    /*   cur_frame = cpl_frameset_get_next( frameset ); */
    /* } */
    mat_array_delete(oiarray);
    mat_oiwavelength_delete(oiwave);
    
    nbOifitscal = j;
    nbBlock=cpl_calloc(nbOifitscal,sizeof(int));
    nbBlockTotal=0;
    nbTel=mat_get_nbtel_from_oit3(oifitscal[0]->oit3);
    nbTriplet=mat_combinaison(nbTel,3);
    for(j=0; j<nbOifitscal; j++ ) {
        nbBlock[j]=(int)(oifitscal[j]->oit3->nbt3/nbTriplet);
        nbBlockTotal+=nbBlock[j];
    }
    
    if (oifits == NULL) {
        cpl_free(nbBlock);
        return CPL_ERROR_INCOMPATIBLE_INPUT;
    }
    aux = cpl_calloc(oifits->oit3->nbchannel, sizeof(double));
    auxerr = cpl_calloc(oifits->oit3->nbchannel, sizeof(double));
    for(j=0; j<oifits->oit3->nbchannel; j++ )
    {
        aux[j] = cpl_calloc(nbBlockTotal, sizeof(double));
        auxerr[j] = cpl_calloc(nbBlockTotal, sizeof(double));
    }
    data = cpl_calloc(oifits->oit3->nbchannel, sizeof(double));
    dataerr = cpl_calloc(oifits->oit3->nbchannel, sizeof(double));

    for (l=0; l < oifits->oit3->nbchannel; l++ )
    {
        data[l] = 0.0;
        dataerr[l] = 0.0;
        for(j=0; j<nbBlockTotal; j++ ){
            aux[l][j]=0.0;
            auxerr[l][j]=0.0;
        }
    }
    
    //printf("yo men!");
    //printf("CPL_MATH_RAD_DEG = %f / CPL_MATH_DEG_RAD = %f \n", CPL_MATH_RAD_DEG, CPL_MATH_DEG_RAD);

    /*save data*/
    /*"pour chaque ligne du fichier cible:*/
    /* read target file's line */
    for (i=0; i<oifits->oit3->nbt3; i++)
    {

        index1 = oifits->oit3->list_t3[i]->stationindex[0];
        index2 = oifits->oit3->list_t3[i]->stationindex[1];
        index3 = oifits->oit3->list_t3[i]->stationindex[2];
        flag = 0;
        /* /\*one calib file *\/ */
        /* if (nbBlockTotal == 1) */
        /* { */
        /*     for (k = 0; k < oifitscal[0]->oit3->nbt3 ; k++ ) */
        /*     { */
        /*      /\*on cherche la ligne correspondante  */
        /*        dans le fichier de calib*\/ */
        /*      if(oifitscal[0]->oit3->list_t3[k]->stationindex[0] */
        /*         == index1 */
        /*         && oifitscal[0]->oit3->list_t3[k]->stationindex[1] */
        /*         == index2 */
        /*         && oifitscal[0]->oit3->list_t3[k]->stationindex[2] */
        /*         == index3 */
        /*          )                    */
        /*      { */
        /*          /\* data and error*\/ */
        /*          for (l=0; l < oifits->oit3->nbchannel; l++ ) */
        /*          { */
        /*              aux[l][0] = oifitscal[0]->oit3->list_t3[k]-> */
        /*                  t3phi[l]; */
        /*              auxerr[l][0] = oifitscal[0]->oit3->list_t3[k]-> */
        /*                  t3phierr[l]; */
        /*          } */
        /*          break; */
        /*      } */
        /*     } */
        /* } */
        /* /\*nbOfitscal calib files*\/ */
        /* else */
        /* { */
        cpt=0;
            for(j=0; j<nbOifitscal; j++ ) {
                for(m=0;m<nbBlock[j];m++) {
                    for (k = 0; k < nbTriplet; k++ ) {
                        /*on cherche la ligne correspondante 
                          dans le fichier de calib*/ 
                        if(oifitscal[j]->oit3->list_t3[k]->stationindex[0]
                           == index1
                           && oifitscal[j]->oit3->list_t3[k]->stationindex[1]
                           == index2
                           && oifitscal[j]->oit3->list_t3[k]->stationindex[2]
                           == index3) {
                            for (l=0; l < oifits->oit3->nbchannel; l++ ) {      
                                aux[l][cpt]=oifitscal[j]->oit3->
                                    list_t3[k+m*nbTriplet]->t3phi[l] * CPL_MATH_RAD_DEG;
                                auxerr[l][cpt]=oifitscal[j]->oit3->
                                    list_t3[k+m*nbTriplet]->t3phierr[l] * CPL_MATH_RAD_DEG;
                            }
                            /* flag = 1; */
                        }
                        /* if (flag == 1) */
                        /*     break; */
                    }
                    cpt++;
                }
            }
        /* } */
        for (l=0; l < oifitscal[0]->oit3->nbchannel; l++ )
        {        
            /* mean */
            data[l]=0.;
            dataerr[l]=0.;
            cpt=0;
	    valRe = 0;
	    valIm = 0;
            for(j=0; j<nbOifitscal; j++ )
            {
                for(m=0;m<nbBlock[j];m++)
		{ 
                    /* Avoid phase wrapping by doing addition of
		       phasor in complex plane. */
                    phasorRe  = cos( aux[l][cpt] );
                    phasorIm  = sin( aux[l][cpt] );
                    /* Real part */
                    valRe += phasorRe;
                    /* Imaginary part */
                    valIm += phasorIm;
                             
                    dataerr[l] += pow(auxerr[l][cpt],2.0);
                    cpt++;
                }
            }
            data[l]     = atan2(valIm, valRe);
            dataerr[l] /= nbBlockTotal;
            
            /* Subtract transfer function's phase to object's phase.
            Avoid phase wrapping by doing subtraction in complex
            plane.  Buildup a phasor with amplitude of 1 out of the
            differential phase */
            phi = oifits->oit3->list_t3[i]->t3phi[l] * CPL_MATH_RAD_DEG;
            phasorRe = cos(phi);
            phasorIm = sin(phi);
            /* calculate phasor from transfer function */
            phasorTF_Re = cos(data[l]);
            phasorTF_Im = sin(data[l]);

            /* Real part */
            valRe = phasorRe * phasorTF_Re + phasorIm * phasorTF_Im;
            /* Imaginary part */
            valIm = phasorTF_Re * phasorIm - phasorRe * phasorTF_Im;

            /* get back phase */
            oifits->oit3->list_t3[i]->t3phi[l] = atan2(valIm, valRe) * CPL_MATH_DEG_RAD;

            /* errors computation */
            oifits->oit3->list_t3[i]->t3phierr[l] = 
                sqrt(pow(oifits->oit3->list_t3[i]->t3phierr[l],2.0)+dataerr[l]);
        } 
    }

    /*qc parameters*/
    if ( !strcmp(oifits->oivis2->insname,"MATISSE"))
    {
        pszChipName=
            (char *)cpl_propertylist_get_string(oifits->keywords,
                                                "ESO DET CHIP NAME");
        if (pszChipName == NULL) {
        
            cpl_free(aux);
            cpl_free(auxerr);
            cpl_free(data);
            cpl_free(dataerr);
            cpl_msg_error(cpl_func,"No ESO DET CHIP NAME keyword");
            cpl_free(nbBlock);
            return 1;
        }
        if(strcmp(pszChipName, "AQUARIUS") == 0) {
            indexChipName=2;
        }
        else if(strcmp(pszChipName, "HAWAII2RG") == 0) {
            indexChipName=1;
        }
    }
    else
        indexChipName=3;
    for (i=0; i<oifits->oit3->nbt3; i++)
    {
        mean = 0.0;
        stdev = 0.0;
        qcname1=cpl_sprintf("ESO QC DET%d CALCPHASE%d ",indexChipName,i+1);
        qcname2=cpl_sprintf("ESO QC DET%d CALCPHASE%d STDEV ", indexChipName,i+1);
        for(j=0; j<oifits->oit3->nbchannel; j++ )
        {
            mean = mean +  oifits->oit3->list_t3[i]->t3phi[j];
        }
        mean = mean/oifits->oit3->nbchannel;
        for (j=0; j<oifits->oit3->nbchannel; j++)
        {
            stdev =pow(oifits->oit3->list_t3[i]->t3phi[j]-mean, 2.0);
        }
        stdev = sqrt(stdev/oifits->oit3->nbchannel);

        cpl_propertylist_append_double(qclist, qcname1, mean);
        cpl_propertylist_append_double(qclist, qcname2, stdev);
        cpl_free(qcname1);
        cpl_free(qcname2);
    }
    cpl_propertylist_append(oifits->keywords, qclist);

    /*free memory*/
    cpl_propertylist_delete(qclist);
    for(j=0; j<oifits->oit3->nbchannel; j++ )
    {
        cpl_free(aux[j]);
        cpl_free(auxerr[j]);
    }
    cpl_free(aux); 
    cpl_free(auxerr); 
    cpl_free(data);  
    cpl_free(dataerr);  

    /* save */
    oifits->oivis = NULL;
    oifits->oispect = NULL; 
    oifits->oivis2 = NULL; 
    it= cpl_frameset_iterator_new(frameset);
    cur_frame = cpl_frameset_iterator_get(it);
    cpl_frameset_iterator_delete(it);
    filename=cpl_sprintf("CALCPHASE_%s",basename((char *)cpl_frame_get_filename(cur_frame)));
    mat_oifits_save(oifits, frameset, usedframes, parlist,recname, filename, 7);

    cpl_propertylist_delete(p_list_oitransfunc);
    cpl_frameset_delete(usedframes);
    mat_oifits_delete(oifits);
    for(i=0; i<nbfile-1; i++)
    {
        mat_oifits_delete(oifitscal[i]);
    }
    cpl_free(oifitscal);
    cpl_free(filename);
    cpl_free(nbBlock);
    return 0;
}



