/* $Id: mat_compute_phidiff.h,v0.5 2014-06-15 12:56:21 fmillour Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fmillour $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_compute_phidiff.h $
 */

#ifndef MAT_COMPUTE_PHIDIFF_H
#define MAT_COMPUTE_PHIDIFF_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include <string.h>
#include <stdio.h>
#include "mat_drl.h"
#include "mat_utils.h"
#include "mat_shift.h"
#include "mat_photbeams.h"
#include "mat_corrflux.h"
#include "mat_oifits.h"
#include "mat_opd_wvpo.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
int mat_compute_phidiff(mat_corrflux *corrFlux,
			mat_photbeams *phot,
			mat_oifits *oifits,
			mat_oiopdwvpo *oiopdwvpo);
//,cpl_parameter *useAvgPhot);
int mat_compute_coherent_observable(mat_corrflux *corrFlux,
				    mat_photbeams *phot,
				    mat_oifits *oifits,
				    mat_oiopdwvpo *oiopdwvpo);

void mat_get_correlated_flux(mat_corrflux *corrflux,int nbBases,int nbFrameTarget,
			     cpl_vector *dispCoef,int detNum,int resolution,
			     cpl_image **imgcurrentReal,cpl_image **imgcurrentImag,int iReg);
  
void mat_get_error_vis(mat_oiopdwvpo *oiopdwvpo,int nbBases,int nbWave,int nbFrameTarget,double lambdamin, double lambdamax,
		       cpl_image **imgcurrentReal,cpl_image **imgcurrentImag,cpl_image *viserr,cpl_vector *vecphiStaticErr[]);

void mat_get_visamp_visphi(cpl_image **imgcurrentReal,cpl_image **imgcurrentImag,mat_oiopdwvpo *oiopdwvpo,int nbWave,
			   int nbBases,int nbFrameTarget,double lambdamin,double lambdamax,cpl_image *viserr,
			   cpl_vector *vecphiStatic[],cpl_image *vis);

#endif
