/* $Id: mat_const.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_const.h $
 */

#ifndef MAT_CONST_H
#define MAT_CONST_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

#define MAT_MAXTEL  4

#define MAT_PREC_GAIN         3
#define MAT_PREC_NOISE        2
#define MAT_PREC_INTENSITY    1
#define MAT_PREC_VARIANCE     3
#define MAT_PREC_FREQUENCY    1
#define MAT_PREC_POWER        1
#define MAT_PREC_CORRELATION  3
#define MAT_PREC_REMANENCE    3
#define MAT_PREC_SCALE        6

#define MAT_WINDOW_NONE      0
#define MAT_WINDOW_GAUSS     1
#define MAT_WINDOW_LANCZOS   2
#define MAT_WINDOW_BLACKMAN  3

#define MAT_PSPEAKCOUNT    5

#define BYTE_MAX_PER_GENDATA 81000000.0
#define SIZE_MAX_KEYWORDS 30
#define D_OVER_LAMBDA (19.5/3.)

#define NO_COMPENSATION                    0
#define PIXEL_BIAS_COMPENSATION            (1 << 0)
#define GLOBAL_BIAS_COMPENSATION           (1 << 1)
#define CHANNEL_BIAS_COMPENSATION          (1 << 2)
#define HORIZONTAL_BIAS_COMPENSATION       (1 << 3)
#define VERTICAL_BIAS_COMPENSATION         (1 << 4)
#define CROSSTALK_COMPENSATION             (1 << 5)
#define NONLINEARITY_COMPENSATION          (1 << 6)
#define DETECTOR_FLATFIELD_COMPENSATION    (1 << 7)
#define INSTRUMENT_FLATFIELD_COMPENSATION  (1 << 8)
#define BADPIXEL_COMPENSATION              (1 << 9)
#define DISTORTION_COMPENSATION            (1 << 10)
#define CONVERSION_COMPENSATION            (1 << 11)
#define FULL_COMPENSATION                  ((1 << 12) - 1)
#define RAMP_COMPENSATION                  (1 << 13)

#define MAT_NO_REF                    0
#define MAT_LEFT_REF                  (1 << 0)
#define MAT_RIGHT_REF                 (1 << 1)
#define MAT_BOTTOM_REF                (1 << 2)
#define MAT_TOP_REF                   (1 << 3)
#define MAT_DC_REF                    (1 << 4)

#define TARTYP_NOTHING               0
#define TARTYP_CHOP_SSSUTTTU         (1 << 0)
#define TARTYP_SHOW_INTENSITY        (1 << 1)
#define TARTYP_SHOW_CORRELATION      (1 << 2)
#define TARTYP_ESTIMATE_TARTYP       (1 << 3)
#define TARTYP_CHANGE_TARTYP         (1 << 4)
#define TARTYP_REMOVE_TARTYP_U       (1 << 5)
#define TARTYP_CHANGE_TIME           (1 << 6)
#define TARTYP_CHANGE_OPD            (1 << 7)
#define TARTYP_SHOW_SETUP            (1 << 8)
#define TARTYP_SHOW_CHOPPING         (1 << 9)
#define TARTYP_SHOW_TIMETABLE        (1 << 10)
#define TARTYP_SHOW_RESULT           (1 << 11)
#define TARTYP_USE_WAVE_FIT_SHIFT    (1 << 12)
#define TARTYP_USE_TIME_SHIFT        (1 << 13)
#define TARTYP_USE_CENTER_INTERF     (1 << 14)

#define MAT_EXCESS_COUNT_UNSET       -1
/*
  Scale the measured DU values before fitting the nonlinearity curve.
  This scaling has to be used when the nonlinearity is compensated.
*/
#define MAT_DU_SCALE  10000.0

#define MATISSE_BPM_PROCATG "BADPIX"
#define MATISSE_FFM_PROCATG "FLATFIELD"
#define MATISSE_NLM_PROCATG "NONLINEARITY"
#define MATISSE_IMB_PROCATG "IM_BASIC"
#define MATISSE_IME_PROCATG "IM_EXTENDED"
#define MATISSE_IMR_PROCATG "IM_REMANENCE"
#define MATISSE_OFM_PROCATG "OBS_FLATFIELD"

#define MATISSE_FFM_STDERR_EXT  "FFSTDERR" /*!< Extension name for the error map of the flatfield map. */
#define MATISSE_NLM_COEFF_EXT   "NLCOEFF"
#define MATISSE_NLM_STDERR_EXT  "NLSTDERR"
#define MATISSE_NLM_RCMAP_EXT   "NLRCMAP"
#define MATISSE_NLM_HIST_EXT    "NLHIST"
#define MATISSE_IMB_STAT_EXT    "IM_STATISTICS"
#define MATISSE_IMB_FASTPS_EXT  "IM_FAST_POWERSPECTRUM"
#define MATISSE_IMB_SLOWPS_EXT  "IM_SLOW_POWERSPECTRUM"
#define MATISSE_OFM_OBSFLAT_EXT "OBS_FLAT_BIAS"

#endif

