/* $Id: mat_corrflux.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_corrflux.h $
 */

#ifndef MAT_CORRFLUX_H
#define MAT_CORRFLUX_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <assert.h>
#include "mat_drl.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Data Structures
 -----------------------------------------------------------------------------*/
/* Structure mat_corrflux */
/**
   @defgroup corrflux Correlated Flux
*/
/**
   @ingroup corrflux
   @brief Structure containing the correlated flux.
*/
typedef struct {
    cpl_propertylist       *keywords;            /* primary header            */
    int                     nbframe;             /* number of frame           */
    mat_imgcorr            **list_corr;           /* array struct of corr      */
  mat_imagingdetector    *imgdet;              /* detector geometry         */
} mat_corrflux;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

mat_corrflux *mat_corrflux_load(cpl_frame *frame);
cpl_error_code mat_corrflux_free(mat_corrflux *corr);
cpl_error_code mat_corrflux_save(
				 mat_corrflux *corr,
				 cpl_propertylist *pheader, 
				 cpl_frameset *set_in,
				 cpl_frameset *set_sel,
				 const cpl_parameterlist *parlist,
				 const char *recipe_name,
				 const char *pro_cat,
				 const char *pro_tech,
				 const char *pro_sci,
				 char *filename);



#endif
