/* $Id: mat_error.h,v0.5 2014-06-15 12:56:21 mhein Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: heininger $
 * $Date: 2011/04/14 15:25:00 $
 * $Revision: 1.0 $
 * $Name: mat_drl $
 */

#ifndef MAT_ERROR_H
#define MAT_ERROR_H


/*-----------------------------------------------------------------------------
                      Includes
------------------------------------------------------------------------------*/
#include <complex.h>
#include "cpl.h"

/*-----------------------------------------------------------------------------
                      Defines
------------------------------------------------------------------------------*/
#define mat_assert(BOOL, CODE, ...) cpl_error_ensure(BOOL, CODE, return CODE, __VA_ARGS__)

#define mat_assert_not_null(PTR, ...) cpl_error_ensure(((PTR) != NULL), CPL_ERROR_NULL_INPUT,  return CPL_ERROR_NULL_INPUT, __VA_ARGS__)

#define mat_assert_value(BOOL, CODE, RETURN, ...) cpl_error_ensure(BOOL, CODE, return RETURN, __VA_ARGS__)

#endif
