/* $Id: mat_est_opd_lib.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_est_opd_lib.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#include <string.h>
#endif

/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include "mat_est_opd_lib.h"
#include "mat_error.h"

/*-----------------------------------------------------------------------------
  Define
  ----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  Functions prototypes
  ----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
   @brief Estimation of the OPD and the water vapor offset
   @param frameset           contains the frames
   @param parlist            contains the recipes parameters
   @param recname            Name of the recipes calling this function
   @return 0 if no error 
*/
int mat_est_opd_lib(cpl_frameset *frameset,
		    cpl_parameterlist *parlist,
		    const char *recname) {
    
  /* cpl_parameter *chromaticOpdFit=NULL; */
  cpl_frame *cur_frame=NULL;
  cpl_frame *sel_frame=NULL;
  char *pszFileName=NULL;
  char *pszFileTag=NULL;
  char *detName=NULL;
  char *sliderPhot=NULL;
  char mode[3]=" ";
  char modeFirst[3]=" ";
  char *bcd1Status=NULL;
  char *bcd2Status=NULL;
  char bcd1StatusFirst[100]="";
  char bcd2StatusFirst[100]="";
  cpl_propertylist *plist=NULL;
  int i=0;
  int j=0;
  int cpt=0;
  int nbCorrFlux=0;
  /* int ixCorrFlux=0; */
  mat_corrflux **corrFlux=NULL;
  /* cpl_matrix *dispCoef=NULL; */
  mat_oiopdwvpo **oiopdwvpo=NULL;
  cpl_frameset *usedframes=NULL;
  char *filename=NULL;
  cpl_frame *frameCorrFlux=NULL;
  cpl_frameset_iterator *it=NULL;
  cpl_errorstate prestate = cpl_errorstate_get();
  int indexFile=1;
  int nbdetector = 0;
  char *protech=NULL;
  cpl_propertylist *qclist=NULL;

  //	 Check input parameters
  mat_assert_value((frameset != NULL),CPL_ERROR_NULL_INPUT,
		   CPL_ERROR_NULL_INPUT, "no frameset argument given");
  /* // 0. Retrieve parameter */
  /* chromaticOpdFit=cpl_parameterlist_find(parlist, */
  /* 				     "matisse.mat_est_opd.ChromaticOpdFit"); */
  // 1. Check the data type of the input frames
  cpt=0;
  prestate=cpl_errorstate_get();
  it= cpl_frameset_iterator_new(frameset);
  do {
    cur_frame = cpl_frameset_iterator_get(it);
    if (cur_frame != NULL) {
      pszFileName = (char*)cpl_frame_get_filename( cur_frame );
      pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
      plist=cpl_propertylist_load(pszFileName,0);
      protech=(char *)cpl_propertylist_get_string(plist,"ESO PRO TECH");
      if (strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0 && strstr(protech,"NOFRINGE") == NULL) {
	nbCorrFlux++;
	detName=(char *)cpl_propertylist_get_string(plist,"ESO DET CHIP NAME");
	if (detName == NULL) {
	  cpl_msg_error(cpl_func,"no ESO DET CHIP NAME keyword in frame");
	  return -1;
	}
	if (cpl_propertylist_has(plist,"ESO INS BCD1 ID") &&
	    cpl_propertylist_has(plist,"ESO INS BCD2 ID")) {
	  bcd1Status = (char *)cpl_propertylist_get_string(plist,"ESO INS BCD1 ID");
	  bcd2Status = (char *)cpl_propertylist_get_string(plist,"ESO INS BCD2 ID");
	} else {
	  cpl_msg_error(cpl_func,"no BCD keyword found in frame %s",pszFileName);
	  return -1;
	}
	if(!strcmp(detName, "AQUARIUS")) {
	  nbdetector=2;
	  sliderPhot=(char *)cpl_propertylist_get_string(plist,"ESO INS PIN NAME");	
	}
	else {
	  nbdetector=1;
	  sliderPhot=(char *)cpl_propertylist_get_string(plist,"ESO INS PIL NAME");	
	}
	if (!strcmp(sliderPhot, "PHOTO")) {
	  sprintf(mode,"s");
	} else {
	  sprintf(mode,"h");
	}
	if (cpt == 0 ) {
	  strncpy(bcd1StatusFirst,bcd1Status,100-1); bcd1StatusFirst[100-1] = '\0';
	  strncpy(bcd2StatusFirst,bcd2Status,100-1); bcd2StatusFirst[100-1] = '\0';
	  strncpy(modeFirst,mode,3);
	} 
	cpt++;
      }
      // Get next frame from SOF
      cpl_propertylist_delete(plist);
    }
  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
  cpl_frameset_iterator_delete(it);
  if (!cpl_errorstate_is_equal(prestate)) {
    cpl_errorstate_set(prestate);
  }

  if (nbCorrFlux == 0)
    {
     cpl_msg_error(cpl_func,"No fringes data in this Reduction Block");
     return -1;
    }
     

  corrFlux=cpl_calloc(nbCorrFlux,sizeof(mat_corrflux *));
  if (corrFlux == NULL) {
    cpl_msg_error(cpl_func,"could not allocate memory for corrFlux");
    return -1;
  }

  // 2.LoadOBJ_CORR_FLUX
  //   Initialization of the mat_oiopdwvpo structure
  oiopdwvpo=cpl_calloc(nbCorrFlux,sizeof(mat_oiopdwvpo *));
  /* ixCorrFlux=0; */
  cpl_msg_info(cpl_func,"Loading OBJ_CORR_FLUX");
  /* dispCoef=cpl_matrix_new(3,nbCorrFlux); */

  /* prestate=cpl_errorstate_get(); */
  /* it= cpl_frameset_iterator_new(frameset); */
  /* do { */
  /*   cur_frame = cpl_frameset_iterator_get(it); */
  /*   if (cur_frame != NULL) { */
  /*     pszFileName = (char*)cpl_frame_get_filename( cur_frame ); */
  /*     pszFileTag = (char *)cpl_frame_get_tag( cur_frame ); */
  /*     plist=cpl_propertylist_load(pszFileName,0); */
  /*     if (strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0) { */
  /* 	cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW); */
  /* 	corrFlux[ixCorrFlux] = mat_corrflux_load(cur_frame); */
  /* 	/\* cpl_matrix_set(dispCoef,0,ixCorrFlux, *\/ */
  /* 	/\* 	       cpl_propertylist_get_double( *\/ */
  /* 	/\* 					   corrFlux[ixCorrFlux]->keywords, *\/ */
  /* 	/\* 					   "PRO DISP COEF0")); *\/ */
  /* 	/\* cpl_matrix_set(dispCoef,1,ixCorrFlux, *\/ */
  /* 	/\* 	       cpl_propertylist_get_double( *\/ */
  /* 	/\* 					   corrFlux[ixCorrFlux]->keywords, *\/ */
  /* 	/\* 					   "PRO DISP COEF1")); *\/ */
  /* 	/\* cpl_matrix_set(dispCoef,2,ixCorrFlux, *\/ */
  /* 	/\* 	       cpl_propertylist_get_double( *\/ */
  /* 	/\* 					   corrFlux[ixCorrFlux]->keywords, *\/ */
  /* 	/\* 					   "PRO DISP COEF2")); *\/ */

  /* 	/\* Initializing the mat_oiopdwvpo structure *\/ */
  /* 	oiopdwvpo[ixCorrFlux]=cpl_malloc(sizeof(mat_oiopdwvpo)); */
  /* 	mat_oiopdwvpo_init_from_corrflux(corrFlux[ixCorrFlux],oiopdwvpo[ixCorrFlux]); */
  /* 	ixCorrFlux++; */
  /*     } */
  /*     cpl_propertylist_delete(plist); */
  /*   } */
  /* } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE); */
  /* cpl_frameset_iterator_delete(it); */
  /* if (!cpl_errorstate_is_equal(prestate)) { */
  /*   cpl_errorstate_set(prestate); */
  /* } */

  // Start estimation of OPD and Water Vapor Offset
  for(i=0;i<nbCorrFlux;i++) {

    // Preparing usedframes frameset
    /* k=0; */
    j=0;
    prestate=cpl_errorstate_get();
    it= cpl_frameset_iterator_new(frameset);
    do {
      cur_frame = cpl_frameset_iterator_get(it);
      if (cur_frame != NULL) {
	pszFileName = (char*)cpl_frame_get_filename( cur_frame );
    	pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
	plist=cpl_propertylist_load(pszFileName,0);
	protech=(char *)cpl_propertylist_get_string(plist,"ESO PRO TECH");
    	if (strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0 && strstr(protech,"NOFRINGE") == NULL) {
    	  if (i==j) {
	    //cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
	    corrFlux[i] = mat_corrflux_load(cur_frame);
	    bcd1Status = (char *)cpl_propertylist_get_string(corrFlux[i]->keywords,"ESO INS BCD1 ID");
	    bcd2Status = (char *)cpl_propertylist_get_string(corrFlux[i]->keywords,"ESO INS BCD2 ID");
	    oiopdwvpo[i]=cpl_malloc(sizeof(mat_oiopdwvpo));
	    mat_oiopdwvpo_init_from_corrflux(corrFlux[i],oiopdwvpo[i]);
	    cpl_propertylist_erase(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE");
		   
	    if (strcmp(bcd1Status, "OUT") == 0 && strcmp(bcd2Status, "OUT") == 0)
	      {
		cpl_propertylist_append_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE","OUT-OUT");
	      }
	    if (strcmp(bcd1Status, "IN") == 0 && strcmp(bcd2Status, "IN") == 0)
	      {
		cpl_propertylist_append_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE","IN-IN");
	      }
	    if (strcmp(bcd1Status, "IN") == 0 && strcmp(bcd2Status, "OUT") == 0)
	      {
		cpl_propertylist_append_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE","IN-OUT");
	      }
	    if (strcmp(bcd1Status, "OUT") == 0 && strcmp(bcd2Status, "IN") == 0)
	      {
		cpl_propertylist_append_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE","OUT-IN");
	      }
   	    frameCorrFlux=cpl_frame_new();
    	    cpl_frame_set_filename(frameCorrFlux,cpl_frame_get_filename(cur_frame));
    	    cpl_frame_set_group(frameCorrFlux,cpl_frame_get_group(cur_frame));
    	    cpl_frame_set_level(frameCorrFlux,cpl_frame_get_level(cur_frame));
    	    cpl_frame_set_tag(frameCorrFlux,pszFileTag);
    	    cpl_frame_set_type(frameCorrFlux,cpl_frame_get_type(cur_frame));
    	  }
    	  j++;
    	}
	cpl_propertylist_delete(plist);
      }
    } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
    cpl_frameset_iterator_delete(it);
    if (!cpl_errorstate_is_equal(prestate)) {
      cpl_errorstate_set(prestate);
    }
    //3. OPD and Water Vapor Estimation
    /* mat_opd_wvpo(corrFlux[i],oiopdwvpo[i],chromaticOpdFit); */
    char *filename_gra=NULL;
    filename_gra = mat_get_fname_gra(cpl_propertylist_get_int(corrFlux[i]->keywords,"ESO TPL EXPNO"),
				     frameset);    
    mat_opd_wvpo(corrFlux[i],oiopdwvpo[i],filename_gra);

    //4. QC parameters
    double val,val2,valmax,valmax2;
    char kwd[64];
    valmax2=0.;
    for(int iBase=0;iBase<6;iBase++)
      {
	val=0.;
	val2=0.;
	valmax=0.;
	for(int iFrame=0;iFrame<oiopdwvpo[i]->oiopd->nbopd/6;iFrame++)
	  {
	    val+=oiopdwvpo[i]->oiopd->list_opd[iFrame*6+iBase]->opd;
	    val2+=pow(oiopdwvpo[i]->oiopd->list_opd[iFrame*6+iBase]->opd,2.0);
	    if (fabs(oiopdwvpo[i]->oiopd->list_opd[iFrame*6+iBase]->opd) >= valmax)
	      {
		valmax=fabs(oiopdwvpo[i]->oiopd->list_opd[iFrame*6+iBase]->opd);
	      }
	  }
	val/=(oiopdwvpo[i]->oiopd->nbopd/6);
	val2/=(oiopdwvpo[i]->oiopd->nbopd/6);
	val2-=(val*val);
	if (val2 < 0) val2=fabs(val2);
	if (val2 == 0) val2=1.E-6;
	snprintf(kwd, 64, "ESO QC DET%d OPDAVG%d",nbdetector,iBase+1);
	cpl_propertylist_append_double(oiopdwvpo[i]->keywords, kwd, val);
	snprintf(kwd, 64, "ESO QC DET%d OPDSTD%d",nbdetector,iBase+1);
	cpl_propertylist_append_double(oiopdwvpo[i]->keywords, kwd, sqrt(val2));

	snprintf(kwd, 64, "ESO QC MAX OPD%d",iBase+1);
	cpl_propertylist_append_double(oiopdwvpo[i]->keywords, kwd, valmax);
	if (valmax > valmax2)
	  {
	    valmax2=valmax;
	  }
      }
    cpl_propertylist_append_double(oiopdwvpo[i]->keywords, "ESO QC MAX OPD", valmax2);
   
    // Add Generic QC parameters
    qclist = cpl_propertylist_new();
    mat_add_generic_qc(oiopdwvpo[i]->keywords,qclist);
    cpl_propertylist_append(oiopdwvpo[i]->keywords,qclist);
    cpl_propertylist_delete(qclist);


    
    //5. Save oiopdwvpo
    // Fill usedframes depending on the way mat_ext_beams is called (atomic or master recipes)
    if (cpl_frameset_find(frameset,"CALIB_RAW") != NULL ||
	cpl_frameset_find(frameset,"TARGET_RAW") != NULL ||
	cpl_frameset_find(frameset,"CALIB_SRC_RAW") != NULL)
      {
	usedframes=cpl_frameset_new();
	it= cpl_frameset_iterator_new(frameset);
	do
	  {
	    cur_frame = cpl_frameset_iterator_get(it);
	    if (cur_frame != NULL)
	      {
		pszFileName = (char*)cpl_frame_get_filename( cur_frame );
		pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
		if (strcmp(pszFileTag, "CALIB_RAW") == 0 || strcmp(pszFileTag, "TARGET_RAW") == 0 || strcmp(pszFileTag, "CALIB_SRC_RAW") == 0)
		  {
		    plist=cpl_propertylist_load(pszFileName,0);
		    if (strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"OUT-OUT") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    else if(strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"IN-OUT") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    else if(strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"OUT-IN") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    else if(strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"IN-IN") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    cpl_propertylist_delete(plist);
		  }
	      }
	  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
	cpl_frameset_iterator_delete(it);
	it= cpl_frameset_iterator_new(frameset);
	do
	  {
	    cur_frame = cpl_frameset_iterator_get(it);
	    if (cur_frame != NULL)
	      {
		pszFileName = (char*)cpl_frame_get_filename( cur_frame );
		pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
		if (strcmp(pszFileTag, "CALIB_RAW") == 0 || strcmp(pszFileTag, "TARGET_RAW") == 0 || strcmp(pszFileTag, "CALIB_SRC_RAW") == 0)
		  {
		    plist=cpl_propertylist_load(pszFileName,0);
		    if (strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"OUT-OUT") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    else if(strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"IN-OUT") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    else if(strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"OUT-IN") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    else if(strcmp(cpl_propertylist_get_string(oiopdwvpo[i]->keywords,"ESO CFG BCD MODE"),"IN-IN") == 0)
		      {
			if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			    strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
			    cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oiopdwvpo[i]->keywords,"ESO TPL EXPNO"))
			  {
			    sel_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(usedframes,sel_frame);
			  }
		      }
		    cpl_propertylist_delete(plist);
		  }
		else if (strcmp(pszFileTag, "BADPIX") == 0 || strcmp(pszFileTag, "NONLINEARITY") == 0 ||
			 strcmp(pszFileTag, "SHIFT_MAP") == 0 || strcmp(pszFileTag, "KAPPA_MATRIX") == 0 ||
			 strcmp(pszFileTag, "OBS_FLATFIELD") == 0 || strcmp(pszFileTag, "JSDC_CAT") == 0 )
		  {
		    sel_frame=cpl_frame_duplicate(cur_frame);
		    cpl_frameset_insert(usedframes,sel_frame);
		  }
		       
	      }
	  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
	cpl_frameset_iterator_delete(it);
	it= cpl_frameset_iterator_new(frameset);
	do
	  {
	    cur_frame = cpl_frameset_iterator_get(it);
	    if (cur_frame != NULL)
	      {
		pszFileName = (char*)cpl_frame_get_filename( cur_frame );
		pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
		if (strcmp(pszFileTag, "SKY_RAW") == 0 || strcmp(pszFileTag, "HOT_DARK") == 0 )
		  {
		    sel_frame=cpl_frame_duplicate(cur_frame);
		    cpl_frameset_insert(usedframes,sel_frame);
		  }
	      }
	  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
	cpl_frameset_iterator_delete(it);
      }
    else
      {
	it= cpl_frameset_iterator_new(frameset);
	do
	  {
	    cur_frame = cpl_frameset_iterator_get(it);
	    if (cur_frame != NULL)
	      {
		pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
		if (strcmp(pszFileTag, "OBJ_CORR_FLUX") == 0 )
		  {
		    cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
		  }
	      }
	  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
	cpl_frameset_iterator_delete(it);    
	usedframes=cpl_frameset_new();
	cpl_frameset_insert(usedframes,frameCorrFlux);
	it= cpl_frameset_iterator_new(usedframes);
	do
	  {
	    cur_frame = cpl_frameset_iterator_get(it);
	    if (cur_frame != NULL)
	      {
		pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
		if (strcmp(pszFileTag, "OBJ_CORR_FLUX") == 0 )
		  {
		    cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
		  }
	      }
	  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
	cpl_frameset_iterator_delete(it);    
      }
    filename=cpl_sprintf("OI_OPDWVPO_%04d.fits",indexFile);
    mat_oiopdwvpo_save(oiopdwvpo[i],frameset,usedframes,parlist,recname,filename);
    indexFile++;
    cpl_frameset_delete(usedframes);
    cpl_free(filename);
    if (corrFlux[i] != NULL) {
      mat_corrflux_free(corrFlux[i]);
      corrFlux[i]=NULL;
    }
    
  }



  // ?. Free Memory

  for(i=0;i<nbCorrFlux;i++) {
    if (corrFlux[i] != NULL) {
      mat_corrflux_free(corrFlux[i]);
    }
  }
  if (corrFlux != NULL) {
    cpl_free(corrFlux);
  }
  /* if (dispCoef != NULL) { */
  /*   cpl_matrix_delete(dispCoef); */
  /* } */

  mat_oiopdwvpo_list_delete(oiopdwvpo,nbCorrFlux);
  return 0;
}
