/* $Id: mat_gendata.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_gendata.h $
 */

#ifndef MAT_GENDATA_H
#define MAT_GENDATA_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "mat_imagingdetector.h"
#include "mat_imagingdata.h"
#include "mat_array.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/**
   @ingroup gendata
*/
typedef struct {
    cpl_propertylist     *keywords;              /* primary header            */
    mat_imagingdetector  *imgdet;                /* detector geometry         */
    mat_imagingdata      *imgdata;               /* data                      */
    mat_array            *array;                 /* array geometry            */
} mat_gendata;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code mat_gendata_delete(mat_gendata *genData);

mat_gendata *mat_gendata_duplicate(const mat_gendata *gen,
				   cpl_type type);

mat_gendata *mat_gendata_load_window(cpl_frame *frame,
				     int start,
				     int length,
				     cpl_type type);

mat_gendata *mat_gendata_load_skip(cpl_frame *frame,
				   int nditskip,
				   cpl_type type);

mat_gendata *mat_gendata_load(cpl_frame *frame,
			      cpl_type type);

cpl_error_code mat_gendata_save(mat_gendata *gendata,
				cpl_frameset *set_in,
				cpl_frameset *set_sel,
				const cpl_parameterlist *parlist,
				const char *recipe_name,
				const char *pro_cat,
				const char *pro_tech,
				const char *pro_sci,
				char *filename,
				cpl_type type);

cpl_error_code mat_gendata_append(mat_gendata *gendata,
				  char *filename,
				  cpl_type type);


#endif
