/* $Id: mat_image.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2016/04/11 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_image.h $
 */

#ifndef MAT_IMAGE_H
#define MAT_IMAGE_H

/*-----------------------------------------------------------------------------
                      Includes
------------------------------------------------------------------------------*/
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <complex.h>

#include <cpl.h>

#define FWHM2SIGMA sqrt(-0.125/log(0.5))
#define FWHM2SIGMA2 (-0.125/log(0.5))
#define FWHM2LDA 2.0*sqrt(pow(2.0, 2.0/3.0) - 1.0)

#define MAT_IS_LESS       -1
#define MAT_IS_INSIDE      0
#define MAT_IS_GREATER    +1
#define MAT_IS_INFINITE    2
#define MAT_IS_NAN         3

void mat_image_swap(cpl_image *img);
double mat_image_get_total(cpl_image *img);
void mat_image_normalize(cpl_image *img);
void mat_image_fill(cpl_image *img, double complex v);

double mat_image_get_double(cpl_image *img, int x, int y);
void mat_image_set_double(cpl_image *img, int x, int y, double v);
void mat_image_add_double(cpl_image *img, int x, int y, double v);

double complex mat_image_get_complex(cpl_image *img, int x, int y);
void mat_image_set_complex(cpl_image *img, int x, int y, double complex v);
void mat_image_add_complex(cpl_image *img, int x, int y, double complex v);

double mat_image_get_double_interpolated(cpl_image *src, double x, double y);
void mat_image_add_double_interpolated(cpl_image *dst, double x, double y, double val);

double complex mat_image_get_complex_interpolated(cpl_image *src, double x, double y);
void mat_image_add_complex_interpolated(cpl_image *dst, double x, double y, double complex val);

void mat_image_fft_forward(cpl_image *dst, cpl_image *src);
void mat_image_fft_backward(cpl_image *dst, cpl_image *src, double complex scale);

void mat_image_get_centroid(cpl_image *img, double *cx, double *cy);

void mat_image_round(cpl_image *img, int precision);
void mat_image_round_relative(cpl_image *img, int precision);

cpl_error_code mat_image_scale(cpl_image *dst, double dstscale, cpl_image *src, double srcscale);
cpl_error_code mat_image_shift(cpl_image *dst, double xshift, double yshift, cpl_image *src);

void mat_image_calc_tent(cpl_image *tent, double r0);
void mat_image_calc_gaussian(cpl_image *gaussian, double r0);
void mat_image_convolve(cpl_image *dst, cpl_image *src, cpl_image *tent, cpl_image *hci);

cpl_error_code mat_image_store_double(cpl_image *img,
				      const char *fname,
				      const char *catg,
				      cpl_parameterlist *parlist,
				      cpl_frameset *frameset);
cpl_error_code mat_imagelist_store_double(cpl_imagelist *img_list,
					  const char *fname,
					  const char *catg,
					  cpl_parameterlist *parlist,
					  cpl_frameset *frameset);
cpl_error_code mat_image_store_complex(cpl_image *cimg,
				       const char *fname,
				       const char *catg,
				       cpl_parameterlist *parlist,
				       cpl_frameset *frameset);

cpl_error_code mat_image_create_gaussian(cpl_image *img, double fwhm);
cpl_error_code mat_image_create_lorentzian(cpl_image *img, double fwhm);

cpl_error_code mat_image_get_quantils(cpl_image *img, int nquantils, double *quantils, double *values);

cpl_error_code mat_image_validate(cpl_image *img, cpl_image *mask, double lower, double upper, const char *label);

cpl_error_code mat_image_store_plain_stl(const char *fname, const cpl_image *img, int x, int y, int nx, int ny, double zscale);
cpl_error_code mat_image_store_column_stl(const char *fname, const cpl_image *img, int x, int y, int nx, int ny, double zscale);
cpl_error_code mat_image_store_pyramid_stl(const char *fname, const cpl_image *img, int x, int y, int nx, int ny, double zscale);

#endif
